/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.groups.local.searchers;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.RDBMServices;
import org.jasig.portal.groups.GroupsException;
import org.jasig.portal.groups.local.ITypedEntitySearcher;
import org.jasig.portal.services.LogService;

public class RDBMPersonSearcher
implements ITypedEntitySearcher {
    private static final String user_is_search = "select USER_NAME from UP_USER where USER_NAME=?";
    private static final String user_partial_search = "select USER_NAME from UP_USER where USER_NAME like ?";
    private static final String person_partial_search = "select USER_NAME from UP_PERSON_DIR where (FIRST_NAME like ? or LAST_NAME like ?)";
    private static final String person_is_search = "select USER_NAME from UP_PERSON_DIR where (FIRST_NAME = ? or LAST_NAME = ?)";
    private Class personDef;

    public RDBMPersonSearcher() {
        try {
            this.personDef = Class.forName("org.jasig.portal.security.IPerson");
        }
        catch (Exception e) {
            LogService.log(LogService.ERROR, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityIdentifier[] searchForEntities(String query, int method) throws GroupsException {
        EntityIdentifier[] r = new EntityIdentifier[]{};
        ArrayList<EntityIdentifier> ar = new ArrayList<EntityIdentifier>();
        Connection conn = null;
        RDBMServices.PreparedStatement ps = null;
        RDBMServices.PreparedStatement ups = null;
        RDBMServices.PreparedStatement uis = null;
        try {
            conn = RDBMServices.getConnection();
            uis = new RDBMServices.PreparedStatement(conn, user_is_search);
            switch (method) {
                case 1: {
                    ps = new RDBMServices.PreparedStatement(conn, person_is_search);
                    ups = uis;
                    break;
                }
                case 2: {
                    query = query + "%";
                    ps = new RDBMServices.PreparedStatement(conn, person_partial_search);
                    ups = new RDBMServices.PreparedStatement(conn, user_partial_search);
                    break;
                }
                case 3: {
                    query = "%" + query;
                    ps = new RDBMServices.PreparedStatement(conn, person_partial_search);
                    ups = new RDBMServices.PreparedStatement(conn, user_partial_search);
                    break;
                }
                case 4: {
                    query = "%" + query + "%";
                    ps = new RDBMServices.PreparedStatement(conn, person_partial_search);
                    ups = new RDBMServices.PreparedStatement(conn, user_partial_search);
                    break;
                }
                default: {
                    throw new GroupsException("Unknown search type");
                }
            }
            ps.clearParameters();
            ps.setString(1, query);
            ps.setString(2, query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                uis.clearParameters();
                uis.setString(1, rs.getString(1));
                ResultSet urs = uis.executeQuery();
                if (!urs.next()) continue;
                ar.add(new EntityIdentifier(urs.getString(1), this.personDef));
            }
            ups.clearParameters();
            ups.setString(1, query);
            ResultSet uprs = ups.executeQuery();
            while (uprs.next()) {
                ar.add(new EntityIdentifier(uprs.getString(1), this.personDef));
            }
            ps.close();
            uis.close();
            ups.close();
        }
        catch (Exception e) {
            LogService.log(LogService.ERROR, "RDBMChannelDefSearcher.searchForEntities(): " + ps);
            LogService.log(LogService.ERROR, e);
        }
        finally {
            RDBMServices.releaseConnection(conn);
        }
        return ar.toArray(r);
    }

    public Class getType() {
        return this.personDef;
    }
}

