/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.jasig.portal.layout.IALNodeProperties;
import org.jasig.portal.layout.restrictions.IUserLayoutRestriction;
import org.jasig.portal.utils.CommonUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ALNodeProperties {
    protected String fragmentId = null;
    protected String fragmentNodeId = null;
    protected Hashtable restrictions = null;
    protected String group = "";

    public ALNodeProperties() {
    }

    public ALNodeProperties(IALNodeProperties p) {
        this();
        this.fragmentId = p.getFragmentId();
        this.fragmentNodeId = p.getFragmentNodeId();
        this.restrictions = p.getRestrictions();
        this.group = p.getGroup();
    }

    public void setFragmentId(String fragmentId) {
        this.fragmentId = fragmentId;
    }

    public String getFragmentId() {
        return this.fragmentId;
    }

    public void setFragmentNodeId(String fragmentNodeId) {
        this.fragmentNodeId = fragmentNodeId;
    }

    public String getFragmentNodeId() {
        return this.fragmentNodeId;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getGroup() {
        return this.group;
    }

    public void setRestrictions(Hashtable restrictions) {
        this.restrictions = restrictions;
    }

    public Hashtable getRestrictions() {
        return this.restrictions;
    }

    public void addRestriction(IUserLayoutRestriction restriction) {
        if (this.restrictions == null) {
            this.restrictions = new Hashtable();
        }
        this.restrictions.put(restriction.getRestrictionName(), restriction);
    }

    public IUserLayoutRestriction getRestriction(String restrictionName) {
        if (this.restrictions != null) {
            return (IUserLayoutRestriction)this.restrictions.get(restrictionName);
        }
        return null;
    }

    public Vector getRestrictionsByPath(String restrictionPath) {
        Vector<IUserLayoutRestriction> list = new Vector<IUserLayoutRestriction>();
        if (this.restrictions != null) {
            Enumeration enumeration = this.restrictions.elements();
            while (enumeration.hasMoreElements()) {
                IUserLayoutRestriction restriction = (IUserLayoutRestriction)enumeration.nextElement();
                if (!CommonUtils.nvl(restrictionPath).equals(CommonUtils.nvl(restriction.getRestrictionPath()))) continue;
                list.add(restriction);
            }
        }
        return list;
    }

    protected void addRestrictionChildren(Element node, Document root) {
        if (this.restrictions != null) {
            Enumeration enumeration = this.restrictions.elements();
            while (enumeration.hasMoreElements()) {
                Element pElement = root.createElement("restriction");
                IUserLayoutRestriction restriction = (IUserLayoutRestriction)enumeration.nextElement();
                pElement.setAttribute("path", restriction.getRestrictionPath());
                pElement.setAttribute("value", restriction.getRestrictionExpression());
                pElement.setAttribute("type", restriction.getRestrictionType() + "");
                node.appendChild(pElement);
            }
        }
    }
}

