/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.jasig.portal.PortalException;
import org.jasig.portal.layout.ALChannelDescription;
import org.jasig.portal.layout.ALFolder;
import org.jasig.portal.layout.ALNode;
import org.jasig.portal.layout.IALChannelDescription;
import org.jasig.portal.layout.IALFolderDescription;
import org.jasig.portal.layout.IALNodeDescription;
import org.jasig.portal.layout.IAggregatedLayout;
import org.jasig.portal.layout.IAggregatedUserLayoutManager;
import org.jasig.portal.layout.IUserLayoutFolderDescription;
import org.jasig.portal.layout.IUserLayoutNodeDescription;
import org.jasig.portal.layout.LayoutEventListener;
import org.jasig.portal.layout.restrictions.IUserLayoutRestriction;
import org.jasig.portal.layout.restrictions.PriorityRestriction;
import org.jasig.portal.utils.CommonUtils;
import org.jasig.portal.utils.GuidGenerator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class AggregatedLayout
implements IAggregatedLayout {
    private Hashtable layout = null;
    private String layoutId;
    private int restrictionMask = 0;
    private Hashtable fragments = null;
    private IAggregatedUserLayoutManager layoutManager = null;
    private static GuidGenerator guid = null;
    private String cacheKey = null;

    public AggregatedLayout(String layoutId, IAggregatedUserLayoutManager layoutManager) throws PortalException {
        this(layoutId);
        this.layoutManager = layoutManager;
        this.restrictionMask = layoutManager.getRestrictionMask();
    }

    public AggregatedLayout(String layoutId) throws PortalException {
        this.layoutId = layoutId;
        try {
            if (guid == null) {
                guid = new GuidGenerator();
            }
            this.updateCacheKey();
        }
        catch (Exception e) {
            throw new PortalException(e);
        }
    }

    public void setLayoutManager(IAggregatedUserLayoutManager layoutManager) {
        this.layoutManager = layoutManager;
    }

    public void setLayoutData(Hashtable layout) throws PortalException {
        this.layout = layout;
    }

    public Hashtable getLayoutData() throws PortalException {
        return this.layout;
    }

    private void updateCacheKey() {
        this.cacheKey = guid.getNewGuid();
    }

    private void bindRestrictions(IALNodeDescription nodeDesc, ContentHandler contentHandler) throws SAXException {
        Hashtable restrictions = nodeDesc.getRestrictions();
        Enumeration e = restrictions.keys();
        while (e.hasMoreElements()) {
            IUserLayoutRestriction restriction = (IUserLayoutRestriction)e.nextElement();
            if ((restriction.getRestrictionType() & this.restrictionMask) <= 0) continue;
            AttributesImpl paramAttrs = new AttributesImpl();
            paramAttrs.addAttribute("", "path", "path", "CDATA", restriction.getRestrictionPath());
            if ((restriction.getRestrictionType() & 1) > 0) {
                PriorityRestriction priorRestriction = (PriorityRestriction)restriction;
                paramAttrs.addAttribute("", "value", "value", "CDATA", priorRestriction.getMinValue() / 100 + "-" + priorRestriction.getMaxValue() / 100);
            } else {
                paramAttrs.addAttribute("", "value", "value", "CDATA", restriction.getRestrictionExpression());
            }
            paramAttrs.addAttribute("", "type", "type", "CDATA", restriction.getRestrictionType() + "");
            contentHandler.startElement("", "restriction", "restriction", paramAttrs);
            contentHandler.endElement("", "restriction", "restriction");
        }
    }

    public ALNode getLayoutNode(String nodeId) {
        if (nodeId != null) {
            return (ALNode)this.layout.get(nodeId);
        }
        return null;
    }

    public ALFolder getLayoutFolder(String folderId) {
        if (folderId != null) {
            return (ALFolder)this.layout.get(folderId);
        }
        return null;
    }

    public ALNode getLastSiblingNode(String nodeId) {
        ALNode node = null;
        String nextId = nodeId;
        while (nextId != null) {
            node = this.getLayoutNode(nextId);
            nextId = node.getNextNodeId();
        }
        return node;
    }

    public ALNode getFirstSiblingNode(String nodeId) {
        ALNode node = null;
        String prevId = nodeId;
        while (prevId != null) {
            node = this.getLayoutNode(prevId);
            prevId = node.getPreviousNodeId();
        }
        return node;
    }

    private void createMarkingLeaf(ContentHandler contentHandler, String leafName, String parentNodeId, String nextNodeId) throws PortalException {
        try {
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("", "parentID", "parentID", "CDATA", parentNodeId);
            attributes.addAttribute("", "nextID", "nextID", "CDATA", CommonUtils.nvl(nextNodeId));
            contentHandler.startElement("", leafName, leafName, attributes);
            contentHandler.endElement("", leafName, leafName);
        }
        catch (SAXException saxe) {
            throw new PortalException(saxe.getMessage());
        }
    }

    private void createMarkingLeaf(Document document, String leafName, String parentNodeId, String nextNodeId, Node node) throws PortalException {
        try {
            Element markingLeaf = document.createElement(leafName);
            markingLeaf.setAttribute("parentID", parentNodeId);
            markingLeaf.setAttribute("nextID", nextNodeId);
            node.appendChild(markingLeaf);
        }
        catch (Exception saxe) {
            throw new PortalException(saxe.getMessage());
        }
    }

    private void createFragmentList(Document document, Node rootNode) throws PortalException {
        try {
            Element alternateLayouts = document.createElement("alternateLayouts");
            if (this.fragments != null) {
                Enumeration fragEnum = this.fragments.keys();
                while (fragEnum.hasMoreElements()) {
                    Element alternate = document.createElement("alternate");
                    String key = (String)fragEnum.nextElement();
                    alternate.setAttribute("ID", key);
                    alternate.setAttribute("name", (String)this.fragments.get(key));
                    alternateLayouts.appendChild(alternate);
                }
            }
            rootNode.appendChild(alternateLayouts);
        }
        catch (Exception saxe) {
            throw new PortalException(saxe.getMessage());
        }
    }

    private void createFragmentList(ContentHandler contentHandler) throws PortalException {
        try {
            contentHandler.startElement("", "alternateLayouts", "alternateLayouts", new AttributesImpl());
            if (this.fragments != null) {
                Enumeration fragEnum = this.fragments.keys();
                while (fragEnum.hasMoreElements()) {
                    AttributesImpl attributes = new AttributesImpl();
                    String key = (String)fragEnum.nextElement();
                    attributes.addAttribute("", "ID", "ID", "CDATA", key);
                    attributes.addAttribute("", "name", "name", "CDATA", (String)this.fragments.get(key));
                    contentHandler.startElement("", "alternate", "alternate", attributes);
                    contentHandler.endElement("", "alternate", "alternate");
                }
            }
            contentHandler.endElement("", "alternateLayouts", "alternateLayouts");
        }
        catch (SAXException saxe) {
            throw new PortalException(saxe.getMessage());
        }
    }

    private void appendDescendants(Document domLayout, Node node, String nodeId) throws PortalException {
        ALNode layoutNode = this.getLayoutNode(nodeId);
        IALNodeDescription nodeDesc = layoutNode.getNodeDescription();
        Object markingMoveLeaf = null;
        Object markingAddLeaf = null;
        Element newNode = domLayout.createElement(layoutNode.getNodeType() == 2 ? "folder" : "channel");
        layoutNode.addNodeAttributes(newNode);
        String parentId = layoutNode.getParentNodeId();
        String nextId = layoutNode.getNextNodeId();
        if (this.layoutManager != null && parentId != null && layoutNode.getPreviousNodeId() == null && !nodeDesc.isHidden() && !this.getLayoutNode(parentId).getNodeDescription().isHidden()) {
            IALNodeDescription moveTargetsNodeDesc = this.layoutManager.getNodeBeingMoved();
            String moveTargetsNodeId = moveTargetsNodeDesc != null ? moveTargetsNodeDesc.getId() : null;
            IALNodeDescription addTargetsNodeDesc = this.layoutManager.getNodeBeingAdded();
            if (addTargetsNodeDesc != null && this.layoutManager.canAddNode(addTargetsNodeDesc, parentId, nodeId)) {
                this.createMarkingLeaf(domLayout, "add_target", parentId, nodeId, node);
            }
            if (moveTargetsNodeId != null && this.layoutManager.canMoveNode(moveTargetsNodeId, parentId, nodeId)) {
                this.createMarkingLeaf(domLayout, "move_target", parentId, nodeId, node);
            }
        }
        node.appendChild(newNode);
        if (parentId != null) {
            boolean isNodeMarkable = false;
            if (nextId != null && !this.getLayoutNode(nextId).getNodeDescription().isHidden()) {
                isNodeMarkable = true;
            } else if (nextId == null) {
                isNodeMarkable = true;
            }
            if (this.layoutManager != null && isNodeMarkable && !this.getLayoutNode(parentId).getNodeDescription().isHidden()) {
                IALNodeDescription moveTargetsNodeDesc = this.layoutManager.getNodeBeingMoved();
                String moveTargetsNodeId = moveTargetsNodeDesc != null ? moveTargetsNodeDesc.getId() : null;
                IALNodeDescription addTargetsNodeDesc = this.layoutManager.getNodeBeingAdded();
                if (addTargetsNodeDesc != null && this.layoutManager.canAddNode(addTargetsNodeDesc, parentId, nextId)) {
                    this.createMarkingLeaf(domLayout, "add_target", parentId, nextId, node);
                }
                if (moveTargetsNodeId != null && !moveTargetsNodeId.equals(nextId) && this.layoutManager.canMoveNode(moveTargetsNodeId, parentId, nextId)) {
                    this.createMarkingLeaf(domLayout, "move_target", parentId, nextId, node);
                }
            }
        }
        nodeDesc.addRestrictionChildren(newNode, domLayout);
        if (layoutNode.getNodeType() == 2) {
            String firstChildId;
            String nextNodeId = firstChildId = ((ALFolder)layoutNode).getFirstChildNodeId();
            while (nextNodeId != null) {
                this.appendDescendants(domLayout, newNode, nextNodeId);
                nextNodeId = this.getLayoutNode(nextNodeId).getNextNodeId();
            }
        } else if (layoutNode.getNodeType() == 1) {
            ALChannelDescription channelDesc = (ALChannelDescription)nodeDesc;
            channelDesc.addParameterChildren(newNode, domLayout);
        }
    }

    public Enumeration getFragmentIds() throws PortalException {
        return null;
    }

    public String getFragmentId(String nodeId) throws PortalException {
        return null;
    }

    public String getFragmentRootId(String fragmentId) throws PortalException {
        return null;
    }

    public void writeTo(ContentHandler ch) throws PortalException {
        this.writeTo(this.getRootId(), ch);
    }

    public void writeTo(String nodeId, ContentHandler contentHandler) throws PortalException {
        IALFolderDescription folderDescription = null;
        IALChannelDescription channelDescription = null;
        if (contentHandler != null && nodeId != null) {
            try {
                ALNode node = this.getLayoutNode(nodeId);
                AttributesImpl attributes = new AttributesImpl();
                if (node.getNodeType() == 2) {
                    String firstChildId;
                    if (nodeId.equals(this.getRootId())) {
                        contentHandler.startDocument();
                    }
                    if (nodeId.equals(this.getRootId())) {
                        contentHandler.startElement("", "layout", "layout", new AttributesImpl());
                        this.createFragmentList(contentHandler);
                    }
                    ALFolder folder = (ALFolder)node;
                    folderDescription = (IALFolderDescription)node.getNodeDescription();
                    attributes.addAttribute("", "ID", "ID", "ID", nodeId);
                    attributes.addAttribute("", "type", "type", "CDATA", IUserLayoutFolderDescription.folderTypeNames[folderDescription.getFolderType()]);
                    attributes.addAttribute("", "hidden", "hidden", "CDATA", CommonUtils.boolToStr(folderDescription.isHidden()));
                    attributes.addAttribute("", "unremovable", "unremovable", "CDATA", CommonUtils.boolToStr(folderDescription.isUnremovable()));
                    attributes.addAttribute("", "immutable", "immutable", "CDATA", CommonUtils.boolToStr(folderDescription.isImmutable()));
                    attributes.addAttribute("", "name", "name", "CDATA", folderDescription.getName());
                    contentHandler.startElement("", "folder", "folder", attributes);
                    String nextNodeId = firstChildId = folder.getFirstChildNodeId();
                    while (nextNodeId != null) {
                        if (this.layoutManager != null && !node.getNodeDescription().isHidden() && !this.getLayoutNode(nextNodeId).getNodeDescription().isHidden()) {
                            IALNodeDescription nodeDesc = this.layoutManager.getNodeBeingMoved();
                            String moveTargetsNodeId = nodeDesc != null ? nodeDesc.getId() : null;
                            IALNodeDescription addTargetsNodeDesc = this.layoutManager.getNodeBeingAdded();
                            if (addTargetsNodeDesc != null && this.layoutManager.canAddNode(addTargetsNodeDesc, nodeId, nextNodeId)) {
                                this.createMarkingLeaf(contentHandler, "add_target", nodeId, nextNodeId);
                            }
                            if (moveTargetsNodeId != null && !moveTargetsNodeId.equals(nextNodeId) && this.layoutManager.canMoveNode(moveTargetsNodeId, nodeId, nextNodeId)) {
                                this.createMarkingLeaf(contentHandler, "move_target", nodeId, nextNodeId);
                            }
                        }
                        this.writeTo(nextNodeId, contentHandler);
                        nextNodeId = this.getLayoutNode(nextNodeId).getNextNodeId();
                    }
                    if (this.layoutManager != null && !node.getNodeDescription().isHidden()) {
                        IALNodeDescription nodeDesc = this.layoutManager.getNodeBeingMoved();
                        String moveTargetsNodeId = nodeDesc != null ? nodeDesc.getId() : null;
                        IALNodeDescription addTargetsNodeDesc = this.layoutManager.getNodeBeingAdded();
                        if (addTargetsNodeDesc != null && this.layoutManager.canAddNode(addTargetsNodeDesc, nodeId, null)) {
                            this.createMarkingLeaf(contentHandler, "add_target", nodeId, null);
                        }
                        if (moveTargetsNodeId != null && this.layoutManager.canMoveNode(moveTargetsNodeId, nodeId, null)) {
                            this.createMarkingLeaf(contentHandler, "move_target", nodeId, null);
                        }
                    }
                    if (this.restrictionMask > 0) {
                        this.bindRestrictions(folderDescription, contentHandler);
                    }
                    contentHandler.endElement("", "folder", "folder");
                    if (nodeId.equals(this.getRootId())) {
                        contentHandler.endElement("", "layout", "layout");
                    }
                    if (nodeId.equals(this.getRootId())) {
                        contentHandler.endDocument();
                    }
                } else {
                    channelDescription = (IALChannelDescription)node.getNodeDescription();
                    attributes.addAttribute("", "ID", "ID", "ID", nodeId);
                    attributes.addAttribute("", "typeID", "typeID", "CDATA", channelDescription.getChannelTypeId());
                    attributes.addAttribute("", "hidden", "hidden", "CDATA", CommonUtils.boolToStr(channelDescription.isHidden()));
                    attributes.addAttribute("", "editable", "editable", "CDATA", CommonUtils.boolToStr(channelDescription.isEditable()));
                    attributes.addAttribute("", "unremovable", "unremovable", "CDATA", CommonUtils.boolToStr(channelDescription.isUnremovable()));
                    attributes.addAttribute("", "immutable", "immutable", "CDATA", CommonUtils.boolToStr(channelDescription.isImmutable()));
                    attributes.addAttribute("", "name", "name", "CDATA", channelDescription.getName());
                    attributes.addAttribute("", "description", "description", "CDATA", channelDescription.getDescription());
                    attributes.addAttribute("", "title", "title", "CDATA", channelDescription.getTitle());
                    attributes.addAttribute("", "class", "class", "CDATA", channelDescription.getClassName());
                    attributes.addAttribute("", "chanID", "chanID", "CDATA", channelDescription.getChannelPublishId());
                    attributes.addAttribute("", "fname", "fname", "CDATA", channelDescription.getFunctionalName());
                    attributes.addAttribute("", "timeout", "timeout", "CDATA", String.valueOf(channelDescription.getTimeout()));
                    attributes.addAttribute("", "hasHelp", "hasHelp", "CDATA", CommonUtils.boolToStr(channelDescription.hasHelp()));
                    attributes.addAttribute("", "hasAbout", "hasAbout", "CDATA", CommonUtils.boolToStr(channelDescription.hasAbout()));
                    attributes.addAttribute("", "secure", "secure", "CDATA", CommonUtils.boolToStr(channelDescription.isSecure()));
                    contentHandler.startElement("", "channel", "channel", attributes);
                    if (channelDescription.hasParameters()) {
                        Enumeration paramNames = channelDescription.getParameterNames();
                        while (paramNames.hasMoreElements()) {
                            String name = (String)paramNames.nextElement();
                            String value = channelDescription.getParameterValue(name);
                            AttributesImpl paramAttrs = new AttributesImpl();
                            paramAttrs.addAttribute("", "name", "name", "CDATA", name);
                            paramAttrs.addAttribute("", "value", "value", "CDATA", value);
                            paramAttrs.addAttribute("", "override", "override", "CDATA", channelDescription.canOverrideParameter(name) ? "yes" : "no");
                            contentHandler.startElement("", "parameter", "parameter", paramAttrs);
                            contentHandler.endElement("", "parameter", "parameter");
                        }
                    }
                    if (this.restrictionMask > 0) {
                        this.bindRestrictions(channelDescription, contentHandler);
                    }
                    contentHandler.endElement("", "channel", "channel");
                }
            }
            catch (SAXException saxe) {
                throw new PortalException(saxe.getMessage());
            }
        }
    }

    public void writeTo(Document document) throws PortalException {
        this.writeTo(this.getRootId(), document);
    }

    public void writeTo(String nodeId, Document document) throws PortalException {
        try {
            Element layoutNode = document.createElement(nodeId.equals(this.getRootId()) ? "layout" : "fragment");
            document.appendChild(layoutNode);
            if (nodeId.equals(this.getRootId())) {
                this.createFragmentList(document, layoutNode);
            }
            this.appendDescendants(document, layoutNode, nodeId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PortalException("Couldn't create the DOM representation: " + e);
        }
    }

    public IUserLayoutNodeDescription getNodeDescription(String nodeId) throws PortalException {
        ALNode node = this.getLayoutNode(nodeId);
        if (node != null) {
            return node.getNodeDescription();
        }
        throw new PortalException("The node with nodeID=" + nodeId + " does not exist in the layout!");
    }

    public ALNode getNode(String nodeId) throws PortalException {
        return this.getLayoutNode(nodeId);
    }

    public String getParentId(String nodeId) throws PortalException {
        ALNode node = this.getLayoutNode(nodeId);
        if (node != null) {
            return node.getParentNodeId();
        }
        throw new PortalException("The node with nodeID=" + nodeId + " does not exist in the layout!");
    }

    public Enumeration getChildIds(String nodeId) throws PortalException {
        String firstChildId;
        Vector<String> childIds = new Vector<String>();
        String nextNodeId = firstChildId = this.getLayoutFolder(nodeId).getFirstChildNodeId();
        while (nextNodeId != null) {
            childIds.add(nextNodeId);
            nextNodeId = this.getLayoutNode(nextNodeId).getNextNodeId();
        }
        return childIds.elements();
    }

    public String getNextSiblingId(String nodeId) throws PortalException {
        ALNode node = this.getLayoutNode(nodeId);
        if (node != null) {
            return node.getNextNodeId();
        }
        throw new PortalException("The node with nodeID=" + nodeId + " does not exist in the layout!");
    }

    public String getPreviousSiblingId(String nodeId) throws PortalException {
        ALNode node = this.getLayoutNode(nodeId);
        if (node != null) {
            return node.getPreviousNodeId();
        }
        throw new PortalException("The node with nodeID=" + nodeId + " does not exist in the layout!");
    }

    public String getCacheKey() throws PortalException {
        return this.cacheKey;
    }

    public boolean addLayoutEventListener(LayoutEventListener l) {
        return false;
    }

    public boolean removeLayoutEventListener(LayoutEventListener l) {
        return false;
    }

    public String getId() {
        return this.layoutId;
    }

    public String getNodeId(String fname) throws PortalException {
        Enumeration nodeIds = this.layout.keys();
        while (nodeIds.hasMoreElements()) {
            ALChannelDescription channelDesc;
            String nodeId = nodeIds.nextElement().toString();
            ALNode node = this.getLayoutNode(nodeId);
            if (node.getNodeType() != 1 || !fname.equals((channelDesc = (ALChannelDescription)node.getNodeDescription()).getFunctionalName())) continue;
            return node.getId();
        }
        return null;
    }

    public Enumeration getNodeIds() throws PortalException {
        if (this.layout == null) {
            throw new PortalException("The layout is NULL!");
        }
        return this.layout.keys();
    }

    public String getRootId() {
        return "userLayoutRootNode";
    }
}

