/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout;

import org.jasig.portal.PortalException;
import org.jasig.portal.layout.IUserLayoutNodeDescription;
import org.jasig.portal.layout.UserLayoutChannelDescription;
import org.jasig.portal.layout.UserLayoutFolderDescription;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class UserLayoutNodeDescription
implements IUserLayoutNodeDescription {
    protected String id = null;
    protected String name = null;
    protected boolean immutable = false;
    protected boolean unremovable = false;
    protected boolean hidden = false;

    public UserLayoutNodeDescription() {
    }

    public UserLayoutNodeDescription(IUserLayoutNodeDescription d) {
        this.id = d.getId();
        this.name = d.getName();
        this.immutable = d.isImmutable();
        this.unremovable = d.isUnremovable();
        this.hidden = d.isHidden();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isUnremovable() {
        return this.unremovable;
    }

    public void setUnremovable(boolean setting) {
        this.unremovable = setting;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public void setImmutable(boolean setting) {
        this.immutable = setting;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean setting) {
        this.hidden = setting;
    }

    public abstract int getType();

    public abstract Element getXML(Document var1);

    public void addNodeAttributes(Element node) {
        node.setAttribute("ID", this.getId());
        node.setAttribute("name", this.getName());
        node.setAttribute("unremovable", new Boolean(this.isUnremovable()).toString());
        node.setAttribute("immutable", new Boolean(this.isImmutable()).toString());
        node.setAttribute("hidden", new Boolean(this.isHidden()).toString());
    }

    public static UserLayoutNodeDescription createUserLayoutNodeDescription(Element xmlNode) throws PortalException {
        String nodeName = xmlNode.getNodeName();
        if (nodeName.equals("channel")) {
            return new UserLayoutChannelDescription(xmlNode);
        }
        if (nodeName.equals("folder")) {
            return new UserLayoutFolderDescription(xmlNode);
        }
        throw new PortalException("Given XML element is neither folder nor channel");
    }
}

