/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.restrictions;

import org.jasig.portal.PortalException;
import org.jasig.portal.layout.ALNode;
import org.jasig.portal.layout.restrictions.UserLayoutRestriction;
import org.jasig.portal.utils.CommonUtils;

public abstract class BooleanRestriction
extends UserLayoutRestriction {
    boolean boolValue1 = false;
    boolean boolValue2 = false;

    public BooleanRestriction(String nodePath) {
        super(nodePath);
    }

    public BooleanRestriction() {
    }

    private boolean strToBool(String boolStr) {
        return "Y".equalsIgnoreCase(boolStr);
    }

    protected void parseRestrictionExpression() throws PortalException {
        try {
            String restrictionExp = this.getRestrictionExpression();
            int commaIndex = restrictionExp.indexOf(44);
            if (commaIndex < 0) {
                this.boolValue1 = this.boolValue2 = this.strToBool(restrictionExp);
            } else {
                this.boolValue1 = this.strToBool(restrictionExp.substring(0, commaIndex));
                this.boolValue2 = this.strToBool(restrictionExp.substring(commaIndex + 1));
            }
        }
        catch (Exception e) {
            throw new PortalException(e.getMessage());
        }
    }

    protected abstract boolean getBooleanPropertyValue(ALNode var1);

    public boolean checkRestriction(ALNode node) throws PortalException {
        boolean boolProperty = this.getBooleanPropertyValue(node);
        return boolProperty == this.boolValue1 || boolProperty == this.boolValue2;
    }

    public boolean checkRestriction(String propertyValue) throws PortalException {
        boolean boolProperty = CommonUtils.strToBool(propertyValue);
        return boolProperty == this.boolValue1 || boolProperty == this.boolValue2;
    }
}

