/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security.provider;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Vector;
import org.jasig.portal.PropertiesManager;
import org.jasig.portal.security.IAdditionalDescriptor;
import org.jasig.portal.security.IOpaqueCredentials;
import org.jasig.portal.security.IPrincipal;
import org.jasig.portal.security.ISecurityContext;
import org.jasig.portal.security.PortalSecurityException;
import org.jasig.portal.services.LogService;

public abstract class ChainingSecurityContext
implements ISecurityContext {
    protected static boolean stopWhenAuthenticated = PropertiesManager.getPropertyAsBoolean("org.jasig.portal.security.provider.ChainingSecurityContext.stopWhenAuthenticated");
    protected boolean isauth = false;
    protected Vector mySubContexts;
    protected ChainingPrincipal myPrincipal = new ChainingPrincipal();
    protected ChainingOpaqueCredentials myOpaqueCredentials = new ChainingOpaqueCredentials();
    protected IAdditionalDescriptor myAdditionalDescriptor = new ChainingAdditionalDescriptor();
    protected Comparator myOrder;

    public ChainingSecurityContext() {
        this.mySubContexts = new Vector();
    }

    public IPrincipal getPrincipalInstance() {
        if (this.isauth) {
            return new ChainingPrincipal();
        }
        return this.myPrincipal;
    }

    public IOpaqueCredentials getOpaqueCredentialsInstance() {
        if (this.isauth) {
            return new ChainingOpaqueCredentials();
        }
        return this.myOpaqueCredentials;
    }

    public synchronized void authenticate() throws PortalSecurityException {
        Enumeration e = this.mySubContexts.elements();
        boolean error = false;
        while (e.hasMoreElements()) {
            ISecurityContext sctx = ((Entry)e.nextElement()).getCtx();
            try {
                sctx.authenticate();
            }
            catch (Exception ex) {
                error = true;
                LogService.log(LogService.ERROR, ex);
            }
            if (!stopWhenAuthenticated || !sctx.isAuthenticated()) continue;
            break;
        }
        if (this.myOpaqueCredentials.credentialstring != null) {
            for (int i = 0; i < this.myOpaqueCredentials.credentialstring.length; ++i) {
                this.myOpaqueCredentials.credentialstring[i] = 0;
            }
            this.myOpaqueCredentials.credentialstring = null;
        }
        if (error && !this.isauth) {
            throw new PortalSecurityException("One of the security subcontexts threw an exception");
        }
    }

    public IPrincipal getPrincipal() {
        if (this.isauth) {
            return this.myPrincipal;
        }
        return null;
    }

    public IOpaqueCredentials getOpaqueCredentials() {
        if (this.isauth) {
            return this.myOpaqueCredentials;
        }
        return null;
    }

    public IAdditionalDescriptor getAdditionalDescriptor() {
        if (this.isauth) {
            return this.myAdditionalDescriptor;
        }
        return null;
    }

    public boolean isAuthenticated() {
        return this.isauth;
    }

    public synchronized ISecurityContext getSubContext(String name) {
        for (int i = 0; i < this.mySubContexts.size(); ++i) {
            Entry entry = (Entry)this.mySubContexts.get(i);
            if (entry.getKey() == null || !entry.getKey().equals(name)) continue;
            return entry.getCtx();
        }
        PortalSecurityException ep = new PortalSecurityException("No such subcontext: " + name);
        LogService.log(LogService.DEBUG, ep);
        return null;
    }

    public synchronized boolean doesSubContextExist(String name) {
        for (int i = 0; i < this.mySubContexts.size(); ++i) {
            Entry entry = (Entry)this.mySubContexts.get(i);
            if (entry.getKey() == null || !entry.getKey().equals(name)) continue;
            return true;
        }
        return false;
    }

    public synchronized Enumeration getSubContexts() {
        Enumeration e = this.mySubContexts.elements();
        class Adapter
        implements Enumeration {
            Enumeration base;

            public Adapter(Enumeration e) {
                this.base = e;
            }

            public boolean hasMoreElements() {
                return this.base.hasMoreElements();
            }

            public Object nextElement() {
                return ((Entry)this.base.nextElement()).getCtx();
            }
        }
        return new Adapter(e);
    }

    public synchronized void addSubContext(String name, ISecurityContext ctx) throws PortalSecurityException {
        if (this.doesSubContextExist(name)) {
            PortalSecurityException ep = new PortalSecurityException("Subcontext already exists: " + name);
            LogService.log(LogService.ERROR, ep);
            throw ep;
        }
        this.mySubContexts.add(new Entry(name, ctx));
    }

    public synchronized Enumeration getSubContextNames() {
        Vector<String> scNames = new Vector<String>();
        for (int i = 0; i < this.mySubContexts.size(); ++i) {
            Entry entry = (Entry)this.mySubContexts.get(i);
            if (entry.getKey() == null) continue;
            scNames.add(entry.getKey());
        }
        return scNames.elements();
    }

    private static class Entry
    implements Serializable {
        String key;
        ISecurityContext ctx;

        public Entry(String key, ISecurityContext ctx) {
            this.key = key;
            this.ctx = ctx;
        }

        public ISecurityContext getCtx() {
            return this.ctx;
        }

        public String getKey() {
            return this.key;
        }
    }

    protected class ChainingAdditionalDescriptor
    implements IAdditionalDescriptor {
        protected ChainingAdditionalDescriptor() {
        }
    }

    protected class ChainingOpaqueCredentials
    implements IOpaqueCredentials {
        public byte[] credentialstring;

        protected ChainingOpaqueCredentials() {
        }

        public void setCredentials(byte[] credentials) {
            if (this.credentialstring == null) {
                this.credentialstring = new byte[credentials.length];
                for (int i = 0; i < credentials.length; ++i) {
                    this.credentialstring[i] = credentials[i];
                }
            }
        }

        public void setCredentials(String credentials) {
            if (this.credentialstring == null && credentials != null) {
                this.setCredentials(credentials.getBytes());
            }
        }
    }

    protected class ChainingPrincipal
    implements IPrincipal {
        protected String globalUID;
        protected String UID;
        protected String FullName;

        protected ChainingPrincipal() {
        }

        public String getUID() {
            return this.UID;
        }

        public String getGlobalUID() {
            return this.globalUID;
        }

        public String getFullName() {
            return this.FullName;
        }

        public void setUID(String UID) {
            if (this.UID == null) {
                this.UID = UID;
            }
        }
    }
}

