/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security.provider;

import javax.servlet.http.HttpServletRequest;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.IPersonManager;
import org.jasig.portal.security.PersonFactory;
import org.jasig.portal.security.PortalSecurityException;
import org.jasig.portal.security.provider.RemoteUserSecurityContext;
import org.jasig.portal.services.LogService;

public class RemoteUserPersonManager
implements IPersonManager {
    public static final String REMOTE_USER = "remote_user";

    public IPerson getPerson(HttpServletRequest request) throws PortalSecurityException {
        IPerson person = (IPerson)request.getSession(false).getAttribute("org.jasig.portal.security.IPerson");
        if (person != null) {
            return person;
        }
        person = PersonFactory.createPerson();
        String user = PersonFactory.GUEST_USERNAME;
        try {
            String remoteUser = request.getRemoteUser();
            RemoteUserSecurityContext context = new RemoteUserSecurityContext(remoteUser);
            person.setSecurityContext(context);
            if (remoteUser != null) {
                user = remoteUser;
            }
        }
        catch (Exception e) {
            LogService.log(LogService.ERROR, e);
        }
        person.setID(1);
        person.setAttribute("username", user);
        request.getSession(false).setAttribute("org.jasig.portal.security.IPerson", (Object)person);
        return person;
    }
}

