/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security.provider;

import java.util.Vector;
import javax.naming.AuthenticationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.jasig.portal.LdapServices;
import org.jasig.portal.security.ISecurityContext;
import org.jasig.portal.security.PortalSecurityException;
import org.jasig.portal.security.provider.ChainingSecurityContext;
import org.jasig.portal.services.LogService;

public class SimpleLdapSecurityContext
extends ChainingSecurityContext
implements ISecurityContext {
    public static final int ATTR_UID = 0;
    public static final int ATTR_FIRSTNAME = 1;
    public static final int ATTR_LASTNAME = 2;
    private final int SIMPLE_LDAP_SECURITYAUTHTYPE = 65284;
    private static final String[] attributes = new String[]{"uid", "givenName", "sn"};

    SimpleLdapSecurityContext() {
    }

    public int getAuthType() {
        return this.SIMPLE_LDAP_SECURITYAUTHTYPE;
    }

    public synchronized void authenticate() throws PortalSecurityException {
        this.isauth = false;
        LdapServices ldapservices = new LdapServices();
        String creds = new String(this.myOpaqueCredentials.credentialstring);
        if (this.myPrincipal.UID != null && !this.myPrincipal.UID.trim().equals("") && this.myOpaqueCredentials.credentialstring != null && !creds.trim().equals("")) {
            DirContext conn = null;
            NamingEnumeration<SearchResult> results = null;
            Object baseDN = null;
            StringBuffer user = new StringBuffer("(");
            Object passwd = null;
            String first_name = null;
            String last_name = null;
            user.append(ldapservices.getUidAttribute()).append("=");
            user.append(this.myPrincipal.UID).append(")");
            LogService.log(LogService.DEBUG, "SimpleLdapSecurityContext: Looking for " + user.toString());
            conn = ldapservices.getConnection();
            SearchControls searchCtls = new SearchControls();
            searchCtls.setReturningAttributes(attributes);
            searchCtls.setSearchScope(2);
            try {
                results = conn.search(ldapservices.getBaseDN(), user.toString(), searchCtls);
                if (results != null) {
                    if (!results.hasMore()) {
                        LogService.log(LogService.ERROR, "SimpleLdapSecurityContext: user not found , " + this.myPrincipal.UID);
                    }
                    Vector entries = new Vector();
                    while (results != null && results.hasMore()) {
                        SearchResult entry = results.next();
                        StringBuffer dnBuffer = new StringBuffer();
                        dnBuffer.append(entry.getName()).append(", ");
                        dnBuffer.append(ldapservices.getBaseDN());
                        Attributes attrs = entry.getAttributes();
                        first_name = this.getAttributeValue(attrs, 1);
                        last_name = this.getAttributeValue(attrs, 2);
                        conn.removeFromEnvironment("java.naming.security.principal");
                        conn.removeFromEnvironment("java.naming.security.credentials");
                        conn.addToEnvironment("java.naming.security.principal", dnBuffer.toString());
                        conn.addToEnvironment("java.naming.security.credentials", this.myOpaqueCredentials.credentialstring);
                        searchCtls = new SearchControls();
                        searchCtls.setReturningAttributes(new String[0]);
                        searchCtls.setSearchScope(0);
                        String attrSearch = "(" + ldapservices.getUidAttribute() + "=*)";
                        LogService.log(LogService.DEBUG, "SimpleLdapSecurityContext: Looking in " + dnBuffer.toString() + " for " + attrSearch);
                        conn.search(dnBuffer.toString(), attrSearch, searchCtls);
                        this.isauth = true;
                        this.myPrincipal.FullName = first_name + " " + last_name;
                        LogService.log(LogService.DEBUG, "SimpleLdapSecurityContext: User " + this.myPrincipal.UID + " (" + this.myPrincipal.FullName + ") is authenticated");
                        this.myPrincipal.UID = this.myPrincipal.UID.toLowerCase();
                    }
                }
                LogService.log(LogService.ERROR, "SimpleLdapSecurityContext: No such user: " + this.myPrincipal.UID);
            }
            catch (AuthenticationException ae) {
                LogService.log(LogService.INFO, "SimpleLdapSecurityContext: Password invalid for user: " + this.myPrincipal.UID);
            }
            catch (Exception e) {
                LogService.log(LogService.ERROR, "SimpleLdapSecurityContext: LDAP Error with user: " + this.myPrincipal.UID + "; " + e);
                throw new PortalSecurityException("SimpleLdapSecurityContext: LDAP Error" + e + " with user: " + this.myPrincipal.UID);
            }
            finally {
                ldapservices.releaseConnection(conn);
            }
        } else {
            LogService.log(LogService.ERROR, "Principal or OpaqueCredentials not initialized prior to authenticate");
        }
        super.authenticate();
    }

    private String getAttributeValue(Attributes attrs, int attribute) throws NamingException {
        NamingEnumeration<?> values = null;
        String aValue = "";
        if (!this.isAttribute(attribute)) {
            return aValue;
        }
        Attribute attrib = attrs.get(attributes[attribute]);
        if (attrib != null && (values = attrib.getAll()).hasMoreElements()) {
            aValue = (String)values.nextElement();
        }
        return aValue;
    }

    private boolean isAttribute(int attribute) {
        return attribute >= 0 && attribute <= 2;
    }
}

