/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.serialize;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.jasig.portal.serialize.CharacterCachingWriter;

public class CachingOutputStream
extends OutputStream
implements CharacterCachingWriter {
    OutputStream out;
    ByteArrayOutputStream cache = null;
    boolean caching = false;

    public CachingOutputStream(OutputStream out) {
        this.out = out;
    }

    public boolean startCaching() throws IOException {
        if (this.caching) {
            return false;
        }
        this.flush();
        this.caching = true;
        this.cache = new ByteArrayOutputStream();
        return true;
    }

    public String getCache(String encoding) throws UnsupportedEncodingException, IOException {
        this.flush();
        return this.cache.toString(encoding);
    }

    public boolean stopCaching() {
        if (!this.caching) {
            return false;
        }
        this.caching = false;
        return true;
    }

    public void close() throws IOException {
        this.out.close();
    }

    public void flush() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
        if (this.cache != null) {
            this.cache.flush();
        }
    }

    public void write(byte[] b) throws IOException {
        this.out.write(b);
        if (this.caching) {
            this.cache.write(b);
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        if (this.caching) {
            this.cache.write(b, off, len);
        }
    }

    public void write(int b) throws IOException {
        this.out.write(b);
        if (this.caching) {
            this.cache.write(b);
        }
    }
}

