/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.services.entityproperties;

import org.jasig.portal.ChannelDefinition;
import org.jasig.portal.ChannelRegistryStoreFactory;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.services.LogService;
import org.jasig.portal.services.entityproperties.IEntityPropertyFinder;

public class ChannelRegistryPropertyFinder
implements IEntityPropertyFinder {
    protected static String[] names;
    protected static Class chan;
    protected static boolean INITIALIZED;

    public static void init() {
        if (INITIALIZED) {
            return;
        }
        names = new String[5];
        ChannelRegistryPropertyFinder.names[0] = "Name";
        ChannelRegistryPropertyFinder.names[1] = "Title";
        ChannelRegistryPropertyFinder.names[2] = "Description";
        ChannelRegistryPropertyFinder.names[3] = "Functional Name";
        ChannelRegistryPropertyFinder.names[4] = "Timeout";
        try {
            chan = Class.forName("org.jasig.portal.ChannelDefinition");
        }
        catch (Exception e) {
            LogService.log(LogService.ERROR, "ChannelRegistryPropertyFinder - static:");
            LogService.log(LogService.ERROR, e);
        }
        INITIALIZED = true;
    }

    public ChannelRegistryPropertyFinder() {
        ChannelRegistryPropertyFinder.init();
    }

    public String[] getPropertyNames(EntityIdentifier entityID) {
        return names;
    }

    public String getProperty(EntityIdentifier entityID, String name) {
        String r = null;
        if (entityID.getType().equals(chan)) {
            try {
                ChannelDefinition cd = ChannelRegistryStoreFactory.getChannelRegistryStoreImpl().getChannelDefinition(Integer.parseInt(entityID.getKey()));
                if (name.equals("Name")) {
                    r = cd.getName();
                }
                if (name.equals("Title")) {
                    r = cd.getTitle();
                }
                if (name.equals("Description")) {
                    r = cd.getDescription();
                }
                if (name.equals("Functional Name")) {
                    r = cd.getFName();
                }
                if (name.equals("Timeout")) {
                    r = String.valueOf(cd.getTimeout());
                }
                if (name.equals("Secure")) {
                    r = String.valueOf(cd.isSecure());
                }
            }
            catch (Exception e) {
                LogService.log(LogService.ERROR, "ChannelRegistryPropertyFinder.getProperty(" + entityID.getKey() + "-" + entityID.getType().getName() + "," + name + ") :");
                LogService.log(LogService.ERROR, e);
            }
        }
        return r;
    }

    static {
        chan = null;
        INITIALIZED = false;
    }
}

