/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils;

import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Timer;
import java.util.TimerTask;

public class AddressTester {
    Timer timer;
    Thread connectionThread;
    private int connectionCode = 0;
    private String urlToTry = "";
    int timeToWait = 100;
    private int HTTP_OK = 200;

    public AddressTester(int milliSeconds, String urlString) throws Exception {
        this.urlToTry = urlString;
        this.timeToWait = milliSeconds;
        this.checkURL();
    }

    public AddressTester(String urlString) throws Exception {
        this.urlToTry = urlString;
        this.checkURL();
    }

    public void checkURL() throws Exception {
        this.connectionThread = new Thread(){

            public void run() {
                try {
                    URL url = new URL(AddressTester.this.urlToTry);
                    URLConnection urlConnect = url.openConnection();
                    HttpURLConnection httpUrlConnect = (HttpURLConnection)urlConnect;
                    AddressTester.this.connectionCode = httpUrlConnect.getResponseCode();
                }
                catch (Exception e) {
                    AddressTester.this.connectionCode = 0;
                }
            }
        };
        this.connectionThread.start();
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new RemindTask(), this.timeToWait);
    }

    public int getResponseCode() {
        if (this.connectionThread.isAlive()) {
            try {
                this.connectionThread.join();
            }
            catch (InterruptedException e) {
                return 0;
            }
        }
        return this.connectionCode;
    }

    public boolean URLAvailable() {
        if (this.connectionThread.isAlive()) {
            try {
                this.connectionThread.join();
            }
            catch (InterruptedException e) {
                return false;
            }
        }
        return this.connectionCode == this.HTTP_OK;
    }

    public static void main(String[] args) {
        System.out.println("About to schedule task.");
        try {
            AddressTester myReminder = new AddressTester("http://data.my.ubc.ca/verf/cbc.html");
            System.out.println("Task scheduled.");
            System.out.println("Running the test URL");
            System.out.println("is URL available " + myReminder.getResponseCode());
            System.out.println("is URL available " + myReminder.URLAvailable());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class RemindTask
    extends TimerTask {
        RemindTask() {
        }

        public void run() {
            AddressTester.this.timer.cancel();
            AddressTester.this.connectionThread.interrupt();
        }
    }
}

