/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils.threading;

import java.util.ArrayList;
import org.jasig.portal.utils.threading.Queue;

public class BoundedQueue
implements Queue {
    private ArrayList elements;
    private int capacity;
    private int elementCount;

    public BoundedQueue(int capacity) {
        this.capacity = capacity;
        this.elementCount = 0;
        this.elements = new ArrayList(capacity / 4);
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public boolean isFull() {
        return this.elementCount == this.capacity;
    }

    public int size() {
        return this.elementCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object o) throws InterruptedException {
        BoundedQueue boundedQueue;
        while (this.isFull()) {
            boundedQueue = this;
            synchronized (boundedQueue) {
                this.wait();
            }
        }
        this.elements.add(o);
        if (this.elementCount++ == 0) {
            boundedQueue = this;
            synchronized (boundedQueue) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object take() throws InterruptedException {
        while (this.isEmpty()) {
            BoundedQueue boundedQueue = this;
            synchronized (boundedQueue) {
                this.wait();
            }
        }
        Object o = this.elements.remove(0);
        if (this.elementCount-- == this.capacity) {
            BoundedQueue boundedQueue = this;
            synchronized (boundedQueue) {
                this.notifyAll();
            }
        }
        return o;
    }
}

