/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils.threading;

import org.jasig.portal.utils.threading.AbstractPool;
import org.jasig.portal.utils.threading.WorkTracker;
import org.jasig.portal.utils.threading.Worker;
import org.jasig.portal.utils.threading.WorkerTask;

public class BoundedThreadPool
extends AbstractPool {
    public BoundedThreadPool(int minThreads, int maxThreads, int threadPriority) {
        super(minThreads, maxThreads, threadPriority);
    }

    protected Thread createNewThread() throws Exception {
        Worker worker = new Worker(this, this.workQueue);
        worker.setDaemon(true);
        worker.setPriority(this.priority);
        return worker;
    }

    public synchronized void destroyThread(Thread thread) {
        if (this.isDestroyed) {
            return;
        }
        Worker worker = (Worker)thread;
        worker.stopWorker();
        worker = null;
    }

    public WorkTracker execute(WorkerTask task) throws IllegalStateException {
        if (this.isDestroyed) {
            throw new IllegalStateException("This thread pool has been destroyed, no additional tasks may be executed.");
        }
        try {
            this.adjustThreadPool();
            WorkTracker tracker = new WorkTracker(task);
            task.setWorkTracker(tracker);
            this.workQueue.put(task);
            return tracker;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage());
        }
    }
}

