/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.wsrp;

import java.net.URL;
import java.util.Map;
import java.util.WeakHashMap;
import javax.xml.rpc.holders.StringHolder;
import org.jasig.portal.wsrp.intf.WSRP_v1_Markup_PortType;
import org.jasig.portal.wsrp.types.BlockingInteractionResponse;
import org.jasig.portal.wsrp.types.Extension;
import org.jasig.portal.wsrp.types.InteractionParams;
import org.jasig.portal.wsrp.types.MarkupParams;
import org.jasig.portal.wsrp.types.MarkupResponse;
import org.jasig.portal.wsrp.types.PortletContext;
import org.jasig.portal.wsrp.types.RegistrationContext;
import org.jasig.portal.wsrp.types.RuntimeContext;
import org.jasig.portal.wsrp.types.UserContext;
import org.jasig.portal.wsrp.types.holders.ExtensionArrayHolder;
import org.jasig.portal.wsrp.types.holders.MarkupContextHolder;
import org.jasig.portal.wsrp.types.holders.SessionContextHolder;
import org.jasig.portal.wsrp.types.holders.UpdateResponseHolder;
import org.jasig.portal.wsrp.wsdl.WSRPServiceLocator;

public class MarkupService {
    WSRPServiceLocator locator = new WSRPServiceLocator();
    WSRP_v1_Markup_PortType pt = null;
    private static final String serviceName = "WSRPBaseService";
    private static final Map services = new WeakHashMap();

    private MarkupService(String baseEndpoint) throws Exception {
        if (!baseEndpoint.endsWith("/")) {
            baseEndpoint = baseEndpoint + "/";
        }
        String serviceEndpoint = baseEndpoint + serviceName;
        this.pt = this.locator.getWSRPBaseService(new URL(serviceEndpoint));
    }

    public static MarkupService getService(String baseEndpoint) throws Exception {
        MarkupService service = (MarkupService)services.get(baseEndpoint);
        if (service == null) {
            service = new MarkupService(baseEndpoint);
            services.put(baseEndpoint, service);
        }
        return service;
    }

    public MarkupResponse getMarkup(RegistrationContext registrationContext, PortletContext portletContext, RuntimeContext runtimeContext, UserContext userContext, MarkupParams markupParams) throws Exception {
        MarkupContextHolder markupContext = new MarkupContextHolder();
        SessionContextHolder sessionContext = new SessionContextHolder();
        ExtensionArrayHolder extensions = new ExtensionArrayHolder();
        this.pt.getMarkup(registrationContext, portletContext, runtimeContext, userContext, markupParams, markupContext, sessionContext, extensions);
        MarkupResponse markupResponse = new MarkupResponse();
        markupResponse.setMarkupContext(markupContext.value);
        markupResponse.setSessionContext(sessionContext.value);
        markupResponse.setExtensions(extensions.value);
        return markupResponse;
    }

    public void performBlockingInteraction(RegistrationContext registrationContext, PortletContext portletContext, RuntimeContext runtimeContext, UserContext userContext, MarkupParams markupParams, InteractionParams interactionParams) throws Exception {
        UpdateResponseHolder updateResponse = new UpdateResponseHolder();
        StringHolder redirectURL = new StringHolder();
        ExtensionArrayHolder extensions = new ExtensionArrayHolder();
        this.pt.performBlockingInteraction(registrationContext, portletContext, runtimeContext, userContext, markupParams, interactionParams, updateResponse, redirectURL, extensions);
        BlockingInteractionResponse blockingInteractionResponse = new BlockingInteractionResponse();
        blockingInteractionResponse.setUpdateResponse(updateResponse.value);
        blockingInteractionResponse.setRedirectURL(redirectURL.value);
        blockingInteractionResponse.setExtensions(extensions.value);
    }

    public Extension[] releaseSessions(RegistrationContext registrationContext, String[] sessionIDs) throws Exception {
        return this.pt.releaseSessions(registrationContext, sessionIDs);
    }

    public Extension[] initCookie(RegistrationContext registrationContext) throws Exception {
        return this.pt.initCookie(registrationContext);
    }
}

