/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.wsrp;

import java.net.URL;
import java.util.Map;
import java.util.WeakHashMap;
import javax.xml.rpc.holders.ByteArrayHolder;
import javax.xml.rpc.holders.StringHolder;
import org.jasig.portal.wsrp.intf.WSRP_v1_Registration_PortType;
import org.jasig.portal.wsrp.types.Property;
import org.jasig.portal.wsrp.types.RegistrationContext;
import org.jasig.portal.wsrp.types.RegistrationData;
import org.jasig.portal.wsrp.types.RegistrationState;
import org.jasig.portal.wsrp.types.ReturnAny;
import org.jasig.portal.wsrp.types.holders.ExtensionArrayHolder;
import org.jasig.portal.wsrp.wsdl.WSRPServiceLocator;

public class RegistrationService {
    WSRPServiceLocator locator = new WSRPServiceLocator();
    WSRP_v1_Registration_PortType pt = null;
    private static final String serviceName = "WSRPRegistrationService";
    private static final Map services = new WeakHashMap();

    private RegistrationService(String baseEndpoint) throws Exception {
        if (!baseEndpoint.endsWith("/")) {
            baseEndpoint = baseEndpoint + "/";
        }
        String serviceEndpoint = baseEndpoint + serviceName;
        this.pt = this.locator.getWSRPRegistrationService(new URL(serviceEndpoint));
    }

    public static RegistrationService getService(String baseEndpoint) throws Exception {
        RegistrationService service = (RegistrationService)services.get(baseEndpoint);
        if (service == null) {
            service = new RegistrationService(baseEndpoint);
            services.put(baseEndpoint, service);
        }
        return service;
    }

    public RegistrationContext register(String consumerName, String consumerAgent, boolean methodGetSupported, String[] consumerModes, String[] consumerWindowStates, String[] consumerUserScopes, String[] customUserProfileData, Property[] registrationProperties) throws Exception {
        ExtensionArrayHolder extensions = new ExtensionArrayHolder();
        StringHolder registrationHandle = new StringHolder();
        ByteArrayHolder registrationState = new ByteArrayHolder();
        this.pt.register(consumerName, consumerAgent, methodGetSupported, consumerModes, consumerWindowStates, consumerUserScopes, customUserProfileData, registrationProperties, extensions, registrationHandle, registrationState);
        RegistrationContext registrationContext = new RegistrationContext();
        registrationContext.setExtensions(extensions.value);
        registrationContext.setRegistrationHandle(registrationHandle.value);
        registrationContext.setRegistrationState(registrationState.value);
        return registrationContext;
    }

    public ReturnAny deregister(String registrationHandle, byte[] registrationState) throws Exception {
        ExtensionArrayHolder extensions = new ExtensionArrayHolder();
        this.pt.deregister(registrationHandle, registrationState, extensions);
        ReturnAny returnAny = new ReturnAny();
        returnAny.setExtensions(extensions.value);
        return returnAny;
    }

    public RegistrationState modifyRegistration(RegistrationContext registrationContext, RegistrationData registrationData) throws Exception {
        ByteArrayHolder registrationState = new ByteArrayHolder();
        ExtensionArrayHolder extensions = new ExtensionArrayHolder();
        this.pt.modifyRegistration(registrationContext, registrationData, registrationState, extensions);
        RegistrationState modifyRegistrationResponse = new RegistrationState();
        modifyRegistrationResponse.setRegistrationState(registrationState.value);
        modifyRegistrationResponse.setExtensions(extensions.value);
        return modifyRegistrationResponse;
    }
}

