/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.common;

import java.util.Hashtable;
import org.apache.commons.transaction.util.LoggerFacade;
import org.apache.commons.transaction.util.xa.AbstractXAResource;
import org.apache.slide.authenticate.CredentialsToken;
import org.apache.slide.common.Domain;
import org.apache.slide.common.Namespace;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.Scope;
import org.apache.slide.common.Service;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.ServiceConnectionFailedException;
import org.apache.slide.common.ServiceDisconnectionFailedException;
import org.apache.slide.common.ServiceInitializationFailedException;
import org.apache.slide.common.ServiceParameterErrorException;
import org.apache.slide.common.ServiceParameterMissingException;
import org.apache.slide.common.ServiceResetFailedException;
import org.apache.slide.util.logger.Logger;
import org.apache.slide.util.logger.TxLogger;

public abstract class AbstractXAServiceBase
extends AbstractXAResource
implements Service {
    protected String LOG_CHANNEL = this.getClass().getName();
    protected Namespace namespace;
    protected Scope scope;
    protected LoggerFacade loggerFacade = null;

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public void setNamespace(Namespace namespace) {
        this.namespace = namespace;
    }

    public Logger getLogger() {
        Logger logger = null;
        if (this.namespace != null) {
            logger = this.namespace.getLogger();
        }
        if (logger == null) {
            logger = Domain.getLogger();
        }
        return logger;
    }

    protected LoggerFacade getLoggerFacade() {
        if (this.loggerFacade == null) {
            this.loggerFacade = new TxLogger(this.getLogger(), this.LOG_CHANNEL);
        }
        return this.loggerFacade;
    }

    public abstract void setParameters(Hashtable var1) throws ServiceParameterErrorException, ServiceParameterMissingException;

    public void connect(CredentialsToken crdtoken) throws ServiceConnectionFailedException {
        this.connect();
    }

    public abstract void connect() throws ServiceConnectionFailedException;

    public abstract void disconnect() throws ServiceDisconnectionFailedException;

    public void initialize(NamespaceAccessToken token) throws ServiceInitializationFailedException {
    }

    public abstract void reset() throws ServiceResetFailedException;

    public abstract boolean isConnected() throws ServiceAccessException;

    public boolean connectIfNeeded(CredentialsToken token) throws ServiceConnectionFailedException, ServiceAccessException {
        boolean result = true;
        try {
            result = !this.isConnected();
        }
        catch (ServiceAccessException serviceAccessException) {
            // empty catch block
        }
        if (result) {
            this.connect(token);
        }
        return result;
    }

    public boolean connectIfNeeded() throws ServiceConnectionFailedException, ServiceAccessException {
        boolean result = true;
        try {
            result = !this.isConnected();
        }
        catch (ServiceAccessException serviceAccessException) {
            // empty catch block
        }
        if (result) {
            this.connect();
        }
        return result;
    }

    public boolean cacheResults() {
        return true;
    }
}

