/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.common;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.slide.common.Domain;
import org.apache.slide.common.Namespace;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.NamespaceAccessTokenImpl;
import org.apache.slide.common.SlideException;
import org.apache.slide.util.conf.Configuration;
import org.apache.slide.util.conf.ConfigurationException;
import org.apache.slide.util.logger.Logger;

public class EmbeddedDomain {
    private Hashtable namespaces = new Hashtable();
    private String defaultNamespace;
    private String name = "slide-domain";

    public EmbeddedDomain() {
        if (!Domain.isInitialized()) {
            Domain.setDomain(this);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public void setDefaultNamespace(String defaultNamespace) {
        this.defaultNamespace = defaultNamespace;
    }

    public void setLogger(Logger logger) {
        Domain.setLogger(logger);
    }

    public Logger getLogger() {
        return Domain.getLogger();
    }

    public NamespaceAccessToken getNamespaceToken(String namespaceName) {
        Namespace namespace = (Namespace)this.namespaces.get(namespaceName);
        if (namespace == null) {
            return null;
        }
        return new NamespaceAccessTokenImpl(namespace);
    }

    public Enumeration enumerateNamespaces() {
        return this.namespaces.keys();
    }

    public Namespace addNamespace(String name, Logger logger, Configuration definition, Configuration configuration, Configuration baseData) {
        Namespace namespace = new Namespace();
        namespace.setName(name);
        namespace.setLogger(logger);
        try {
            namespace.loadParameters(configuration);
            namespace.loadDefinition(definition);
            namespace.loadBaseData(baseData);
            namespace.loadConfiguration(configuration);
        }
        catch (SlideException e) {
            e.printStackTrace();
            return null;
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
            return null;
        }
        this.namespaces.put(name, namespace);
        return namespace;
    }

    public Namespace removeNamespace(String name) {
        try {
            Namespace namespace = (Namespace)this.namespaces.get(name);
            namespace.disconnectServices();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (Namespace)this.namespaces.remove(name);
    }

    public Namespace getNamespace(String name) {
        return (Namespace)this.namespaces.get(name);
    }

    public void setParameters(Hashtable parameters) {
        Domain.setParameters(parameters);
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
        Enumeration active = this.namespaces.elements();
        while (active.hasMoreElements()) {
            ((Namespace)active.nextElement()).disconnectServices();
        }
    }

    public String toString() {
        return this.getName();
    }
}

