/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.common;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.slide.common.Namespace;
import org.apache.slide.common.Scope;
import org.apache.slide.common.SlideToken;
import org.apache.slide.common.Uri;

public final class ScopeTokenizer
extends StringTokenizer {
    Vector scopes = new Vector();
    int pos;
    Namespace namespace;
    SlideToken slideToken;

    public ScopeTokenizer(SlideToken slideToken, Namespace namespace, String uri) {
        super(uri, "/");
        this.slideToken = slideToken;
        this.namespace = namespace;
        String courScope = new String();
        this.scopes.insertElementAt("/", 0);
        while (super.hasMoreTokens()) {
            courScope = courScope + "/" + super.nextToken();
            this.scopes.insertElementAt(courScope, 0);
        }
        this.pos = 0;
    }

    public ScopeTokenizer(Namespace namespace, String uri) {
        this(null, namespace, uri);
    }

    public ScopeTokenizer(Namespace namespace, Scope scope) {
        this(null, namespace, scope.toString());
    }

    public Uri getParentUri() {
        if (this.scopes.size() <= 1) {
            return null;
        }
        return this.namespace.getUri(this.slideToken, (String)this.scopes.elementAt(1));
    }

    public boolean hasMoreElements() {
        return this.scopes.size() > this.pos;
    }

    public boolean hasMoreTokens() {
        return this.hasMoreElements();
    }

    public Object nextElement() throws NoSuchElementException {
        Object obj = null;
        try {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            obj = this.scopes.elementAt(this.pos);
            ++this.pos;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        return obj;
    }

    public String nextToken() throws NoSuchElementException {
        return (String)this.nextElement();
    }

    public Scope nextScope() throws NoSuchElementException {
        return new Scope(this.nextToken());
    }

    public String nextToken(String delim) throws NoSuchElementException {
        return this.nextToken();
    }

    public Enumeration elements() {
        return this.scopes.elements();
    }

    String getUri() {
        if (this.scopes.size() < 1) {
            return null;
        }
        return (String)this.scopes.elementAt(0);
    }
}

