/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.content;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.slide.common.ObjectValidationFailedException;
import org.apache.slide.util.Messages;

public final class NodeRevisionContent
implements Serializable {
    private static final int CHUNK = 4096;
    private char[] content = null;
    private byte[] contentBytes = null;
    private transient Reader reader = null;
    private transient InputStream inputStream = null;
    static /* synthetic */ Class class$org$apache$slide$content$NodeRevisionContent;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char[] getContent() {
        char[] result = null;
        if (this.content != null) {
            result = this.content;
            this.inputStream = null;
            this.reader = null;
        } else if (this.reader != null) {
            try {
                this.content = NodeRevisionContent.read(this.reader);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            result = this.content;
            this.inputStream = null;
            this.reader = null;
        } else if (this.contentBytes != null) {
            result = this.content = new String(this.contentBytes).toCharArray();
            this.inputStream = null;
            this.reader = null;
        } else if (this.inputStream != null) {
            try {
                this.contentBytes = NodeRevisionContent.read(this.inputStream);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    this.inputStream.close();
                }
                catch (IOException iOException) {}
            }
            result = this.content = new String(this.contentBytes).toCharArray();
            this.inputStream = null;
            this.reader = null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getContentBytes() {
        byte[] result = null;
        if (this.contentBytes != null) {
            result = this.contentBytes;
            this.inputStream = null;
            this.reader = null;
        } else if (this.inputStream != null) {
            try {
                this.contentBytes = NodeRevisionContent.read(this.inputStream);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    this.inputStream.close();
                }
                catch (IOException e) {}
            }
            result = this.contentBytes;
            this.inputStream = null;
            this.reader = null;
        } else if (this.content != null) {
            result = this.contentBytes = new String(this.content).getBytes();
            this.inputStream = null;
            this.reader = null;
        } else if (this.reader != null) {
            try {
                this.content = NodeRevisionContent.read(this.reader);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            result = this.contentBytes = new String(this.content).getBytes();
            this.inputStream = null;
            this.reader = null;
        }
        return result;
    }

    public Reader readContent() throws IOException {
        Reader result = null;
        if (this.reader != null) {
            result = this.reader;
            this.inputStream = null;
        } else if (this.content != null) {
            result = new CharArrayReader(this.content);
            this.inputStream = null;
            this.reader = null;
        } else if (this.inputStream != null) {
            result = new InputStreamReader(this.inputStream);
            this.reader = null;
        } else if (this.contentBytes != null) {
            result = new CharArrayReader(new String(this.contentBytes).toCharArray());
            this.inputStream = null;
            this.reader = null;
        }
        return result;
    }

    public InputStream streamContent() throws IOException {
        InputStream result = null;
        if (this.inputStream != null) {
            result = this.inputStream;
            this.content = null;
            this.reader = null;
        } else if (this.contentBytes != null) {
            result = new ByteArrayInputStream(this.contentBytes);
            this.reader = null;
            this.inputStream = null;
        } else if (this.content != null) {
            result = new ByteArrayInputStream(new String(this.content).getBytes());
            this.reader = null;
            this.inputStream = null;
        }
        return result;
    }

    public void setContent(byte[] contentBytes) {
        this.contentBytes = contentBytes;
        this.reader = null;
        this.inputStream = null;
        this.content = null;
    }

    public void setContent(char[] content) {
        this.content = content;
        this.reader = null;
        this.inputStream = null;
        this.contentBytes = null;
    }

    public void setContent(Reader reader) {
        this.reader = reader;
        this.inputStream = null;
        this.content = null;
        this.contentBytes = null;
    }

    public void setContent(InputStream inputStream) {
        this.inputStream = inputStream;
        this.reader = null;
        this.content = null;
        this.contentBytes = null;
    }

    public void validate() {
        if (this.content == null && this.contentBytes == null && this.reader == null && this.inputStream == null) {
            throw new ObjectValidationFailedException(Messages.message((class$org$apache$slide$content$NodeRevisionContent == null ? (class$org$apache$slide$content$NodeRevisionContent = NodeRevisionContent.class$("org.apache.slide.content.NodeRevisionContent")) : class$org$apache$slide$content$NodeRevisionContent).getName() + ".noContent"));
        }
    }

    public static byte[] read(InputStream inputStream) throws IOException {
        byte[] chunk;
        int len;
        ArrayList<byte[]> chunks = new ArrayList<byte[]>();
        do {
            chunk = new byte[4096];
            chunks.add(chunk);
        } while ((len = NodeRevisionContent.read(inputStream, chunk)) == 4096);
        int last = chunks.size() - 1;
        byte[] all = new byte[last * 4096 + len];
        for (int i = 0; i <= last; ++i) {
            chunk = (byte[])chunks.get(i);
            System.arraycopy(chunk, 0, all, 4096 * i, i == last ? len : 4096);
        }
        return all;
    }

    private static int read(InputStream stream, byte[] buffer) throws IOException {
        int len;
        int ofs = 0;
        do {
            if ((len = stream.read(buffer, ofs, buffer.length - ofs)) != -1) continue;
            return ofs;
        } while ((ofs += len) != buffer.length);
        return ofs;
    }

    public static char[] read(Reader reader) throws IOException {
        char[] chunk;
        int len;
        ArrayList<char[]> chunks = new ArrayList<char[]>();
        do {
            chunk = new char[4096];
            chunks.add(chunk);
        } while ((len = NodeRevisionContent.read(reader, chunk)) == 4096);
        int last = chunks.size() - 1;
        char[] all = new char[last * 4096 + len];
        for (int i = 0; i <= last; ++i) {
            System.arraycopy(chunks.get(i), 0, all, 4096 * i, i == last ? len : 4096);
        }
        return all;
    }

    private static int read(Reader dest, char[] buffer) throws IOException {
        int ofs;
        int len;
        for (ofs = 0; ofs < buffer.length && (len = dest.read(buffer, ofs, buffer.length - ofs)) != -1; ofs += len) {
        }
        return ofs;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

