/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.event;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import org.apache.slide.event.AbstractEventMethod;
import org.apache.slide.event.EventCollectionListener;
import org.apache.slide.event.EventMethod;
import org.apache.slide.event.RemoteInformation;
import org.apache.slide.event.VetoException;
import org.apache.slide.event.VetoableEventMethod;

public class EventCollection
extends EventObject {
    List collection = new ArrayList();
    public static final Collected COLLECTED = new Collected();
    public static final VetoableCollected VETOABLE_COLLECTED = new VetoableCollected();
    public static final String GROUP = "event-collection";
    public static final AbstractEventMethod[] methods = new AbstractEventMethod[]{COLLECTED, VETOABLE_COLLECTED};

    public EventCollection(Object source) {
        super(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(AbstractEventMethod method, EventObject event) {
        List list = this.collection;
        synchronized (list) {
            this.collection.add(new Event(method, event));
        }
    }

    public List getCollection() {
        return this.collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String NEWLINE = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer(256);
        buffer.append(this.getClass().getName()).append("[collected events=");
        List list = this.collection;
        synchronized (list) {
            Iterator i = this.collection.iterator();
            while (i.hasNext()) {
                buffer.append(NEWLINE);
                Event event = (Event)i.next();
                if (event.getEvent() instanceof RemoteInformation) {
                    StringBuffer infoBuffer = new StringBuffer();
                    String[][] information = ((RemoteInformation)((Object)event.getEvent())).getInformation();
                    boolean first = true;
                    for (int j = 0; j < information.length; ++j) {
                        if (!first) {
                            infoBuffer.append(", ");
                        }
                        first = false;
                        infoBuffer.append(information[j][0]).append("=").append(information[j][1]);
                    }
                    buffer.append("[" + event.getClass().getName() + " [name=" + event.getMethod().getId() + ", information: " + infoBuffer.toString() + "]]");
                    continue;
                }
                buffer.append("[" + event.getClass().getName() + " [name=" + event.getMethod().getId() + "]]");
            }
        }
        buffer.append("]");
        return buffer.toString();
    }

    public class Event {
        private AbstractEventMethod method;
        private EventObject event;

        public Event(AbstractEventMethod method, EventObject event) {
            this.method = method;
            this.event = event;
        }

        public AbstractEventMethod getMethod() {
            return this.method;
        }

        public EventObject getEvent() {
            return this.event;
        }
    }

    public static class VetoableCollected
    extends VetoableEventMethod {
        public VetoableCollected() {
            super(EventCollection.GROUP, "vetoable-collected");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException {
            if (listener instanceof EventCollectionListener) {
                ((EventCollectionListener)listener).vetoableCollected((EventCollection)event);
            }
        }
    }

    public static class Collected
    extends EventMethod {
        public Collected() {
            super(EventCollection.GROUP, "collected");
        }

        public void fireEvent(EventListener listener, EventObject event) {
            if (listener instanceof EventCollectionListener) {
                ((EventCollectionListener)listener).collected((EventCollection)event);
            }
        }
    }
}

