/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.extractor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.poi.poifs.eventfilesystem.POIFSReader;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderEvent;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderListener;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.util.LittleEndian;
import org.apache.slide.extractor.AbstractContentExtractor;
import org.apache.slide.extractor.ExtractorException;

public class MSPowerPointExtractor
extends AbstractContentExtractor
implements POIFSReaderListener {
    private ByteArrayOutputStream writer = new ByteArrayOutputStream();

    public MSPowerPointExtractor(String uri, String contentType, String namespace) {
        super(uri, contentType, namespace);
    }

    public Reader extract(InputStream content) throws ExtractorException {
        try {
            POIFSReader reader = new POIFSReader();
            reader.registerListener((POIFSReaderListener)this);
            reader.read(content);
            return new InputStreamReader(new ByteArrayInputStream(this.writer.toByteArray()));
        }
        catch (Exception e) {
            throw new ExtractorException(e.getMessage());
        }
    }

    public void processPOIFSReaderEvent(POIFSReaderEvent event) {
        try {
            if (!event.getName().equalsIgnoreCase("PowerPoint Document")) {
                return;
            }
            DocumentInputStream input = event.getStream();
            byte[] buffer = new byte[input.available()];
            input.read(buffer, 0, input.available());
            for (int i = 0; i < buffer.length - 20; ++i) {
                long type = LittleEndian.getUShort((byte[])buffer, (int)(i + 2));
                long size = LittleEndian.getUInt((byte[])buffer, (int)(i + 4));
                if (type != 4008L) continue;
                this.writer.write(buffer, i + 4 + 1, (int)size + 3);
                i = i + 4 + 1 + (int)size - 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) throws Exception {
        int c;
        FileInputStream in = new FileInputStream(args[0]);
        MSPowerPointExtractor ex = new MSPowerPointExtractor(null, null, null);
        Reader reader = ex.extract(in);
        do {
            c = reader.read();
            System.out.print((char)c);
        } while (c != -1);
    }
}

