/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.search;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.apache.slide.common.Domain;
import org.apache.slide.common.Uri;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.event.ContentEvent;
import org.apache.slide.event.EventCollection;
import org.apache.slide.event.EventCollectionFilter;
import org.apache.slide.event.EventCollectionListener;
import org.apache.slide.event.VetoException;
import org.apache.slide.search.IndexException;
import org.apache.slide.search.Indexer;
import org.apache.slide.util.conf.Configurable;
import org.apache.slide.util.conf.Configuration;
import org.apache.slide.util.conf.ConfigurationException;

public class IndexTrigger
implements EventCollectionListener,
Configurable {
    protected static final String LOG_CHANNEL = (class$org$apache$slide$search$IndexTrigger == null ? (class$org$apache$slide$search$IndexTrigger = IndexTrigger.class$("org.apache.slide.search.IndexTrigger")) : class$org$apache$slide$search$IndexTrigger).getName();
    protected List indexers = new ArrayList();
    static /* synthetic */ Class class$org$apache$slide$search$IndexTrigger;

    public void configure(Configuration configuration) throws ConfigurationException {
        Enumeration contentIndexers = configuration.getConfigurations("indexer");
        while (contentIndexers.hasMoreElements()) {
            Configuration listenerConfig = (Configuration)contentIndexers.nextElement();
            String classname = listenerConfig.getAttribute("classname");
            String uri = listenerConfig.getAttribute("uri", null);
            String contentType = listenerConfig.getAttribute("content-type", null);
            boolean synchronous = listenerConfig.getAttributeAsBoolean("synchronous", false);
            try {
                Class<?> listenerClass = Class.forName(classname);
                Indexer indexer = null;
                try {
                    Method getInstanceMethod = listenerClass.getMethod("getInstance", new Class[0]);
                    indexer = (Indexer)getInstanceMethod.invoke(null, null);
                }
                catch (NoSuchMethodException e) {
                    indexer = (Indexer)listenerClass.newInstance();
                }
                if (indexer instanceof Configurable) {
                    ((Configurable)((Object)indexer)).configure(listenerConfig.getConfiguration("configuration"));
                }
                this.addIndexer(indexer, contentType, uri, synchronous);
            }
            catch (ClassCastException e) {
                throw new ConfigurationException("Indexer '" + classname + "' is not of type Indexer", configuration);
            }
            catch (Exception e) {
                throw new ConfigurationException("Indexer '" + classname + "' could not be loaded", configuration);
            }
        }
    }

    public void vetoableCollected(EventCollection collection) throws VetoException {
        try {
            this.triggerIndexers(collection, true);
        }
        catch (IndexException e) {
            throw new VetoException(e.getMessage());
        }
    }

    public void collected(EventCollection collection) {
        try {
            this.triggerIndexers(collection, false);
        }
        catch (IndexException e) {
            Domain.log("Index might be out of sync! Reason: " + e.getMessage(), LOG_CHANNEL, 1);
        }
    }

    private synchronized void triggerIndexers(EventCollection collection, boolean synchronous) throws IndexException {
        ContentEvent[] update = EventCollectionFilter.getChangedContents(collection);
        for (int i = 0; i < update.length; ++i) {
            Indexer[] indexers = this.getIndexers(update[i].getRevisionDescriptors(), update[i].getRevisionDescriptor(), synchronous);
            for (int j = 0; j < indexers.length; ++j) {
                indexers[j].updateIndex(new Uri(update[i].getNamespace(), update[i].getUri()), update[i].getRevisionDescriptor(), update[i].getRevisionContent());
            }
        }
        ContentEvent[] insert = EventCollectionFilter.getCreatedContents(collection);
        for (int i = 0; i < insert.length; ++i) {
            Indexer[] indexers = this.getIndexers(insert[i].getRevisionDescriptors(), insert[i].getRevisionDescriptor(), synchronous);
            for (int j = 0; j < indexers.length; ++j) {
                indexers[j].createIndex(new Uri(insert[i].getNamespace(), insert[i].getUri()), insert[i].getRevisionDescriptor(), insert[i].getRevisionContent());
            }
        }
        ContentEvent[] delete = EventCollectionFilter.getRemovedContents(collection);
        for (int i = 0; i < delete.length; ++i) {
            Indexer[] indexers = this.getIndexers(delete[i].getRevisionDescriptors(), delete[i].getRevisionDescriptor(), synchronous);
            for (int j = 0; j < indexers.length; ++j) {
                indexers[j].dropIndex(new Uri(delete[i].getNamespace(), delete[i].getUri()), delete[i].getRevisionDescriptor().getRevisionNumber());
            }
        }
    }

    private void addIndexer(Indexer indexer, String contentType, String uri, boolean synchronous) {
        this.indexers.add(new IndexerMapping(indexer, contentType, uri, synchronous));
    }

    private Indexer[] getIndexers(NodeRevisionDescriptors descriptors, NodeRevisionDescriptor descriptor, boolean synchronous) {
        ArrayList<Indexer> matchingIndexers = new ArrayList<Indexer>();
        Iterator i = this.indexers.iterator();
        while (i.hasNext()) {
            IndexerMapping mapping = (IndexerMapping)i.next();
            if (mapping.isSynchronous() != synchronous || !mapping.matches(descriptors, descriptor)) continue;
            matchingIndexers.add(mapping.getIndexer());
        }
        Indexer[] indexers = new Indexer[matchingIndexers.size()];
        return matchingIndexers.toArray(indexers);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class IndexerMapping {
        Indexer indexer;
        String uri;
        String contentType;
        boolean synchronous;

        public IndexerMapping(Indexer indexer, String contentType, String uri, boolean synchronous) {
            this.indexer = indexer;
            this.uri = uri;
            this.contentType = contentType;
            this.synchronous = synchronous;
        }

        public Indexer getIndexer() {
            return this.indexer;
        }

        public boolean isSynchronous() {
            return this.synchronous;
        }

        public boolean matches(NodeRevisionDescriptors descriptors, NodeRevisionDescriptor descriptor) {
            boolean matching = true;
            if (descriptor != null && this.contentType != null && !descriptor.getContentType().equals(this.contentType)) {
                matching = false;
            }
            if (descriptors != null && this.uri != null && !descriptors.getUri().startsWith(this.uri)) {
                matching = false;
            }
            return matching;
        }
    }
}

