/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.search;

import org.apache.slide.search.InvalidScopeException;

public class SlideUri {
    private String context;
    private String path;

    public static SlideUri createWithRequestUri(String slideContextPath, String requestUri) {
        if (slideContextPath.length() <= 1) {
            return new SlideUri("/", requestUri);
        }
        return new SlideUri(slideContextPath, requestUri.substring(slideContextPath.length()));
    }

    private SlideUri(String slideContextPath, String slideUri) {
        if (slideContextPath == null || slideUri == null) {
            throw new NullPointerException();
        }
        if (slideUri.length() == 0) {
            slideUri = "/";
        }
        if (!slideContextPath.startsWith("/")) {
            throw new IllegalArgumentException("slideContextPath must be absolute");
        }
        if (!slideUri.startsWith("/")) {
            throw new IllegalArgumentException("slideUri must be absolute");
        }
        this.context = slideContextPath;
        this.path = slideUri;
        if (this.context.endsWith("/") && this.context.length() > 1) {
            this.context = this.context.substring(0, this.context.length() - 1);
        }
        if (this.path.endsWith("/") && this.context.length() > 1) {
            this.path = this.path.substring(0, this.path.length() - 1);
        }
    }

    public String getSlidePath(String davPath) throws InvalidScopeException {
        if (davPath.startsWith("/")) {
            if (!davPath.startsWith(this.context)) {
                throw new InvalidScopeException("Uri \"" + davPath + "\" does not refer to " + this.context + ". If an absolute scope is used, it must start with \"" + this.context + "\"");
            }
            if (davPath.length() == this.context.length()) {
                return "/";
            }
            if (this.context.length() > 1 && davPath.charAt(this.context.length()) != '/') {
                throw new InvalidScopeException("Uri \"" + davPath + "\" does not refer to " + this.context + ". If an absolute scope is used, it must start with \"" + this.context + "\"");
            }
            if (this.context.length() > 1) {
                return davPath.substring(this.context.length());
            }
            return davPath;
        }
        if (this.path.length() > 1) {
            return this.path + "/" + davPath;
        }
        return this.path + davPath;
    }

    public String getContextPath(String slidePath) {
        if (slidePath.startsWith("/")) {
            if (this.context.length() > 1) {
                return this.context + slidePath;
            }
            return slidePath;
        }
        if (this.context.length() > 1) {
            return this.context + "/" + slidePath;
        }
        return "/" + slidePath;
    }
}

