/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.search.basic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.slide.search.BadQueryException;
import org.apache.slide.search.PropertyProvider;
import org.apache.slide.search.basic.BasicExpressionFactory;
import org.apache.slide.search.basic.IBasicExpression;
import org.apache.slide.search.basic.IBasicExpressionCompiler;
import org.apache.slide.search.basic.IBasicExpressionFactory;
import org.apache.slide.search.basic.IBasicQuery;
import org.jdom.Element;

public class BasicExpressionCompiler
implements IBasicExpressionCompiler {
    protected IBasicQuery query = null;
    protected PropertyProvider propertyProvider = null;
    protected IBasicExpressionFactory genericExpressionFactory = null;
    protected IBasicExpressionFactory propertiesExpressionFactory = null;
    protected IBasicExpressionFactory contentExpressionFactory = null;
    protected boolean alreadyTriedToInstantiate = false;

    public BasicExpressionCompiler(IBasicQuery query, PropertyProvider propertyProvider) throws BadQueryException {
        this.query = query;
        this.propertyProvider = propertyProvider;
        this.genericExpressionFactory = new BasicExpressionFactory();
        this.propertiesExpressionFactory = query.getPropertiesExpressionFactory() == null ? this.genericExpressionFactory : query.getPropertiesExpressionFactory();
        this.contentExpressionFactory = query.getContentExpressionFactory() == null ? this.genericExpressionFactory : query.getContentExpressionFactory();
        this.propertiesExpressionFactory.init(query, propertyProvider);
        this.contentExpressionFactory.init(query, propertyProvider);
        this.genericExpressionFactory.init(query, propertyProvider);
    }

    public IBasicExpression compile(Element expressionElement) throws BadQueryException {
        if (BasicExpressionCompiler.isMergeExpression(expressionElement)) {
            ArrayList<IBasicExpression> expressionsToMerge = new ArrayList<IBasicExpression>();
            Iterator iterator = expressionElement.getChildren().iterator();
            while (iterator.hasNext()) {
                expressionsToMerge.add(this.compile((Element)iterator.next()));
            }
            return this.createMergeExpression(expressionElement.getName(), expressionElement.getNamespaceURI(), expressionsToMerge);
        }
        return this.createExpression(expressionElement);
    }

    private IBasicExpression createMergeExpression(String name, String namespace, List expressionsToMerge) throws BadQueryException {
        HashMap<IBasicExpressionFactory, Object> expressionsByFactory = new HashMap<IBasicExpressionFactory, Object>();
        IBasicExpression mergeExpression = null;
        Iterator<Object> it = expressionsToMerge.iterator();
        while (it.hasNext()) {
            IBasicExpression exp = (IBasicExpression)it.next();
            IBasicExpressionFactory fac = exp.getFactory();
            ArrayList<IBasicExpression> expList = (ArrayList<IBasicExpression>)expressionsByFactory.get(fac);
            if (expList == null) {
                expList = new ArrayList<IBasicExpression>();
                expressionsByFactory.put(fac, expList);
            }
            expList.add(exp);
        }
        it = expressionsByFactory.keySet().iterator();
        while (it.hasNext()) {
            IBasicExpressionFactory fac = (IBasicExpressionFactory)it.next();
            List expList = (List)expressionsByFactory.get(fac);
            if (expList.size() > 1) {
                expressionsByFactory.put(fac, fac.createMergeExpression(name, namespace, expList));
                continue;
            }
            expressionsByFactory.put(fac, expList.get(0));
        }
        Collection exprToMerge = expressionsByFactory.values();
        if (expressionsByFactory.size() > 1) {
            mergeExpression = this.genericExpressionFactory.createMergeExpression(name, namespace, exprToMerge);
        } else {
            it = expressionsByFactory.values().iterator();
            if (it.hasNext()) {
                mergeExpression = (IBasicExpression)it.next();
            }
        }
        return mergeExpression;
    }

    private IBasicExpression createExpression(Element expressionElement) throws BadQueryException {
        IBasicExpression expression = null;
        expression = BasicExpressionCompiler.isContentExpression(expressionElement) ? this.contentExpressionFactory.createExpression(expressionElement) : this.propertiesExpressionFactory.createExpression(expressionElement);
        if (expression == null) {
            expression = this.genericExpressionFactory.createExpression(expressionElement);
        }
        return expression;
    }

    public static boolean isMergeExpression(Element expressionElement) {
        boolean isMerge = false;
        if (expressionElement != null && "DAV:".equals(expressionElement.getNamespaceURI())) {
            isMerge = "and".equals(expressionElement.getName()) || "or".equals(expressionElement.getName());
        }
        return isMerge;
    }

    public static boolean isContentExpression(Element expressionElement) {
        boolean isContent = false;
        if (expressionElement != null && "DAV:".equals(expressionElement.getNamespaceURI())) {
            isContent = "contains".equals(expressionElement.getName());
        }
        return isContent;
    }
}

