/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.search.basic;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.search.BadGatewayException;
import org.apache.slide.search.BadQueryException;
import org.apache.slide.search.QueryScope;
import org.jdom.Element;
import org.jdom.Namespace;

public class BasicQueryScope
implements QueryScope {
    private static Namespace slideNamespace = NodeProperty.NamespaceCache.getNamespace("http://jakarta.apache.org/slide/");
    private String href;
    private int depth;
    private boolean isCollection = true;
    private Set excludedScopes = new HashSet();
    private Set includeSet = new HashSet();
    private Set excludeSet = new HashSet();

    public BasicQueryScope(String href, int depth, Set includeSet, Set excludeSet) {
        this.href = href;
        this.depth = depth;
        this.includeSet = includeSet;
        this.excludeSet = excludeSet;
    }

    public BasicQueryScope(Element fromElement) throws BadQueryException {
        this.depth = Integer.MAX_VALUE;
        Namespace namespace = fromElement.getNamespace();
        String name = fromElement.getName();
        if (!namespace.getURI().equals("DAV:") || !name.equals("from")) {
            throw new BadQueryException("expected DAV:from");
        }
        Element scope = fromElement.getChild("scope", namespace);
        if (scope.getChildren("href", namespace).size() != 1) {
            throw new BadQueryException("exactly one href element must be defined");
        }
        this.href = scope.getChildTextTrim("href", namespace);
        try {
            URL url = new URL(this.href);
            throw new BadGatewayException(this.href + ": Bad Gateway (no server redirection allowed)");
        }
        catch (MalformedURLException e) {
            String pattern;
            Element incl;
            Element depth = scope.getChild("depth", namespace);
            if (depth != null) {
                String d = depth.getTextTrim();
                if (d.equals("0")) {
                    this.depth = 0;
                } else if (d.equals("1")) {
                    this.depth = 1;
                }
            }
            Iterator it = scope.getChildren("exclude", slideNamespace).iterator();
            while (it.hasNext()) {
                Element excluded = (Element)it.next();
                String href = excluded.getText();
                this.excludedScopes.add(href);
            }
            it = scope.getChildren("include-lastpathsegment", namespace).iterator();
            while (it.hasNext()) {
                incl = (Element)it.next();
                pattern = incl.getText();
                this.includeSet.add(pattern);
            }
            it = scope.getChildren("exclude-lastpathsegment", namespace).iterator();
            while (it.hasNext()) {
                incl = (Element)it.next();
                pattern = incl.getText();
                this.excludeSet.add(pattern);
            }
            return;
        }
    }

    public String getHref() {
        return this.href;
    }

    public int getDepth() {
        return this.depth;
    }

    public boolean equals(Object o) {
        if (!(o instanceof QueryScope)) {
            return false;
        }
        QueryScope other = (QueryScope)o;
        if (!this.href.equals(other.getHref())) {
            return false;
        }
        return this.depth == other.getDepth();
    }

    public String toString() {
        return this.href + ", depth = " + this.depth;
    }

    public void setIsCollection(boolean isCollection) {
        this.isCollection = isCollection;
        if (isCollection && !this.href.endsWith("/")) {
            this.href = this.href + "/";
        }
    }

    public boolean isCollection() {
        return this.isCollection;
    }

    public Set getExcludedScopes() {
        return this.excludedScopes;
    }

    public Set getIncludeSet() {
        return this.includeSet;
    }

    public Set getExcludeSet() {
        return this.excludeSet;
    }
}

