/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.store;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.commons.transaction.locking.GenericLock;
import org.apache.commons.transaction.locking.GenericLockManager;
import org.apache.commons.transaction.util.LoggerFacade;
import org.apache.commons.transaction.util.xa.XidWrapper;
import org.apache.slide.common.Service;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.ServiceParameterErrorException;
import org.apache.slide.common.ServiceParameterMissingException;
import org.apache.slide.common.Uri;
import org.apache.slide.content.NodeRevisionContent;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.content.RevisionAlreadyExistException;
import org.apache.slide.content.RevisionDescriptorNotFoundException;
import org.apache.slide.content.RevisionNotFoundException;
import org.apache.slide.lock.LockTokenNotFoundException;
import org.apache.slide.lock.NodeLock;
import org.apache.slide.macro.ConflictException;
import org.apache.slide.security.NodePermission;
import org.apache.slide.store.AbstractStore;
import org.apache.slide.structure.LinkNode;
import org.apache.slide.structure.ObjectAlreadyExistsException;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.util.ByteSizeLimitedObjectCache;
import org.apache.slide.util.ObjectCache;
import org.apache.slide.util.TxLRUObjectCache;
import org.apache.slide.util.logger.TxLogger;

public class ExtendedStore
extends AbstractStore {
    private static final String LOG_CHANNEL = (class$org$apache$slide$store$ExtendedStore == null ? (class$org$apache$slide$store$ExtendedStore = ExtendedStore.class$("org.apache.slide.store.ExtendedStore")) : class$org$apache$slide$store$ExtendedStore).getName();
    protected static final int DEFAULT_OBJECT_GLOBAL_CACHE_SIZE = 10000;
    protected static final String GLOBAL_OBJECT_CACHE_SIZE_PARAMETER = "object-cache-size";
    protected static final int DEFAULT_GLOBAL_PERMISSION_CACHE_SIZE = 10000;
    protected static final String GLOBAL_PERMISSION_CACHE_SIZE_PARAMETER = "permission-cache-size";
    protected static final int DEFAULT_GLOBAL_LOCK_CACHE_SIZE = 100;
    protected static final String GLOBAL_LOCK_CACHE_SIZE_PARAMETER = "lock-cache-size";
    protected static final int DEFAULT_GLOBAL_DESCRIPTORS_CACHE_SIZE = 10000;
    protected static final String GLOBAL_DESCRIPTORS_CACHE_SIZE_PARAMETER = "descriptors-cache-size";
    protected static final int DEFAULT_GLOBAL_DESCRIPTOR_CACHE_SIZE = 10000;
    protected static final String GLOBAL_DESCRIPTOR_CACHE_SIZE_PARAMETER = "descriptor-cache-size";
    protected static final int DEFAULT_GLOBAL_CONTENT_CACHE_SIZE = 10000;
    protected static final String GLOBAL_CONTENT_CACHE_SIZE_PARAMETER = "content-cache-size";
    protected static final boolean DEFAULT_ENABLE_CONTENT_CACHING = false;
    protected static final String ENABLE_CONTENT_CACHING_PARAMETER = "enable-content-caching";
    protected static final int DEFAULT_TX_CONTENT_CACHE_SIZE = 1000;
    protected static final String TX_CONTENT_CACHE_SIZE_PARAMETER = "tx-content-cache-size";
    protected static final long DEFAULT_CONTENT_CACHE_BYTES = 10000000L;
    protected static final String CONTENT_CACHE_BYTES_PARAMETER = "content-cache-bytes";
    protected static final long DEFAULT_TX_CONTENT_CACHE_BYTES = 1000000L;
    protected static final String TX_CONTENT_CACHE_BYTES_PARAMETER = "tx-content-cache-bytes";
    protected static final long DEFAULT_MAX_CONTENT_BYTES_PER_ENTRY = 50000L;
    protected static final String MAX_CONTENT_BYTES_PER_ENTRY_PARAMETER = "max-content-bytes-per-entry";
    protected static final String CACHE_MODE_PARAMETER = "cache-mode";
    protected static final String CACHE_MODE_FULL = "full";
    protected static final String CACHE_MODE_LOCAL = "cluster";
    protected static final String CACHE_MODE_NO_GLOBAL_IN_TX = "isolation-shadow";
    protected static final String CACHE_MODE_OFF = "off";
    protected static final String DEFAULT_CACHE_MODE = "full";
    protected static final int DEFAULT_TLOCK_TIMEOUT = 20000;
    protected static final String TLOCK_TIMEOUT_PARAMETER = "tlock-timeout";
    protected ThreadLocal activeTransactionBranch = new ThreadLocal();
    protected TxContentCacheWrapper contentCache;
    protected TxCacheWrapper objectsCache;
    protected TxCacheWrapper permissionsCache;
    protected TxCacheWrapper locksCache;
    protected TxCacheWrapper descriptorsCache;
    protected TxCacheWrapper descriptorCache;
    protected GenericLockManager lockManager;
    protected ThreadLocal locks = new ThreadLocal();
    protected long timeout;
    protected boolean globalCacheOff;
    int globalObjectCacheSize;
    int globalPermissionCacheSize;
    int globalLockCacheSize;
    int globalDescrtiptorsCacheSize;
    int globalDescrtiptorCacheSize;
    boolean contentCachingEnabled;
    int globalContentCacheSize;
    long contentCacheBytes;
    int txContentCacheSize;
    long txContentCacheBytes;
    long maxByteSizePerEntry;
    boolean noGlobalCacheInTx;
    private Map suspendedLocks = new HashMap();
    static /* synthetic */ Class class$org$apache$slide$store$ExtendedStore;

    public ExtendedStore() {
        this.lockManager = new GenericLockManager(1, (LoggerFacade)new TxLogger(this.getLogger(), LOG_CHANNEL));
    }

    public void setParameters(Hashtable parameters) throws ServiceParameterErrorException, ServiceParameterMissingException {
        boolean noGlobalCache;
        super.setParameters(parameters);
        this.globalObjectCacheSize = 10000;
        this.globalPermissionCacheSize = 10000;
        this.globalLockCacheSize = 100;
        this.globalDescrtiptorsCacheSize = 10000;
        this.globalDescrtiptorCacheSize = 10000;
        this.contentCachingEnabled = false;
        this.globalContentCacheSize = 10000;
        this.contentCacheBytes = 10000000L;
        this.txContentCacheSize = 1000;
        this.txContentCacheBytes = 1000000L;
        this.maxByteSizePerEntry = 50000L;
        this.timeout = 20000L;
        String timeoutString = (String)parameters.get(TLOCK_TIMEOUT_PARAMETER);
        if (timeoutString != null) {
            try {
                this.timeout = Integer.parseInt(timeoutString) * 1000;
            }
            catch (NumberFormatException nfe) {
                this.getLogger().log("TLock timeout must be integer! Using default value", LOG_CHANNEL, 4);
            }
        }
        this.getLogger().log("Setting TLock timeout for store " + this.getName() + " to " + this.timeout / 1000L + " seconds", 6);
        String globalObjectCacheSizeString = (String)parameters.get(GLOBAL_OBJECT_CACHE_SIZE_PARAMETER);
        if (globalObjectCacheSizeString != null) {
            try {
                this.globalObjectCacheSize = Integer.parseInt(globalObjectCacheSizeString);
            }
            catch (NumberFormatException nfe) {
                this.getLogger().log("Cache size must be an integer! Using default size", LOG_CHANNEL, 4);
            }
        }
        this.getLogger().log("Setting object cache size for store " + this.getName() + " to " + this.globalObjectCacheSize, 6);
        String globalPermissionCacheSizeString = (String)parameters.get(GLOBAL_PERMISSION_CACHE_SIZE_PARAMETER);
        if (globalPermissionCacheSizeString != null) {
            try {
                this.globalPermissionCacheSize = Integer.parseInt(globalPermissionCacheSizeString);
            }
            catch (NumberFormatException nfe) {
                this.getLogger().log("Cache size must be an integer! Using default size", LOG_CHANNEL, 4);
            }
        }
        this.getLogger().log("Setting permission cache size for store " + this.getName() + " to " + this.globalPermissionCacheSize, LOG_CHANNEL, 6);
        String globalLockCacheSizeString = (String)parameters.get(GLOBAL_LOCK_CACHE_SIZE_PARAMETER);
        if (globalLockCacheSizeString != null) {
            try {
                this.globalLockCacheSize = Integer.parseInt(globalLockCacheSizeString);
            }
            catch (NumberFormatException nfe) {
                this.getLogger().log("Cache size must be an integer! Using default size", LOG_CHANNEL, 4);
            }
        }
        this.getLogger().log("Setting lock cache size for store " + this.getName() + " to " + this.globalLockCacheSize, LOG_CHANNEL, 6);
        String globalDescriptorsCacheSizeString = (String)parameters.get(GLOBAL_DESCRIPTORS_CACHE_SIZE_PARAMETER);
        if (globalDescriptorsCacheSizeString != null) {
            try {
                this.globalDescrtiptorsCacheSize = Integer.parseInt(globalDescriptorsCacheSizeString);
            }
            catch (NumberFormatException nfe) {
                this.getLogger().log("Cache size must be an integer! Using default size", LOG_CHANNEL, 4);
            }
        }
        this.getLogger().log("Setting descriptors cache size for store " + this.getName() + " to " + this.globalDescrtiptorsCacheSize, LOG_CHANNEL, 6);
        String globalDescriptorCacheSizeString = (String)parameters.get(GLOBAL_DESCRIPTOR_CACHE_SIZE_PARAMETER);
        if (globalDescriptorCacheSizeString != null) {
            try {
                this.globalDescrtiptorCacheSize = Integer.parseInt(globalDescriptorCacheSizeString);
            }
            catch (NumberFormatException nfe) {
                this.getLogger().log("Cache size must be an integer! Using default size", LOG_CHANNEL, 4);
            }
        }
        this.getLogger().log("Setting descriptor cache size for store " + this.getName() + " to " + this.globalDescrtiptorCacheSize, LOG_CHANNEL, 6);
        String enableContentCachingString = (String)parameters.get(ENABLE_CONTENT_CACHING_PARAMETER);
        if (enableContentCachingString != null) {
            this.contentCachingEnabled = Boolean.valueOf(enableContentCachingString);
        }
        this.getLogger().log("Setting content caching for store " + this.getName() + " to " + this.contentCachingEnabled, LOG_CHANNEL, 6);
        String globalContentCacheSizeString = (String)parameters.get(GLOBAL_CONTENT_CACHE_SIZE_PARAMETER);
        if (globalContentCacheSizeString != null) {
            try {
                this.globalContentCacheSize = Integer.parseInt(globalContentCacheSizeString);
            }
            catch (NumberFormatException nfe) {
                this.getLogger().log("Cache size must be an integer! Using default size", LOG_CHANNEL, 4);
            }
        }
        this.getLogger().log("Setting content cache size for store " + this.getName() + " to " + this.globalContentCacheSize, LOG_CHANNEL, 6);
        String contentCacheBytesString = (String)parameters.get(CONTENT_CACHE_BYTES_PARAMETER);
        if (contentCacheBytesString != null) {
            try {
                this.contentCacheBytes = Long.parseLong(contentCacheBytesString);
            }
            catch (NumberFormatException nfe) {
                this.getLogger().log("Content cache byte size must be an integer! Using default size", LOG_CHANNEL, 4);
            }
        }
        this.getLogger().log("Setting content cache byte size for store " + this.getName() + " to " + this.contentCacheBytes, LOG_CHANNEL, 6);
        String txContentCacheSizeString = (String)parameters.get(TX_CONTENT_CACHE_SIZE_PARAMETER);
        if (txContentCacheSizeString != null) {
            try {
                this.txContentCacheSize = Integer.parseInt(txContentCacheSizeString);
            }
            catch (NumberFormatException nfe) {
                this.getLogger().log("Content transaction cache size must be an integer! Using default size", LOG_CHANNEL, 4);
            }
        }
        this.getLogger().log("Setting transaction content cache size for store " + this.getName() + " to " + this.txContentCacheSize, LOG_CHANNEL, 6);
        String txContentCacheBytesString = (String)parameters.get(TX_CONTENT_CACHE_BYTES_PARAMETER);
        if (txContentCacheBytesString != null) {
            try {
                this.txContentCacheBytes = Long.parseLong(txContentCacheBytesString);
            }
            catch (NumberFormatException nfe) {
                this.getLogger().log("Transaction content cache byte size must be an integer! Using default size", LOG_CHANNEL, 4);
            }
        }
        this.getLogger().log("Setting transaction content cache byte size for store " + this.getName() + " to " + this.txContentCacheBytes, LOG_CHANNEL, 6);
        String maxByteSizePerEntryString = (String)parameters.get(MAX_CONTENT_BYTES_PER_ENTRY_PARAMETER);
        if (maxByteSizePerEntryString != null) {
            try {
                this.maxByteSizePerEntry = Long.parseLong(maxByteSizePerEntryString);
            }
            catch (NumberFormatException nfe) {
                this.getLogger().log("Maximum byte size for content cache entry must be an integer! Using default size", LOG_CHANNEL, 4);
            }
        }
        this.getLogger().log("Setting maximum byte size for content cache entry for store " + this.getName() + " to " + this.maxByteSizePerEntry, LOG_CHANNEL, 6);
        String cacheModeString = (String)parameters.get(CACHE_MODE_PARAMETER);
        if (cacheModeString == null) {
            cacheModeString = "full";
        }
        if ((cacheModeString = cacheModeString.trim()).equals("full")) {
            noGlobalCache = false;
            this.globalCacheOff = false;
            this.noGlobalCacheInTx = false;
            this.getLogger().log("Enabling full caching causing low isolation", LOG_CHANNEL, 6);
        } else if (cacheModeString.equals(CACHE_MODE_LOCAL)) {
            noGlobalCache = true;
            this.globalCacheOff = false;
            this.noGlobalCacheInTx = false;
            this.getLogger().log("Disabling global cache to shadow store isolation and allow for clustering", LOG_CHANNEL, 6);
        } else if (cacheModeString.equals(CACHE_MODE_NO_GLOBAL_IN_TX)) {
            this.globalCacheOff = false;
            noGlobalCache = false;
            this.noGlobalCacheInTx = true;
            this.getLogger().log("Disabling global cache inside transactions to shadow store isolation", LOG_CHANNEL, 6);
        } else if (cacheModeString.equals(CACHE_MODE_OFF)) {
            this.globalCacheOff = true;
            noGlobalCache = true;
            this.noGlobalCacheInTx = true;
            this.getLogger().log("Disabling cache completely", LOG_CHANNEL, 6);
        } else {
            noGlobalCache = false;
            this.globalCacheOff = false;
            this.noGlobalCacheInTx = false;
            this.getLogger().log("Unknown cache mode " + cacheModeString + " Using full mode instead...", LOG_CHANNEL, 4);
        }
        if (noGlobalCache) {
            this.globalObjectCacheSize = -1;
            this.globalPermissionCacheSize = -1;
            this.globalLockCacheSize = -1;
            this.globalDescrtiptorsCacheSize = -1;
            this.globalDescrtiptorCacheSize = -1;
            this.contentCachingEnabled = false;
        }
        this.init(this.globalObjectCacheSize, this.globalPermissionCacheSize, this.globalLockCacheSize, this.globalDescrtiptorsCacheSize, this.globalDescrtiptorCacheSize, this.contentCachingEnabled, this.globalContentCacheSize, this.contentCacheBytes, this.txContentCacheSize, this.txContentCacheBytes, this.maxByteSizePerEntry, this.noGlobalCacheInTx);
    }

    public void resetCache() {
        this.init(this.globalObjectCacheSize, this.globalPermissionCacheSize, this.globalLockCacheSize, this.globalDescrtiptorsCacheSize, this.globalDescrtiptorCacheSize, this.contentCachingEnabled, this.globalContentCacheSize, this.contentCacheBytes, this.txContentCacheSize, this.txContentCacheBytes, this.maxByteSizePerEntry, this.noGlobalCacheInTx);
    }

    public void removeObjectFromCache(Object key) {
        this.getLogger().log("Removing " + key + " from cache.", LOG_CHANNEL, 7);
        if (this.contentStore.cacheResults() && this.contentCachingEnabled) {
            this.contentCache.remove(key.toString(), "_");
        }
        if (this.nodeStore.cacheResults()) {
            this.objectsCache.remove(key.toString());
        }
        if (this.securityStore.cacheResults()) {
            this.permissionsCache.remove(key.toString());
        }
        if (this.lockStore.cacheResults()) {
            this.locksCache.remove(key.toString());
        }
        if (this.revisionDescriptorsStore.cacheResults()) {
            this.descriptorsCache.remove(key.toString());
        }
        if (this.revisionDescriptorStore.cacheResults()) {
            this.descriptorCache.remove(key.toString(), "-");
        }
    }

    public void exclusiveTransientLock(String uri) throws ServiceAccessException {
        Xid txId = (Xid)this.activeTransactionBranch.get();
        if (txId != null) {
            try {
                GenericLock lock = (GenericLock)this.lockManager.atomicGetOrCreateLock((Object)uri);
                if (lock.getLockLevel((Object)txId) != 1) {
                    Object owner = lock.getOwner();
                    this.getLogger().log("Try lock: " + txId + " tries " + uri + (owner != null ? " ---> " + owner.toString() + " has it" : ""), LOG_CHANNEL, 7);
                    if (!lock.acquire((Object)txId, 1, true, true, this.timeout)) {
                        throw new ServiceAccessException((Service)this, (Throwable)new ConflictException(uri));
                    }
                    ((HashSet)this.locks.get()).add(lock);
                    this.getLogger().log("Has lock: " + txId + " locks " + uri, LOG_CHANNEL, 7);
                }
            }
            catch (InterruptedException e) {
                throw new ServiceAccessException((Service)this, (Throwable)new ConflictException(uri));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeRevisionContent retrieveRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException, RevisionNotFoundException {
        if (this.contentStore.cacheResults() && this.contentCache != null) {
            if (this.isForceStoreEnlistment(uri)) {
                this.enlist(this);
            }
            try {
                String key = uri.toString() + "_" + revisionDescriptor.getRevisionNumber();
                Object result = this.contentCache.get(key);
                if (result != null) {
                    this.getLogger().log("Retrieving content at '" + key + "' from cache", LOG_CHANNEL, 7);
                    NodeRevisionContent nodeRevisionContent = (NodeRevisionContent)result;
                    return nodeRevisionContent;
                }
                NodeRevisionContent revisionContent = super.retrieveRevisionContent(uri, revisionDescriptor);
                long size = revisionDescriptor.getContentLength();
                this.contentCache.put(key, revisionContent, size);
                NodeRevisionContent nodeRevisionContent = revisionContent;
                return nodeRevisionContent;
            }
            finally {
                if (this.isForceStoreEnlistment(uri)) {
                    this.delist(this);
                }
            }
        }
        return super.retrieveRevisionContent(uri, revisionDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws ServiceAccessException, RevisionAlreadyExistException {
        long size = -1L;
        if (this.contentStore.cacheResults() && this.contentCache != null) {
            size = revisionDescriptor.getContentLength();
            this.contentCache.precache(revisionContent, size);
        }
        super.createRevisionContent(uri, revisionDescriptor, revisionContent);
        if (this.contentStore.cacheResults() && this.contentCache != null) {
            this.enlist(this);
            try {
                String key = uri.toString() + "_" + revisionDescriptor.getRevisionNumber();
                this.contentCache.put(key, revisionContent, size);
            }
            finally {
                this.delist(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws ServiceAccessException, RevisionNotFoundException {
        long size = -1L;
        if (this.contentStore.cacheResults() && this.contentCache != null) {
            size = revisionDescriptor.getContentLength();
            this.contentCache.precache(revisionContent, size);
        }
        super.storeRevisionContent(uri, revisionDescriptor, revisionContent);
        if (this.contentStore.cacheResults() && this.contentCache != null) {
            this.enlist(this);
            try {
                String key = uri.toString() + "_" + revisionDescriptor.getRevisionNumber();
                this.contentCache.put(key, revisionContent, size);
            }
            finally {
                this.delist(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException {
        if (this.contentStore.cacheResults() && this.contentCache != null) {
            this.enlist(this);
            try {
                String key = uri.toString() + "_" + revisionDescriptor.getRevisionNumber();
                this.contentCache.remove(key);
            }
            finally {
                this.delist(this);
            }
        }
        super.removeRevisionContent(uri, revisionDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectNode retrieveObject(Uri uri) throws ServiceAccessException, ObjectNotFoundException {
        if (this.nodeStore.cacheResults()) {
            if (this.isForceStoreEnlistment(uri)) {
                this.enlist(this);
            }
            try {
                Object tempObject = this.objectsCache.get(uri.toString());
                if (tempObject != null) {
                    ObjectNode objectNode = ((ObjectNode)tempObject).cloneObject();
                    return objectNode;
                }
                ObjectNode objectNode = super.retrieveObject(uri);
                objectNode.validate(uri.toString());
                this.objectsCache.put(uri.toString(), objectNode);
                ObjectNode objectNode2 = objectNode.cloneObject();
                return objectNode2;
            }
            finally {
                if (this.isForceStoreEnlistment(uri)) {
                    this.delist(this);
                }
            }
        }
        return super.retrieveObject(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeObject(Uri uri, ObjectNode object) throws ServiceAccessException, ObjectNotFoundException {
        super.storeObject(uri, object);
        if (this.nodeStore.cacheResults()) {
            this.enlist(this);
            try {
                this.objectsCache.put(uri.toString(), object.cloneObject());
            }
            finally {
                this.delist(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createObject(Uri uri, ObjectNode object) throws ServiceAccessException, ObjectAlreadyExistsException {
        super.createObject(uri, object);
        if (this.nodeStore.cacheResults()) {
            this.enlist(this);
            try {
                String linkedUri;
                ObjectNode linkedObject;
                if (object instanceof LinkNode && (linkedObject = (ObjectNode)this.objectsCache.get(linkedUri = ((LinkNode)object).getLinkedUri())) != null) {
                    linkedObject.addLink((LinkNode)object);
                }
                this.objectsCache.put(uri.toString(), object.cloneObject());
            }
            finally {
                this.delist(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObject(Uri uri, ObjectNode object) throws ServiceAccessException, ObjectNotFoundException {
        super.removeObject(uri, object);
        if (this.nodeStore.cacheResults()) {
            this.enlist(this);
            try {
                ObjectNode linkedObject;
                if (object instanceof LinkNode && (linkedObject = (ObjectNode)this.objectsCache.get(((LinkNode)object).getLinkedUri())) != null) {
                    linkedObject.removeLink((LinkNode)object);
                }
                this.objectsCache.remove(uri.toString());
            }
            finally {
                this.delist(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void grantPermission(Uri uri, NodePermission permission) throws ServiceAccessException {
        super.grantPermission(uri, permission);
        if (this.securityStore.cacheResults()) {
            this.enlist(this);
            try {
                Vector permissionsVector = this.fillPermissionsCache(uri);
                Vector tempPermissions = (Vector)permissionsVector.clone();
                tempPermissions.addElement(permission);
                this.permissionsCache.put(uri.toString(), tempPermissions);
            }
            finally {
                this.delist(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revokePermission(Uri uri, NodePermission permission) throws ServiceAccessException {
        super.revokePermission(uri, permission);
        if (this.securityStore.cacheResults()) {
            this.enlist(this);
            try {
                Vector permissionsVector = this.fillPermissionsCache(uri);
                Vector tempPermissions = (Vector)permissionsVector.clone();
                tempPermissions.removeElement(permission);
                this.permissionsCache.put(uri.toString(), tempPermissions);
            }
            finally {
                this.delist(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revokePermissions(Uri uri) throws ServiceAccessException {
        super.revokePermissions(uri);
        if (this.securityStore.cacheResults()) {
            this.enlist(this);
            try {
                Object value = this.permissionsCache.get(uri.toString());
                if (value != null) {
                    this.permissionsCache.put(uri.toString(), new Vector());
                }
            }
            finally {
                this.delist(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration enumeratePermissions(Uri uri) throws ServiceAccessException {
        if (this.securityStore.cacheResults()) {
            if (this.isForceStoreEnlistment(uri)) {
                this.enlist(this);
            }
            try {
                Vector permissionsVector = this.fillPermissionsCache(uri);
                Enumeration enumeration = ((Vector)permissionsVector.clone()).elements();
                return enumeration;
            }
            finally {
                if (this.isForceStoreEnlistment(uri)) {
                    this.delist(this);
                }
            }
        }
        return super.enumeratePermissions(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putLock(Uri uri, NodeLock lock) throws ServiceAccessException {
        super.putLock(uri, lock);
        if (this.lockStore.cacheResults()) {
            this.enlist(this);
            try {
                Vector locks = this.fillLocksCache(uri);
                Vector tempLocks = (Vector)locks.clone();
                tempLocks.addElement(lock.cloneObject());
                this.locksCache.put(uri.toString(), tempLocks);
            }
            finally {
                this.delist(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renewLock(Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        super.renewLock(uri, lock);
        if (this.lockStore.cacheResults()) {
            this.enlist(this);
            try {
                Object value = this.locksCache.get(uri.toString());
                Vector<NodeLock> locksVector = null;
                if (value != null) {
                    locksVector = new Vector<NodeLock>((Vector)value);
                    boolean wasPresent = locksVector.removeElement(lock);
                    if (!wasPresent) {
                        throw new LockTokenNotFoundException(lock);
                    }
                    locksVector.addElement(lock.cloneObject());
                    this.locksCache.put(uri.toString(), locksVector);
                }
            }
            finally {
                this.delist(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLock(Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        super.removeLock(uri, lock);
        if (this.lockStore.cacheResults()) {
            this.enlist(this);
            try {
                Object value = this.locksCache.get(uri.toString());
                Vector locksVector = null;
                if (value != null) {
                    locksVector = new Vector((Vector)value);
                    boolean wasPresent = locksVector.removeElement(lock);
                    if (!wasPresent) {
                        throw new LockTokenNotFoundException(lock);
                    }
                    this.locksCache.put(uri.toString(), locksVector);
                }
            }
            finally {
                this.delist(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killLock(Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        super.killLock(uri, lock);
        if (this.lockStore.cacheResults()) {
            this.enlist(this);
            try {
                Object value = this.locksCache.get(uri.toString());
                Vector locksVector = null;
                if (value != null) {
                    locksVector = new Vector((Vector)value);
                    boolean wasPresent = locksVector.removeElement(lock);
                    if (!wasPresent) {
                        throw new LockTokenNotFoundException(lock);
                    }
                    this.locksCache.put(uri.toString(), locksVector);
                }
            }
            finally {
                this.delist(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration enumerateLocks(Uri uri) throws ServiceAccessException {
        if (this.lockStore.cacheResults()) {
            if (this.isForceStoreEnlistment(uri)) {
                this.enlist(this);
            }
            try {
                Vector locks = this.fillLocksCache(uri);
                Enumeration enumeration = ((Vector)locks.clone()).elements();
                return enumeration;
            }
            finally {
                if (this.isForceStoreEnlistment(uri)) {
                    this.delist(this);
                }
            }
        }
        return super.enumerateLocks(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeRevisionDescriptors retrieveRevisionDescriptors(Uri uri) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        if (this.revisionDescriptorsStore.cacheResults()) {
            if (this.isForceStoreEnlistment(uri)) {
                this.enlist(this);
            }
            try {
                Object tempObject = this.descriptorsCache.get(uri.toString());
                if (tempObject != null) {
                    NodeRevisionDescriptors nodeRevisionDescriptors = ((NodeRevisionDescriptors)tempObject).cloneObject();
                    return nodeRevisionDescriptors;
                }
                NodeRevisionDescriptors revisionDescriptors = super.retrieveRevisionDescriptors(uri);
                this.descriptorsCache.put(uri.toString(), revisionDescriptors);
                revisionDescriptors.validate(uri.toString());
                NodeRevisionDescriptors nodeRevisionDescriptors = revisionDescriptors.cloneObject();
                return nodeRevisionDescriptors;
            }
            finally {
                if (this.isForceStoreEnlistment(uri)) {
                    this.delist(this);
                }
            }
        }
        return super.retrieveRevisionDescriptors(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createRevisionDescriptors(Uri uri, NodeRevisionDescriptors revisionDescriptors) throws ServiceAccessException {
        super.createRevisionDescriptors(uri, revisionDescriptors);
        if (this.revisionDescriptorsStore.cacheResults()) {
            this.enlist(this);
            try {
                this.descriptorsCache.put(uri.toString(), revisionDescriptors.cloneObject());
            }
            finally {
                this.delist(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeRevisionDescriptors(Uri uri, NodeRevisionDescriptors revisionDescriptors) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        super.storeRevisionDescriptors(uri, revisionDescriptors);
        if (this.revisionDescriptorsStore.cacheResults()) {
            this.enlist(this);
            try {
                this.descriptorsCache.put(uri.toString(), revisionDescriptors.cloneObject());
            }
            finally {
                this.delist(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRevisionDescriptors(Uri uri) throws ServiceAccessException {
        if (this.revisionDescriptorsStore.cacheResults()) {
            this.enlist(this);
            try {
                this.descriptorsCache.remove(uri.toString());
            }
            finally {
                this.delist(this);
            }
        }
        super.removeRevisionDescriptors(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeRevisionDescriptor retrieveRevisionDescriptor(Uri uri, NodeRevisionNumber revisionNumber) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        if (this.revisionDescriptorStore.cacheResults()) {
            if (this.isForceStoreEnlistment(uri)) {
                this.enlist(this);
            }
            try {
                Object result = this.descriptorCache.get(uri + "-" + revisionNumber);
                if (result != null) {
                    NodeRevisionDescriptor nodeRevisionDescriptor = ((NodeRevisionDescriptor)result).cloneObject();
                    return nodeRevisionDescriptor;
                }
                NodeRevisionDescriptor revisionDescriptor = super.retrieveRevisionDescriptor(uri, revisionNumber);
                revisionDescriptor.validate();
                this.descriptorCache.put(uri + "-" + revisionNumber, revisionDescriptor);
                NodeRevisionDescriptor nodeRevisionDescriptor = revisionDescriptor.cloneObject();
                return nodeRevisionDescriptor;
            }
            finally {
                if (this.isForceStoreEnlistment(uri)) {
                    this.delist(this);
                }
            }
        }
        return super.retrieveRevisionDescriptor(uri, revisionNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createRevisionDescriptor(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException {
        super.createRevisionDescriptor(uri, revisionDescriptor);
        if (this.revisionDescriptorStore.cacheResults()) {
            this.enlist(this);
            try {
                this.descriptorCache.put(uri + "-" + revisionDescriptor.getRevisionNumber(), revisionDescriptor.cloneObject());
            }
            finally {
                this.delist(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeRevisionDescriptor(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        super.storeRevisionDescriptor(uri, revisionDescriptor);
        if (this.revisionDescriptorStore.cacheResults()) {
            this.enlist(this);
            try {
                String key = uri + "-" + revisionDescriptor.getRevisionNumber();
                this.descriptorCache.put(key, revisionDescriptor.cloneObject());
            }
            finally {
                this.delist(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRevisionDescriptor(Uri uri, NodeRevisionNumber number) throws ServiceAccessException {
        super.removeRevisionDescriptor(uri, number);
        if (this.revisionDescriptorStore.cacheResults()) {
            this.enlist(this);
            try {
                this.descriptorCache.remove(uri + "-" + number);
            }
            finally {
                this.delist(this);
            }
        }
    }

    public void forget(Xid xid) throws XAException {
        this.releaseTransientLocks();
        Xid txId = XidWrapper.wrap((Xid)xid);
        this.activeTransactionBranch.set(null);
        this.objectsCache.getTxCache().forget(txId);
        this.permissionsCache.getTxCache().forget(txId);
        this.locksCache.getTxCache().forget(txId);
        this.descriptorsCache.getTxCache().forget(txId);
        this.descriptorCache.getTxCache().forget(txId);
        if (this.contentCache != null) {
            this.contentCache.getTxCache().forget(txId);
        }
    }

    public void rollback(Xid xid) throws XAException {
        this.releaseTransientLocks();
        Xid txId = XidWrapper.wrap((Xid)xid);
        this.activeTransactionBranch.set(null);
        this.objectsCache.getTxCache().rollback(txId);
        this.permissionsCache.getTxCache().rollback(txId);
        this.locksCache.getTxCache().rollback(txId);
        this.descriptorsCache.getTxCache().rollback(txId);
        this.descriptorCache.getTxCache().rollback(txId);
        if (this.contentCache != null) {
            this.contentCache.getTxCache().rollback(txId);
        }
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        this.releaseTransientLocks();
        Xid txId = XidWrapper.wrap((Xid)xid);
        this.activeTransactionBranch.set(null);
        this.objectsCache.getTxCache().commit(txId);
        this.permissionsCache.getTxCache().commit(txId);
        this.locksCache.getTxCache().commit(txId);
        this.descriptorsCache.getTxCache().commit(txId);
        this.descriptorCache.getTxCache().commit(txId);
        if (this.contentCache != null) {
            this.contentCache.getTxCache().commit(txId);
        }
    }

    public int prepare(Xid xid) throws XAException {
        return 0;
    }

    public void start(Xid xid, int flags) throws XAException {
        this.getLogger().log("Thread " + Thread.currentThread() + (flags == 0 ? " starts" : (flags == 0x200000 ? " joins" : " resumes")) + " work on behalf of transaction branch " + xid, LOG_CHANNEL, 7);
        Xid txId = XidWrapper.wrap((Xid)xid);
        this.activeTransactionBranch.set(txId);
        if (flags == 0 || flags == 0x200000) {
            this.locks.set(new HashSet());
            this.objectsCache.getTxCache().start(txId);
            this.permissionsCache.getTxCache().start(txId);
            this.locksCache.getTxCache().start(txId);
            this.descriptorsCache.getTxCache().start(txId);
            this.descriptorCache.getTxCache().start(txId);
            if (this.contentCache != null) {
                this.contentCache.getTxCache().start(txId);
            }
        } else {
            this.locks.set(this.suspendedLocks.remove(txId));
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        this.getLogger().log("Thread " + Thread.currentThread() + (flags == 0x2000000 ? " suspends" : (flags == 0x20000000 ? " fails" : " ends")) + " work on behalf of transaction branch " + xid, LOG_CHANNEL, 7);
        if (flags == 0x2000000) {
            Xid txId = XidWrapper.wrap((Xid)xid);
            this.suspendedLocks.put(txId, this.locks.get());
        }
        this.locks.set(null);
        this.activeTransactionBranch.set(null);
    }

    public String toString() {
        return this.getName() + "(" + this.getClass().getName() + ")";
    }

    protected void releaseTransientLocks() {
        if (this.locks.get() == null) {
            return;
        }
        Xid txId = (Xid)this.activeTransactionBranch.get();
        Iterator it = ((HashSet)this.locks.get()).iterator();
        while (it.hasNext()) {
            GenericLock lock = (GenericLock)it.next();
            lock.release((Object)txId);
            this.getLogger().log("Release lock: " + txId + " released " + lock.getResourceId().toString(), LOG_CHANNEL, 7);
        }
    }

    protected Vector fillPermissionsCache(Uri uri) throws ServiceAccessException {
        Vector<NodePermission> permissions = (Vector<NodePermission>)this.permissionsCache.get(uri.toString());
        if (permissions != null) {
            return permissions;
        }
        permissions = new Vector<NodePermission>();
        Enumeration permissionsList = super.enumeratePermissions(uri);
        while (permissionsList.hasMoreElements()) {
            NodePermission tempPermission = (NodePermission)permissionsList.nextElement();
            tempPermission.validate(uri.toString());
            permissions.addElement(tempPermission);
        }
        this.permissionsCache.put(uri.toString(), permissions);
        return permissions;
    }

    protected Vector fillLocksCache(Uri uri) throws ServiceAccessException {
        Vector<NodeLock> locksVector = (Vector<NodeLock>)this.locksCache.get(uri.toString());
        if (locksVector != null) {
            return locksVector;
        }
        locksVector = new Vector<NodeLock>();
        Enumeration lockList = super.enumerateLocks(uri);
        while (lockList.hasMoreElements()) {
            NodeLock tempLock = (NodeLock)lockList.nextElement();
            tempLock.validate(uri.toString());
            locksVector.addElement(tempLock);
        }
        this.locksCache.put(uri.toString(), locksVector);
        return locksVector;
    }

    protected void init(int globalObjectCacheSize, int globalPermissionCacheSize, int globalLockCacheSize, int globalDescrtiptorsCacheSize, int globalDescrtiptorCacheSize, boolean contentCachingEnabled, int globalContentCacheSize, long contentCacheBytes, int txContentCacheSize, long txContentCacheBytes, long maxByteSizePerEntry, boolean noGlobalCacheInTx) {
        try {
            this.objectsCache = new TxCacheWrapper(globalObjectCacheSize, "object", noGlobalCacheInTx);
            this.permissionsCache = new TxCacheWrapper(globalPermissionCacheSize, "permission", noGlobalCacheInTx);
            this.locksCache = new TxCacheWrapper(globalLockCacheSize, "lock", noGlobalCacheInTx);
            this.descriptorsCache = new TxCacheWrapper(globalDescrtiptorsCacheSize, "descriptors", noGlobalCacheInTx);
            this.descriptorCache = new TxCacheWrapper(globalDescrtiptorCacheSize, "descriptor", noGlobalCacheInTx);
            this.contentCache = contentCachingEnabled ? new TxContentCacheWrapper(new ByteSizeLimitedObjectCache(globalContentCacheSize, txContentCacheSize, contentCacheBytes, txContentCacheBytes, maxByteSizePerEntry, this.getName() + ".content", this.getLogger(), noGlobalCacheInTx)) : null;
        }
        catch (Error e) {
            this.fatalError(e);
        }
        catch (RuntimeException re) {
            this.fatalError(re);
        }
    }

    protected void fatalError(Error e) {
        this.getLogger().log("Fatal error: " + e, LOG_CHANNEL, 1);
        this.getLogger().log(e, LOG_CHANNEL, 1);
        this.setRollbackOnly();
        throw e;
    }

    protected void fatalError(RuntimeException re) {
        this.getLogger().log("Fatal error: " + re, LOG_CHANNEL, 1);
        this.getLogger().log(re, LOG_CHANNEL, 1);
        this.setRollbackOnly();
        throw re;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class TxContentCacheWrapper
    extends TxCacheWrapper {
        public TxContentCacheWrapper(ByteSizeLimitedObjectCache txCache) {
            super(txCache);
        }

        public void precache(NodeRevisionContent revisionContent, long byteSize) {
            if (ExtendedStore.this.globalCacheOff) {
                return;
            }
            try {
                Xid txId = (Xid)ExtendedStore.this.activeTransactionBranch.get();
                if (((ByteSizeLimitedObjectCache)this.getTxCache()).canCache(txId, byteSize)) {
                    revisionContent.getContentBytes();
                }
            }
            catch (Error e) {
                ExtendedStore.this.fatalError(e);
            }
            catch (RuntimeException re) {
                ExtendedStore.this.fatalError(re);
            }
        }

        public void putForRead(Object key, NodeRevisionContent revisionContent, long byteSize) {
            if (ExtendedStore.this.globalCacheOff) {
                return;
            }
            try {
                if (((ByteSizeLimitedObjectCache)this.getTxCache()).canCache(null, byteSize)) {
                    revisionContent.getContentBytes();
                    ((ByteSizeLimitedObjectCache)this.getTxCache()).put(null, key, revisionContent, byteSize);
                    ExtendedStore.this.getLogger().log("Globally caching content at '" + key + "' with " + byteSize + " bytes", LOG_CHANNEL, 7);
                }
            }
            catch (Error e) {
                ExtendedStore.this.fatalError(e);
            }
            catch (RuntimeException re) {
                ExtendedStore.this.fatalError(re);
            }
        }

        public void put(Object key, NodeRevisionContent revisionContent, long byteSize) {
            if (ExtendedStore.this.globalCacheOff) {
                return;
            }
            try {
                Xid txId = (Xid)ExtendedStore.this.activeTransactionBranch.get();
                if (((ByteSizeLimitedObjectCache)this.getTxCache()).canCache(txId, byteSize)) {
                    revisionContent.getContentBytes();
                    ((ByteSizeLimitedObjectCache)this.getTxCache()).put(txId, key, revisionContent, byteSize);
                    ExtendedStore.this.getLogger().log("Caching content at '" + key + "' with " + byteSize + " bytes", LOG_CHANNEL, 7);
                } else {
                    this.getTxCache().remove(txId, key);
                }
            }
            catch (Error e) {
                ExtendedStore.this.fatalError(e);
            }
            catch (RuntimeException re) {
                ExtendedStore.this.fatalError(re);
            }
        }
    }

    protected class TxCacheWrapper
    implements ObjectCache {
        private TxLRUObjectCache txCache;

        public TxCacheWrapper(TxLRUObjectCache txCache) {
            this.txCache = txCache;
        }

        public TxCacheWrapper(int globalCacheSize, String name, boolean noGlobalCacheInTx) {
            this(new TxLRUObjectCache(globalCacheSize, this$0.getName() + "." + name, this$0.getLogger(), noGlobalCacheInTx));
        }

        public Object get(Object key) {
            if (ExtendedStore.this.globalCacheOff) {
                return null;
            }
            try {
                Xid txId = (Xid)ExtendedStore.this.activeTransactionBranch.get();
                return this.txCache.get(txId, key);
            }
            catch (Error e) {
                ExtendedStore.this.fatalError(e);
            }
            catch (RuntimeException re) {
                ExtendedStore.this.fatalError(re);
            }
            return null;
        }

        public void put(Object key, Object value) {
            if (ExtendedStore.this.globalCacheOff) {
                return;
            }
            try {
                Xid txId = (Xid)ExtendedStore.this.activeTransactionBranch.get();
                this.txCache.put(txId, key, value);
            }
            catch (Error e) {
                ExtendedStore.this.fatalError(e);
            }
            catch (RuntimeException re) {
                ExtendedStore.this.fatalError(re);
            }
        }

        public void remove(Object key) {
            if (ExtendedStore.this.globalCacheOff) {
                return;
            }
            try {
                Xid txId = (Xid)ExtendedStore.this.activeTransactionBranch.get();
                this.txCache.remove(txId, key);
                ExtendedStore.this.getLogger().log("Removing content at '" + key + "' from cache", LOG_CHANNEL, 7);
            }
            catch (Error e) {
                ExtendedStore.this.fatalError(e);
            }
            catch (RuntimeException re) {
                ExtendedStore.this.fatalError(re);
            }
        }

        public void remove(Object key, String delimiter) {
            if (ExtendedStore.this.globalCacheOff) {
                return;
            }
            try {
                Xid txId = (Xid)ExtendedStore.this.activeTransactionBranch.get();
                this.txCache.remove(txId, key, delimiter);
                ExtendedStore.this.getLogger().log("Removing content at '" + key + "' with delimeter '" + delimiter + "' from cache", LOG_CHANNEL, 7);
            }
            catch (Error e) {
                ExtendedStore.this.fatalError(e);
            }
            catch (RuntimeException re) {
                ExtendedStore.this.fatalError(re);
            }
        }

        public void clear() {
            try {
                this.txCache.clear();
            }
            catch (Error e) {
                ExtendedStore.this.fatalError(e);
            }
            catch (RuntimeException re) {
                ExtendedStore.this.fatalError(re);
            }
        }

        public TxLRUObjectCache getTxCache() {
            return this.txCache;
        }
    }
}

