/*
 * Decompiled with CFR 0.152.
 */
package fr.univrennes1.cri.util.cacheManagement;

import fr.univrennes1.cri.util.cacheManagement.Cacheable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;

public class CacheManager {
    private static final String CLASS_NAME = "fr.univrennes1.cri.util.cacheManagement.CacheManager";
    private int DEFAUT_SLEEPING_TIME = 5000;
    private static HashMap cacheHashMap;
    private static CacheCleaner cacheCleaner;
    public static Logger logger;

    public CacheManager(int milliSecondSleepingTime) {
        cacheHashMap = new HashMap();
        cacheCleaner = new CacheCleaner(milliSecondSleepingTime);
        cacheCleaner.setDaemon(true);
        logger = Logger.getLogger((String)this.getClass().getName());
        cacheCleaner.start();
    }

    public CacheManager() {
        cacheHashMap = new HashMap();
        cacheCleaner = new CacheCleaner(this.DEFAUT_SLEEPING_TIME);
        cacheCleaner.setDaemon(true);
        logger = Logger.getLogger((String)this.getClass().getName());
        cacheCleaner.start();
    }

    public static synchronized void putCache(Cacheable object) {
        if (logger.isDebugEnabled() && object != null) {
            logger.debug((Object)("fr.univrennes1.cri.util.cacheManagement.CacheManager:putCache:" + ((Object)object).toString()));
        }
        cacheHashMap.put(object.getIdentifier(), object);
    }

    public static synchronized Cacheable getCache(Object identifier) {
        Cacheable object = null;
        if (identifier != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("fr.univrennes1.cri.util.cacheManagement.CacheManager:getCache:" + identifier.toString()));
            }
            if ((object = (Cacheable)cacheHashMap.get(identifier)) != null && object.isExpired()) {
                if (logger.isDebugEnabled() && object != null) {
                    logger.debug((Object)("fr.univrennes1.cri.util.cacheManagement.CacheManager:getCache:Object " + ((Object)object).toString() + " expired !"));
                }
                cacheHashMap.remove(identifier);
                object = null;
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)"fr.univrennes1.cri.util.cacheManagement.CacheManager:getCache:identifier null !");
        }
        if (logger.isDebugEnabled() && object != null) {
            logger.debug((Object)("fr.univrennes1.cri.util.cacheManagement.CacheManager:getCache:object returned from the cache - object=" + ((Object)object).toString()));
        }
        if (logger.isDebugEnabled() && object == null) {
            logger.debug((Object)"fr.univrennes1.cri.util.cacheManagement.CacheManager:getCache:object not found in the cache");
        }
        return object;
    }

    private static synchronized void cleanCache() {
        Object key;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"fr.univrennes1.cri.util.cacheManagement.CacheManager:cleanCache");
        }
        Iterator keysIterator = cacheHashMap.keySet().iterator();
        Vector<Object> entriesToRemoveVector = new Vector<Object>();
        while (keysIterator != null && keysIterator.hasNext()) {
            key = keysIterator.next();
            Cacheable value = (Cacheable)cacheHashMap.get(key);
            if (!value.isExpired()) continue;
            entriesToRemoveVector.add(key);
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("fr.univrennes1.cri.util.cacheManagement.CacheManager:cleanCache:expired entry found - key=" + key.toString()));
        }
        Enumeration entriesToRemoveEnumeration = entriesToRemoveVector.elements();
        while (entriesToRemoveEnumeration.hasMoreElements()) {
            key = entriesToRemoveEnumeration.nextElement();
            logger.debug((Object)("fr.univrennes1.cri.util.cacheManagement.CacheManager:cleanCache:removing expired entry - key=" + key.toString()));
            cacheHashMap.remove(key);
        }
    }

    private class CacheCleaner
    extends Thread {
        private int milliSecondSleepingTime;

        public CacheCleaner(int milliSecondSleepingTime) {
            this.milliSecondSleepingTime = milliSecondSleepingTime == 0 ? 1000 : milliSecondSleepingTime;
        }

        public void run() {
            while (true) {
                CacheManager.cleanCache();
                try {
                    Thread.sleep(this.milliSecondSleepingTime);
                    continue;
                }
                catch (InterruptedException e) {
                    logger.fatal((Object)("fr.univrennes1.cri.util.cacheManagement.CacheManager$CacheCleaner:run:" + e.getMessage()));
                    continue;
                }
                break;
            }
        }
    }
}

