/*
 * HomedirCreation.java,v 1.0 29/06/2004
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)
 * Classes: Config
 * Original Author: Thomas BELLEMBOIS
 */

package org.esupportail.portal.utils.injac.injacV2SpacesCreation.config;

/**
 * @author : Thomas BELLEMBOIS
 * date : 29 juin 2004
 * Parses the configuration file of the injacSpacesCreation application and generate getters to access its entries
 */
import java.io.IOException;
import java.net.URL;
import org.apache.commons.digester.*;
import org.esupportail.portal.utils.injac.injacV2SpacesCreation.exception.ConfigException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.apache.log4j.*;

public class Config {
	
	private String injacPath;
	private String editorSpacesPath;
	private String publicationSpacesPath;
	private String authorsGroupPrefix;
	private String editorsGroupPrefix;
	
	private String webdavServerUrl;
	private String webdavServerLogin;
	private String webdavServerPassword;
	private String webdavServerUsersRole;
	
	private String userDirectoryRootDirectory;
	
	private String roleDirectoryRootDirectory;			// directory where roles are stored on the WebDav server
	private String roleDirectoryLocalRolesDirectory;	// directory where local roles are stored on the WebDav server
	private String roleDirectoryUPortalRolesDirectory;  // directory where uPortal roles are stored on the WebDav server
	
	private static Config singleton = null;
	
	private Logger logger = Logger.getLogger("HomedirCreationConfig");
	
	private Config() throws ConfigException{
		
		//  Getting the configuration file
		Class requestingClass = this.getClass();
		URL resourceURL = requestingClass.getResource("/properties/config.xml");
		if (resourceURL == null){
			throw new ConfigException("Config","init","Configuration file not found");
		}
		
		//  Creating a Digester
		Digester dig = new Digester();
		dig.push(this);
		
		// Registering the entries of the configuration file
		dig.addCallMethod("root/injacSpaces","configInjacSpaces",5);
		dig.addCallParam("root/injacSpaces",0,"injacPath");
		dig.addCallParam("root/injacSpaces",1,"editorSpacesPath");
		dig.addCallParam("root/injacSpaces",2,"publicationSpacesPath");
		dig.addCallParam("root/injacSpaces",3,"authorsGroupPrefix");
		dig.addCallParam("root/injacSpaces",4,"editorsGroupPrefix");
		
		dig.addCallMethod("root/webdavServer","configWebdavServer",4);
		dig.addCallParam("root/webdavServer",0,"url");
		dig.addCallParam("root/webdavServer",1,"login");
		dig.addCallParam("root/webdavServer",2,"password");
		dig.addCallParam("root/webdavServer",3,"usersRole");

		dig.addCallMethod("root/usersDirectory","configUserDirectory",1);
		dig.addCallParam("root/usersDirectory",0,"rootDirectory");
		
		dig.addCallMethod("root/rolesDirectory","configRoleDirectory",3);
		dig.addCallParam("root/rolesDirectory",0,"rootDirectory");
		dig.addCallParam("root/rolesDirectory",1,"localRolesDirectory");
		dig.addCallParam("root/rolesDirectory",2,"uPortalRolesDirectory");
		
		try{
			//  Reading the configuration file
			dig.parse(new InputSource(resourceURL.toExternalForm()));
		}
		catch(SAXException saxException){
			logger.info("HomedirCreationConfig::HomedirCreationConfig::"+saxException);
			throw new ConfigException();}
		catch(IOException ioException){
			logger.info("HomedirCreationConfig::HomedirCreationConfig::"+ioException);
			throw new ConfigException();
		}
		
	}// Config
	
	public void configInjacSpaces(String injacPath, String editorSpacesPath, String publicationSpacesPath, String authorsGroupPrefix, String editorsGroupPrefix){
		this.injacPath = injacPath;
		this.editorSpacesPath = editorSpacesPath;
		this.publicationSpacesPath = publicationSpacesPath;
		this.authorsGroupPrefix = authorsGroupPrefix;
		this.editorsGroupPrefix = editorsGroupPrefix;
	}// configInjacSpaces
	
	public void configWebdavServer(String webdavServerUrl, String webdavServerLogin, String webdavServerPassword, String webdavServerUsersRole){
		this.webdavServerUrl = webdavServerUrl;
		this.webdavServerLogin = webdavServerLogin;
		this.webdavServerPassword = webdavServerPassword;
		this.webdavServerUsersRole = webdavServerUsersRole;
	}// configWebdavServer
	
	public void configUserDirectory(String userDirectoryRootDirectory){
		this.userDirectoryRootDirectory = userDirectoryRootDirectory;
	}// configUserDirectory
	
	public void configRoleDirectory(String roleDirectoryRootDirectory, String roleDirectoryLocalRolesDirectory, String roleDirectoryUPortalRolesDirectory){
		this.roleDirectoryRootDirectory = roleDirectoryRootDirectory;
		this.roleDirectoryLocalRolesDirectory = roleDirectoryLocalRolesDirectory;
		this.roleDirectoryUPortalRolesDirectory = roleDirectoryUPortalRolesDirectory;
	}// configUserDirectory
	
	public static Config getInstance() throws ConfigException{
		if(singleton == null) {
			singleton = new Config();
		}
		return singleton;
	}// getInstance
	/**
	 * @return Returns the singleton.
	 */
	public static Config getSingleton() {
		return singleton;
	}
	/**
	 * @return Returns the authorsGroupPrefix.
	 */
	public String getAuthorsGroupPrefix() {
		return authorsGroupPrefix;
	}
	/**
	 * @return Returns the editorsGroupPrefix.
	 */
	public String getEditorsGroupPrefix() {
		return editorsGroupPrefix;
	}
	/**
	 * @return Returns the editorSpacesPath.
	 */
	public String getEditorSpacesPath() {
		return editorSpacesPath;
	}
	/**
	 * @return Returns the injacPath.
	 */
	public String getInjacPath() {
		return injacPath;
	}
	/**
	 * @return Returns the publicationSpacesPath.
	 */
	public String getPublicationSpacesPath() {
		return publicationSpacesPath;
	}
	/**
	 * @return Returns the roleDirectoryRootDirectory.
	 */
	public String getRoleDirectoryRootDirectory() {
		return roleDirectoryRootDirectory;
	}
	/**
	 * @return Returns the roleDirectoryLocalRolesDirectory.
	 */
	public String getRoleDirectoryLocalRolesDirectory() {
		return roleDirectoryLocalRolesDirectory;
	}
	/**
	 * @return Returns the roleDirectoryUPortalRolesDirectory.
	 */
	public String getRoleDirectoryUPortalRolesDirectory() {
		return roleDirectoryUPortalRolesDirectory;
	}
	/**
	 * @return Returns the userDirectoryRootDirectory.
	 */
	public String getUserDirectoryRootDirectory() {
		return userDirectoryRootDirectory;
	}
	/**
	 * @return Returns the webdavServerLogin.
	 */
	public String getWebdavServerLogin() {
		return webdavServerLogin;
	}
	/**
	 * @return Returns the webdavServerPassword.
	 */
	public String getWebdavServerPassword() {
		return webdavServerPassword;
	}
	/**
	 * @return Returns the webdavServerUrl.
	 */
	public String getWebdavServerUrl() {
		return webdavServerUrl;
	}
	/**
	 * @return Returns the webdavServerUsersRole.
	 */
	public String getWebdavServerUsersRole() {
		return webdavServerUsersRole;
	}
}// HomedirCreation
