/*
 *  Copyright (c) 2000-2003 Yale University. All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED "AS IS," AND ANY EXPRESS OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, ARE EXPRESSLY
 *  DISCLAIMED. IN NO EVENT SHALL YALE UNIVERSITY OR ITS EMPLOYEES BE
 *  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED, THE COSTS OF
 *  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 *  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH
 *  DAMAGE.
 *
 *  Redistribution and use of this software in source or binary forms,
 *  with or without modification, are permitted, provided that the
 *  following conditions are met:
 *
 *  1. Any redistribution must include the above copyright notice and
 *  disclaimer and this list of conditions in any related documentation
 *  and, if feasible, in the redistributed software.
 *
 *  2. Any redistribution must include the acknowledgment, "This product
 *  includes software developed by Yale University," in any related
 *  documentation and, if feasible, in the redistributed software.
 *
 *  3. The names "Yale" and "Yale University" must not be used to endorse
 *  or promote products derived from this software.
 */

package org.esupportail.filter.LDAPFilter;

import javax.servlet.http.*;

/**
 * <p>Wraps the <code>HttpServletRequest</code> object, replacing
 * <code>getRemoteUser()</code> with a version that returns the current
 * CAS logged-in user.</p>
 *
 * @author Drew Mazurek
 */
public class LDAPFilterRequestWrapper extends HttpServletRequestWrapper {

    public LDAPFilterRequestWrapper(HttpServletRequest request) {
	super(request);
    }

    /**
     * <p>Returns the currently logged in CAS user.</p>
     * <p>Specifically, this returns the value of the session attribute,
     * <code>CASFilter.CAS_FILTER_USER</code>.</p>
     */
    public String getRemoteUser() {
    	return (String)getSession().getAttribute(LDAPFilter.LDAP_FILTER_USER);
    }
    
    public java.security.Principal getUserPrincipal() {
    	return new Principal((String)getSession().getAttribute(LDAPFilter.LDAP_FILTER_USER));
    }
}
