/*
 * $Header: /esup-portail/injac/applications/SlideServer/Packages/esup-serveur-WebDav-3/update/slide/add-ons/stores/uPortalStore/src/stores/org/apache/slide/common/Scope.java,v 1.1 2005/02/08 09:23:40 tbellemb Exp $
 * $Revision: 1.1 $
 * $Date: 2005/02/08 09:23:40 $
 *
 * ====================================================================
 *
 * Copyright 1999-2002 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.slide.common;

/**
 * Scope object.
 * <p/>
 * A scope represents a directory on the server. Ex : /foo/bar.txt belongs
 * to the /foo/ scope.
 *
 * @version $Revision: 1.1 $
 */
public final class Scope {
    
    public static final Scope ROOT = new Scope("/");
    
    // ----------------------------------------------------------- Constructors
    
    
    /**
     * Constructor.
     *
     * @param scope String representation of the scope.
     */
    public Scope(String scope) {
        this.scope = scope;
        scopeID = scope.hashCode();
    }
    
    
    // ----------------------------------------------------- Instance Variables
    
    
    /**
     * Hash code of the scope.
     */
    private int scopeID;
    
    
    /**
     * String representation of the scope.
     */
    private String scope;
    
    
    // --------------------------------------------------------- Public Methods
    
    
    /**
     * Returns the String representation of the scope.
     *
     * @return String
     */
    public String toString() {
        return this.scope;
    }
    
    
    /**
     * Tests if two scopes ore equal.
     *
     * @param obj Object to test
     * @return boolean True if the object is equal to the scope
     */
    public boolean equals(Object obj) {
        boolean result = false;
        if ((obj != null) && (obj instanceof Scope)) {
            Scope scope = (Scope) obj;
            result = (this.scopeID == scope.hashCode());
        }
        return result;
    }
    
    
    /**
     * Hash code.
     *
     * @return int Result is the hash code of the String representation
     * of the scope
     */
    public int hashCode() {
        return this.scopeID;
    }
    
}
