/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.encoding;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.pdfbox.cos.COSName;

public abstract class Encoding {
    protected Map codeToName = new HashMap();
    protected Map nameToCode = new HashMap();
    private static final Map NAME_TO_CHARACTER = new HashMap();
    private static final Map CHARACTER_TO_NAME = new HashMap();

    protected void addCharacterEncoding(int code, COSName name) {
        Integer intCode = new Integer(code);
        this.codeToName.put(intCode, name);
        this.nameToCode.put(name, intCode);
    }

    public int getCode(COSName name) throws IOException {
        Integer code = (Integer)this.nameToCode.get(name);
        if (code == null) {
            throw new IOException("No character code for character name '" + name.getName() + "'");
        }
        return code;
    }

    public COSName getName(int code) throws IOException {
        COSName name = (COSName)this.codeToName.get(new Integer(code));
        if (name == null) {
            name = COSName.getPDFName("space");
        }
        return name;
    }

    public COSName getNameFromCharacter(char c) throws IOException {
        COSName name = (COSName)CHARACTER_TO_NAME.get("" + c);
        if (name == null) {
            throw new IOException("No name for character '" + c + "'");
        }
        return name;
    }

    public String getCharacter(int code) throws IOException {
        return Encoding.getCharacter(this.getName(code));
    }

    public static String getCharacter(COSName name) {
        String character = (String)NAME_TO_CHARACTER.get(name);
        if (character == null) {
            character = name.getName();
        }
        return character;
    }

    static {
        NAME_TO_CHARACTER.put(COSName.getPDFName(".notdef"), "");
        NAME_TO_CHARACTER.put(COSName.getPDFName("A"), "A");
        NAME_TO_CHARACTER.put(COSName.getPDFName("AE"), "\u00c6");
        NAME_TO_CHARACTER.put(COSName.getPDFName("Aacute"), "\u00c1");
        NAME_TO_CHARACTER.put(COSName.getPDFName("Acircumflex"), "\u00c2");
        NAME_TO_CHARACTER.put(COSName.getPDFName("Adieresis"), "\u00c4");
        NAME_TO_CHARACTER.put(COSName.getPDFName("Agrave"), "\u00c0");
        NAME_TO_CHARACTER.put(COSName.getPDFName("Alpha"), "?");
        NAME_TO_CHARACTER.put(COSName.getPDFName("Aring"), "\u00c5");
        NAME_TO_CHARACTER.put(COSName.getPDFName("Atilde"), "\u00c3");
        NAME_TO_CHARACTER.put(COSName.getPDFName("B"), "B");
        NAME_TO_CHARACTER.put(COSName.getPDFName("Beta"), "?");
        NAME_TO_CHARACTER.put(COSName.getPDFName("C"), "C");
        NAME_TO_CHARACTER.put(COSName.getPDFName("Ccedilla"), "\u00c7");
        NAME_TO_CHARACTER.put(COSName.getPDFName("Chi"), "?");
        NAME_TO_CHARACTER.put(COSName.getPDFName("D"), "D");
        NAME_TO_CHARACTER.put(COSName.getPDFName("Delta"), "delta");
        NAME_TO_CHARACTER.put(COSName.getPDFName("E"), "E");
        NAME_TO_CHARACTER.put(COSName.getPDFName("Eacute"), "\u00c9");
        NAME_TO_CHARACTER.put(COSName.getPDFName("Ecircumflex"), "\u00ca");
        NAME_TO_CHARACTER.put(COSName.getPDFName("Edieresis"), "\u00cb");
        NAME_TO_CHARACTER.put(COSName.getPDFName("Egrave"), "\u00c8");
        NAME_TO_CHARACTER.put(COSName.getPDFName("Epsilon"), "E");
        NAME_TO_CHARACTER.put(COSName.getPDFName("Eta"), "H");
        NAME_TO_CHARACTER.put(COSName.getPDFName("Euro"), "\u0080");
        NAME_TO_CHARACTER.put(COSName.getPDFName("Eth"), "\u00d0");
        NAME_TO_CHARACTER.put(COSName.getPDFName("Euro"), "\u0080");
        NAME_TO_CHARACTER.put(COSName.getPDFName("F"), "F");
        NAME_TO_CHARACTER.put(COSName.getPDFName("G"), "G");
        NAME_TO_CHARACTER.put(COSName.getPDFName("Gamma"), "G");
        NAME_TO_CHARACTER.put(COSName.getPDFName("H"), "H");
        NAME_TO_CHARACTER.put(COSName.getPDFName("I"), "I");
        NAME_TO_CHARACTER.put(COSName.getPDFName("Iacute"), "\u00cd");
        NAME_TO_CHARACTER.put(COSName.getPDFName("Icircumflex"), "\u00ce");
        NAME_TO_CHARACTER.put(COSName.getPDFName("Idieresis"), "\u00cf");
        NAME_TO_CHARACTER.put(COSName.getPDFName("Ifraktur"), "I");
        NAME_TO_CHARACTER.put(COSName.getPDFName("Igrave"), "\u00cc");
        NAME_TO_CHARACTER.put(COSName.getPDFName("Iota"), "I");
        NAME_TO_CHARACTER.put(COSName.getPDFName("J"), "J");
        NAME_TO_CHARACTER.put(COSName.getPDFName("K"), "K");
        NAME_TO_CHARACTER.put(COSName.getPDFName("Kappa"), "K");
        NAME_TO_CHARACTER.put(COSName.getPDFName("L"), "L");
        NAME_TO_CHARACTER.put(COSName.getPDFName("Lambda"), "?");
        NAME_TO_CHARACTER.put(COSName.getPDFName("Lslash"), "L");
        NAME_TO_CHARACTER.put(COSName.getPDFName("M"), "M");
        NAME_TO_CHARACTER.put(COSName.getPDFName("N"), "N");
        NAME_TO_CHARACTER.put(COSName.getPDFName("Ntilde"), "\u00d1");
        NAME_TO_CHARACTER.put(COSName.getPDFName("O"), "O");
        NAME_TO_CHARACTER.put(COSName.getPDFName("OE"), "\u008c");
        NAME_TO_CHARACTER.put(COSName.getPDFName("Oacute"), "\u00d3");
        NAME_TO_CHARACTER.put(COSName.getPDFName("Ocircumflex"), "\u00d4");
        NAME_TO_CHARACTER.put(COSName.getPDFName("Odieresis"), "\u00d6");
        NAME_TO_CHARACTER.put(COSName.getPDFName("Ograve"), "\u00d2");
        NAME_TO_CHARACTER.put(COSName.getPDFName("Oslash"), "\u00d8");
        NAME_TO_CHARACTER.put(COSName.getPDFName("Otilde"), "\u00d5");
        NAME_TO_CHARACTER.put(COSName.getPDFName("P"), "P");
        NAME_TO_CHARACTER.put(COSName.getPDFName("Q"), "Q");
        NAME_TO_CHARACTER.put(COSName.getPDFName("R"), "R");
        NAME_TO_CHARACTER.put(COSName.getPDFName("S"), "S");
        NAME_TO_CHARACTER.put(COSName.getPDFName("Scaron"), "\u008a");
        NAME_TO_CHARACTER.put(COSName.getPDFName("Sigma"), "?");
        NAME_TO_CHARACTER.put(COSName.getPDFName("T"), "T");
        NAME_TO_CHARACTER.put(COSName.getPDFName("Thorn"), "\u00de");
        NAME_TO_CHARACTER.put(COSName.getPDFName("U"), "U");
        NAME_TO_CHARACTER.put(COSName.getPDFName("Uacute"), "\u00da");
        NAME_TO_CHARACTER.put(COSName.getPDFName("Ucircumflex"), "\u00db");
        NAME_TO_CHARACTER.put(COSName.getPDFName("Udieresis"), "\u00dc");
        NAME_TO_CHARACTER.put(COSName.getPDFName("Ugrave"), "\u00d9");
        NAME_TO_CHARACTER.put(COSName.getPDFName("V"), "V");
        NAME_TO_CHARACTER.put(COSName.getPDFName("W"), "W");
        NAME_TO_CHARACTER.put(COSName.getPDFName("X"), "X");
        NAME_TO_CHARACTER.put(COSName.getPDFName("Y"), "Y");
        NAME_TO_CHARACTER.put(COSName.getPDFName("Yacute"), "\u00dd");
        NAME_TO_CHARACTER.put(COSName.getPDFName("Ydieresis"), "\u009f");
        NAME_TO_CHARACTER.put(COSName.getPDFName("Z"), "Z");
        NAME_TO_CHARACTER.put(COSName.getPDFName("Zcaron"), "\u008e");
        NAME_TO_CHARACTER.put(COSName.getPDFName("a"), "a");
        NAME_TO_CHARACTER.put(COSName.getPDFName("aacute"), "\u00e1");
        NAME_TO_CHARACTER.put(COSName.getPDFName("acircumflex"), "\u00e2");
        NAME_TO_CHARACTER.put(COSName.getPDFName("acute"), "\u00b4");
        NAME_TO_CHARACTER.put(COSName.getPDFName("adieresis"), "\u00e4");
        NAME_TO_CHARACTER.put(COSName.getPDFName("ae"), "\u00e6");
        NAME_TO_CHARACTER.put(COSName.getPDFName("agrave"), "\u00e0");
        NAME_TO_CHARACTER.put(COSName.getPDFName("ampersand"), "&");
        NAME_TO_CHARACTER.put(COSName.getPDFName("aring"), "\u00e5");
        NAME_TO_CHARACTER.put(COSName.getPDFName("arrowhorizex"), "-");
        NAME_TO_CHARACTER.put(COSName.getPDFName("asciicircum"), "^");
        NAME_TO_CHARACTER.put(COSName.getPDFName("asciitilde"), "~");
        NAME_TO_CHARACTER.put(COSName.getPDFName("asterisk"), "*");
        NAME_TO_CHARACTER.put(COSName.getPDFName("at"), "@");
        NAME_TO_CHARACTER.put(COSName.getPDFName("atilde"), "\u00e3");
        NAME_TO_CHARACTER.put(COSName.getPDFName("b"), "b");
        NAME_TO_CHARACTER.put(COSName.getPDFName("backslash"), "\\");
        NAME_TO_CHARACTER.put(COSName.getPDFName("bar"), "|");
        NAME_TO_CHARACTER.put(COSName.getPDFName("braceleft"), "{");
        NAME_TO_CHARACTER.put(COSName.getPDFName("braceright"), "}");
        NAME_TO_CHARACTER.put(COSName.getPDFName("bracketleft"), "[");
        NAME_TO_CHARACTER.put(COSName.getPDFName("bracketright"), "]");
        NAME_TO_CHARACTER.put(COSName.getPDFName("breve"), "\u00c6");
        NAME_TO_CHARACTER.put(COSName.getPDFName("brokenbar"), "\u00a6");
        NAME_TO_CHARACTER.put(COSName.getPDFName("bullet"), "\u0095");
        NAME_TO_CHARACTER.put(COSName.getPDFName("c"), "c");
        NAME_TO_CHARACTER.put(COSName.getPDFName("caron"), "\u00cf");
        NAME_TO_CHARACTER.put(COSName.getPDFName("ccedilla"), "\u00e7");
        NAME_TO_CHARACTER.put(COSName.getPDFName("cedilla"), "\u00b8");
        NAME_TO_CHARACTER.put(COSName.getPDFName("cent"), "\u00a2");
        NAME_TO_CHARACTER.put(COSName.getPDFName("circumflex"), "\u0088");
        NAME_TO_CHARACTER.put(COSName.getPDFName("colon"), ":");
        NAME_TO_CHARACTER.put(COSName.getPDFName("comma"), ",");
        NAME_TO_CHARACTER.put(COSName.getPDFName("copyright"), "\u00a9");
        NAME_TO_CHARACTER.put(COSName.getPDFName("currency"), "\u00a4");
        NAME_TO_CHARACTER.put(COSName.getPDFName("d"), "d");
        NAME_TO_CHARACTER.put(COSName.getPDFName("dagger"), "\u0086");
        NAME_TO_CHARACTER.put(COSName.getPDFName("daggerdbl"), "\u0087");
        NAME_TO_CHARACTER.put(COSName.getPDFName("degree"), "\u00b0");
        NAME_TO_CHARACTER.put(COSName.getPDFName("dieresis"), "\u00a8");
        NAME_TO_CHARACTER.put(COSName.getPDFName("divide"), "\u00f7");
        NAME_TO_CHARACTER.put(COSName.getPDFName("dollar"), "$");
        NAME_TO_CHARACTER.put(COSName.getPDFName("dotaccent"), "\u00fa");
        NAME_TO_CHARACTER.put(COSName.getPDFName("dotlessi"), "\u00f5");
        NAME_TO_CHARACTER.put(COSName.getPDFName("e"), "e");
        NAME_TO_CHARACTER.put(COSName.getPDFName("eacute"), "\u00e9");
        NAME_TO_CHARACTER.put(COSName.getPDFName("ecircumflex"), "\u00ea");
        NAME_TO_CHARACTER.put(COSName.getPDFName("edieresis"), "\u00eb");
        NAME_TO_CHARACTER.put(COSName.getPDFName("egrave"), "\u00e8");
        NAME_TO_CHARACTER.put(COSName.getPDFName("eight"), "8");
        NAME_TO_CHARACTER.put(COSName.getPDFName("ellipsis"), "\u0085");
        NAME_TO_CHARACTER.put(COSName.getPDFName("emdash"), "\u0097");
        NAME_TO_CHARACTER.put(COSName.getPDFName("endash"), "\u0096");
        NAME_TO_CHARACTER.put(COSName.getPDFName("equal"), "=");
        NAME_TO_CHARACTER.put(COSName.getPDFName("eth"), "\u00f0");
        NAME_TO_CHARACTER.put(COSName.getPDFName("exclam"), "!");
        NAME_TO_CHARACTER.put(COSName.getPDFName("exclamdown"), "\u00a1");
        NAME_TO_CHARACTER.put(COSName.getPDFName("f"), "f");
        NAME_TO_CHARACTER.put(COSName.getPDFName("fi"), "fi");
        NAME_TO_CHARACTER.put(COSName.getPDFName("five"), "5");
        NAME_TO_CHARACTER.put(COSName.getPDFName("fl"), "fl");
        NAME_TO_CHARACTER.put(COSName.getPDFName("florin"), "\u0083");
        NAME_TO_CHARACTER.put(COSName.getPDFName("four"), "4");
        NAME_TO_CHARACTER.put(COSName.getPDFName("fraction"), "/");
        NAME_TO_CHARACTER.put(COSName.getPDFName("g"), "g");
        NAME_TO_CHARACTER.put(COSName.getPDFName("germandbls"), "\u00df");
        NAME_TO_CHARACTER.put(COSName.getPDFName("grave"), "`");
        NAME_TO_CHARACTER.put(COSName.getPDFName("greater"), ">");
        NAME_TO_CHARACTER.put(COSName.getPDFName("guillemotleft"), "\u00ab");
        NAME_TO_CHARACTER.put(COSName.getPDFName("guillemotright"), "\u00bb");
        NAME_TO_CHARACTER.put(COSName.getPDFName("guilsinglleft"), "\u008b");
        NAME_TO_CHARACTER.put(COSName.getPDFName("guilsinglright"), "\u009b");
        NAME_TO_CHARACTER.put(COSName.getPDFName("h"), "h");
        NAME_TO_CHARACTER.put(COSName.getPDFName("hungarumlaut"), "\u00cd");
        NAME_TO_CHARACTER.put(COSName.getPDFName("hyphen"), "-");
        NAME_TO_CHARACTER.put(COSName.getPDFName("i"), "i");
        NAME_TO_CHARACTER.put(COSName.getPDFName("iacute"), "\u00ed");
        NAME_TO_CHARACTER.put(COSName.getPDFName("icircumflex"), "\u00ee");
        NAME_TO_CHARACTER.put(COSName.getPDFName("idieresis"), "\u00ef");
        NAME_TO_CHARACTER.put(COSName.getPDFName("igrave"), "\u00ec");
        NAME_TO_CHARACTER.put(COSName.getPDFName("j"), "j");
        NAME_TO_CHARACTER.put(COSName.getPDFName("k"), "k");
        NAME_TO_CHARACTER.put(COSName.getPDFName("l"), "l");
        NAME_TO_CHARACTER.put(COSName.getPDFName("less"), "<");
        NAME_TO_CHARACTER.put(COSName.getPDFName("lessequal"), "<=<");
        NAME_TO_CHARACTER.put(COSName.getPDFName("logicalnot"), "\u00ac");
        NAME_TO_CHARACTER.put(COSName.getPDFName("lslash"), "l");
        NAME_TO_CHARACTER.put(COSName.getPDFName("m"), "m");
        NAME_TO_CHARACTER.put(COSName.getPDFName("macron"), "\u00af");
        NAME_TO_CHARACTER.put(COSName.getPDFName("minus"), "-");
        NAME_TO_CHARACTER.put(COSName.getPDFName("mu"), "\u00b5");
        NAME_TO_CHARACTER.put(COSName.getPDFName("multiply"), "\u00d7");
        NAME_TO_CHARACTER.put(COSName.getPDFName("n"), "n");
        NAME_TO_CHARACTER.put(COSName.getPDFName("nine"), "9");
        NAME_TO_CHARACTER.put(COSName.getPDFName("ntilde"), "\u00f1");
        NAME_TO_CHARACTER.put(COSName.getPDFName("numbersign"), "#");
        NAME_TO_CHARACTER.put(COSName.getPDFName("o"), "o");
        NAME_TO_CHARACTER.put(COSName.getPDFName("oacute"), "\u00f3");
        NAME_TO_CHARACTER.put(COSName.getPDFName("ocircumflex"), "\u00f4");
        NAME_TO_CHARACTER.put(COSName.getPDFName("odieresis"), "\u00f6");
        NAME_TO_CHARACTER.put(COSName.getPDFName("oe"), "\u009c");
        NAME_TO_CHARACTER.put(COSName.getPDFName("ogonek"), "\u00ce");
        NAME_TO_CHARACTER.put(COSName.getPDFName("ograve"), "\u00f2");
        NAME_TO_CHARACTER.put(COSName.getPDFName("one"), "1");
        NAME_TO_CHARACTER.put(COSName.getPDFName("onehalf"), "\u00bd");
        NAME_TO_CHARACTER.put(COSName.getPDFName("onequarter"), "\u00bc");
        NAME_TO_CHARACTER.put(COSName.getPDFName("onesuperior"), "\u00b9");
        NAME_TO_CHARACTER.put(COSName.getPDFName("ordfeminine"), "\u00aa");
        NAME_TO_CHARACTER.put(COSName.getPDFName("ordmasculine"), "\u00ba");
        NAME_TO_CHARACTER.put(COSName.getPDFName("oslash"), "\u00f8");
        NAME_TO_CHARACTER.put(COSName.getPDFName("otilde"), "\u00f5");
        NAME_TO_CHARACTER.put(COSName.getPDFName("p"), "p");
        NAME_TO_CHARACTER.put(COSName.getPDFName("paragraph"), "\u00b6");
        NAME_TO_CHARACTER.put(COSName.getPDFName("parenleft"), "(");
        NAME_TO_CHARACTER.put(COSName.getPDFName("parenright"), ")");
        NAME_TO_CHARACTER.put(COSName.getPDFName("percent"), "%");
        NAME_TO_CHARACTER.put(COSName.getPDFName("period"), ".");
        NAME_TO_CHARACTER.put(COSName.getPDFName("periodcentered"), "\u00b7");
        NAME_TO_CHARACTER.put(COSName.getPDFName("perthousand"), "\u0089");
        NAME_TO_CHARACTER.put(COSName.getPDFName("plus"), "+");
        NAME_TO_CHARACTER.put(COSName.getPDFName("plusminus"), "\u00b1");
        NAME_TO_CHARACTER.put(COSName.getPDFName("q"), "q");
        NAME_TO_CHARACTER.put(COSName.getPDFName("question"), "?");
        NAME_TO_CHARACTER.put(COSName.getPDFName("questiondown"), "\u00bf");
        NAME_TO_CHARACTER.put(COSName.getPDFName("quotedbl"), "\"");
        NAME_TO_CHARACTER.put(COSName.getPDFName("quotedblbase"), "\u0084");
        NAME_TO_CHARACTER.put(COSName.getPDFName("quotedblleft"), "\u0093");
        NAME_TO_CHARACTER.put(COSName.getPDFName("quotedblright"), "\u0094");
        NAME_TO_CHARACTER.put(COSName.getPDFName("quoteleft"), "\u0091");
        NAME_TO_CHARACTER.put(COSName.getPDFName("quoteright"), "\u0092");
        NAME_TO_CHARACTER.put(COSName.getPDFName("quotesinglbase"), "\u0082");
        NAME_TO_CHARACTER.put(COSName.getPDFName("quotesingle"), "'");
        NAME_TO_CHARACTER.put(COSName.getPDFName("r"), "r");
        NAME_TO_CHARACTER.put(COSName.getPDFName("registered"), "\u00ae");
        NAME_TO_CHARACTER.put(COSName.getPDFName("registersans"), "\u00ae");
        NAME_TO_CHARACTER.put(COSName.getPDFName("registerserif"), "\u00ae");
        NAME_TO_CHARACTER.put(COSName.getPDFName("ring"), "\u00ca");
        NAME_TO_CHARACTER.put(COSName.getPDFName("s"), "s");
        NAME_TO_CHARACTER.put(COSName.getPDFName("scaron"), "\u009a");
        NAME_TO_CHARACTER.put(COSName.getPDFName("section"), "\u00a7");
        NAME_TO_CHARACTER.put(COSName.getPDFName("semicolon"), ";");
        NAME_TO_CHARACTER.put(COSName.getPDFName("seven"), "7");
        NAME_TO_CHARACTER.put(COSName.getPDFName("six"), "6");
        NAME_TO_CHARACTER.put(COSName.getPDFName("slash"), "/");
        NAME_TO_CHARACTER.put(COSName.getPDFName("space"), " ");
        NAME_TO_CHARACTER.put(COSName.getPDFName("sterling"), "\u00a3");
        NAME_TO_CHARACTER.put(COSName.getPDFName("t"), "t");
        NAME_TO_CHARACTER.put(COSName.getPDFName("thorn"), "\u00fe");
        NAME_TO_CHARACTER.put(COSName.getPDFName("three"), "3");
        NAME_TO_CHARACTER.put(COSName.getPDFName("threequarters"), "\u00be");
        NAME_TO_CHARACTER.put(COSName.getPDFName("threesuperior"), "\u00b3");
        NAME_TO_CHARACTER.put(COSName.getPDFName("tilde"), "\u0098");
        NAME_TO_CHARACTER.put(COSName.getPDFName("trademark"), "\u0099");
        NAME_TO_CHARACTER.put(COSName.getPDFName("trademarksans"), "\u0099");
        NAME_TO_CHARACTER.put(COSName.getPDFName("trademarkserif"), "\u0099");
        NAME_TO_CHARACTER.put(COSName.getPDFName("two"), "2");
        NAME_TO_CHARACTER.put(COSName.getPDFName("twosuperior"), "\u00b2");
        NAME_TO_CHARACTER.put(COSName.getPDFName("u"), "u");
        NAME_TO_CHARACTER.put(COSName.getPDFName("uacute"), "\u00fa");
        NAME_TO_CHARACTER.put(COSName.getPDFName("ucircumflex"), "\u00fb");
        NAME_TO_CHARACTER.put(COSName.getPDFName("udieresis"), "\u00fc");
        NAME_TO_CHARACTER.put(COSName.getPDFName("ugrave"), "\u00f9");
        NAME_TO_CHARACTER.put(COSName.getPDFName("underscore"), "_");
        NAME_TO_CHARACTER.put(COSName.getPDFName("v"), "v");
        NAME_TO_CHARACTER.put(COSName.getPDFName("w"), "w");
        NAME_TO_CHARACTER.put(COSName.getPDFName("x"), "x");
        NAME_TO_CHARACTER.put(COSName.getPDFName("y"), "y");
        NAME_TO_CHARACTER.put(COSName.getPDFName("yacute"), "\u00fd");
        NAME_TO_CHARACTER.put(COSName.getPDFName("ydieresis"), "\u00ff");
        NAME_TO_CHARACTER.put(COSName.getPDFName("yen"), "\u00a5");
        NAME_TO_CHARACTER.put(COSName.getPDFName("z"), "z");
        NAME_TO_CHARACTER.put(COSName.getPDFName("zcaron"), "\u009e");
        NAME_TO_CHARACTER.put(COSName.getPDFName("zero"), "0");
        Iterator keys = NAME_TO_CHARACTER.keySet().iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            Object value = NAME_TO_CHARACTER.get(key);
            CHARACTER_TO_NAME.put(value, key);
        }
    }
}

