/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPSchema;
import com.novell.ldap.LDAPSchemaElement;
import com.novell.ldap.client.SchemaParser;
import java.io.IOException;

public class LDAPMatchingRuleSchema
extends LDAPSchemaElement {
    private String syntaxString;
    private String[] attributes;

    public LDAPMatchingRuleSchema(String[] stringArray, String string, String string2, String[] stringArray2, boolean bl, String string3) {
        super(LDAPSchema.schemaTypeNames[6]);
        this.names = (String[])stringArray.clone();
        this.oid = string;
        this.description = string2;
        this.obsolete = bl;
        this.attributes = (String[])stringArray2.clone();
        this.syntaxString = string3;
        super.setValue(this.formatString());
    }

    public LDAPMatchingRuleSchema(String string, String string2) {
        super(LDAPSchema.schemaTypeNames[6]);
        try {
            SchemaParser schemaParser = new SchemaParser(string);
            this.names = (String[])schemaParser.getNames().clone();
            this.oid = schemaParser.getID();
            this.description = schemaParser.getDescription();
            this.obsolete = schemaParser.getObsolete();
            this.syntaxString = schemaParser.getSyntax();
            if (string2 != null) {
                SchemaParser schemaParser2 = new SchemaParser(string2);
                this.attributes = schemaParser2.getApplies();
            }
            super.setValue(this.formatString());
        }
        catch (IOException iOException) {}
    }

    public String[] getAttributes() {
        return this.attributes;
    }

    public String getSyntaxString() {
        return this.syntaxString;
    }

    protected String formatString() {
        String[] stringArray;
        StringBuffer stringBuffer = new StringBuffer("( ");
        String string = this.getID();
        if (string != null) {
            stringBuffer.append(string);
        }
        if ((stringArray = this.getNames()) != null) {
            stringBuffer.append(" NAME ");
            if (stringArray.length == 1) {
                stringBuffer.append("'" + stringArray[0] + "'");
            } else {
                stringBuffer.append("( ");
                int n = 0;
                while (n < stringArray.length) {
                    stringBuffer.append(" '" + stringArray[n] + "'");
                    ++n;
                }
                stringBuffer.append(" )");
            }
        }
        if ((string = this.getDescription()) != null) {
            stringBuffer.append(" DESC ");
            stringBuffer.append("'" + string + "'");
        }
        if (this.isObsolete()) {
            stringBuffer.append(" OBSOLETE");
        }
        if ((string = this.getSyntaxString()) != null) {
            stringBuffer.append(" SYNTAX ");
            stringBuffer.append(string);
        }
        stringBuffer.append(" )");
        return stringBuffer.toString();
    }
}

