/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPControl;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.LDAPModification;
import com.novell.ldap.asn1.ASN1Enumerated;
import com.novell.ldap.asn1.ASN1Object;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.ASN1SequenceOf;
import com.novell.ldap.asn1.ASN1SetOf;
import com.novell.ldap.asn1.ASN1Structured;
import com.novell.ldap.rfc2251.RfcAttributeDescription;
import com.novell.ldap.rfc2251.RfcAttributeTypeAndValues;
import com.novell.ldap.rfc2251.RfcAttributeValue;
import com.novell.ldap.rfc2251.RfcLDAPDN;
import com.novell.ldap.rfc2251.RfcModifyRequest;

public class LDAPModifyRequest
extends LDAPMessage {
    public LDAPModifyRequest(String string, LDAPModification[] lDAPModificationArray, LDAPControl[] lDAPControlArray) throws LDAPException {
        super(6, new RfcModifyRequest(new RfcLDAPDN(string), LDAPModifyRequest.encodeModifications(lDAPModificationArray)), lDAPControlArray);
    }

    private static final ASN1SequenceOf encodeModifications(LDAPModification[] lDAPModificationArray) {
        ASN1SequenceOf aSN1SequenceOf = new ASN1SequenceOf(lDAPModificationArray.length);
        int n = 0;
        while (n < lDAPModificationArray.length) {
            Object object;
            LDAPAttribute lDAPAttribute = lDAPModificationArray[n].getAttribute();
            ASN1SetOf aSN1SetOf = new ASN1SetOf(lDAPAttribute.size());
            if (lDAPAttribute.size() > 0) {
                object = lDAPAttribute.getByteValues();
                while (object.hasMoreElements()) {
                    aSN1SetOf.add(new RfcAttributeValue((byte[])object.nextElement()));
                }
            }
            object = new ASN1Sequence(2);
            ((ASN1Structured)object).add(new ASN1Enumerated(lDAPModificationArray[n].getOp()));
            ((ASN1Structured)object).add(new RfcAttributeTypeAndValues(new RfcAttributeDescription(lDAPAttribute.getName()), aSN1SetOf));
            aSN1SequenceOf.add((ASN1Object)object);
            ++n;
        }
        return aSN1SequenceOf;
    }

    public String getDN() {
        return this.getASN1Object().getRequestDN();
    }

    public LDAPModification[] getModifications() {
        RfcModifyRequest rfcModifyRequest = (RfcModifyRequest)this.getASN1Object().getRequest();
        ASN1SequenceOf aSN1SequenceOf = rfcModifyRequest.getModifications();
        ASN1Object[] aSN1ObjectArray = aSN1SequenceOf.toArray();
        LDAPModification[] lDAPModificationArray = new LDAPModification[aSN1ObjectArray.length];
        int n = 0;
        while (n < aSN1ObjectArray.length) {
            ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1ObjectArray[n];
            if (aSN1Sequence.size() != 2) {
                throw new RuntimeException("LDAPModifyRequest: modification " + n + " is wrong size: " + aSN1Sequence.size());
            }
            ASN1Object[] aSN1ObjectArray2 = aSN1Sequence.toArray();
            ASN1Enumerated aSN1Enumerated = (ASN1Enumerated)aSN1ObjectArray2[0];
            int n2 = aSN1Enumerated.intValue();
            ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1ObjectArray2[1];
            ASN1Object[] aSN1ObjectArray3 = aSN1Sequence2.toArray();
            RfcAttributeDescription rfcAttributeDescription = (RfcAttributeDescription)aSN1ObjectArray3[0];
            String string = rfcAttributeDescription.stringValue();
            ASN1SetOf aSN1SetOf = (ASN1SetOf)aSN1ObjectArray3[1];
            ASN1Object[] aSN1ObjectArray4 = aSN1SetOf.toArray();
            LDAPAttribute lDAPAttribute = new LDAPAttribute(string);
            int n3 = 0;
            while (n3 < aSN1ObjectArray4.length) {
                RfcAttributeValue rfcAttributeValue = (RfcAttributeValue)aSN1ObjectArray4[n3];
                lDAPAttribute.addValue(rfcAttributeValue.byteValue());
                ++n3;
            }
            lDAPModificationArray[n] = new LDAPModification(n2, lDAPAttribute);
            ++n;
        }
        return lDAPModificationArray;
    }

    public String toString() {
        return this.getASN1Object().toString();
    }
}

