/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.rfc2251;

import com.novell.ldap.asn1.ASN1Boolean;
import com.novell.ldap.asn1.ASN1Decoder;
import com.novell.ldap.asn1.ASN1Object;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.rfc2251.RfcLDAPOID;
import java.io.IOException;
import java.io.InputStream;

public class RfcControl
extends ASN1Sequence {
    public RfcControl(RfcLDAPOID rfcLDAPOID) {
        this(rfcLDAPOID, new ASN1Boolean(false), null);
    }

    public RfcControl(RfcLDAPOID rfcLDAPOID, ASN1Boolean aSN1Boolean) {
        this(rfcLDAPOID, aSN1Boolean, null);
    }

    public RfcControl(RfcLDAPOID rfcLDAPOID, ASN1Boolean aSN1Boolean, ASN1OctetString aSN1OctetString) {
        super(3);
        this.add(rfcLDAPOID);
        if (aSN1Boolean.booleanValue()) {
            this.add(aSN1Boolean);
        }
        if (aSN1OctetString != null) {
            this.add(aSN1OctetString);
        }
    }

    public RfcControl(ASN1Decoder aSN1Decoder, InputStream inputStream, int n) throws IOException {
        super(aSN1Decoder, inputStream, n);
    }

    public RfcControl(ASN1Sequence aSN1Sequence) throws IOException {
        super(3);
        int n = aSN1Sequence.size();
        int n2 = 0;
        while (n2 < n) {
            this.add(aSN1Sequence.get(n2));
            ++n2;
        }
    }

    public final ASN1OctetString getControlType() {
        return (ASN1OctetString)this.get(0);
    }

    public final ASN1Boolean getCriticality() {
        ASN1Object aSN1Object;
        if (this.size() > 1 && (aSN1Object = this.get(1)) instanceof ASN1Boolean) {
            return (ASN1Boolean)aSN1Object;
        }
        return new ASN1Boolean(false);
    }

    public final ASN1OctetString getControlValue() {
        ASN1Object aSN1Object;
        if (this.size() > 2) {
            return (ASN1OctetString)this.get(2);
        }
        if (this.size() > 1 && (aSN1Object = this.get(1)) instanceof ASN1OctetString) {
            return (ASN1OctetString)aSN1Object;
        }
        return null;
    }

    public final void setControlValue(ASN1OctetString aSN1OctetString) {
        if (aSN1OctetString == null) {
            return;
        }
        if (this.size() == 3) {
            this.set(2, aSN1OctetString);
            return;
        }
        if (this.size() == 2) {
            ASN1Object aSN1Object = this.get(1);
            if (aSN1Object instanceof ASN1OctetString) {
                this.set(1, aSN1OctetString);
                return;
            }
            this.add(aSN1OctetString);
            return;
        }
    }
}

