/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.rfc2251;

import com.novell.ldap.asn1.ASN1Decoder;
import com.novell.ldap.asn1.ASN1Enumerated;
import com.novell.ldap.asn1.ASN1Identifier;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.ASN1Tagged;
import com.novell.ldap.rfc2251.RfcLDAPDN;
import com.novell.ldap.rfc2251.RfcLDAPOID;
import com.novell.ldap.rfc2251.RfcLDAPString;
import com.novell.ldap.rfc2251.RfcReferral;
import com.novell.ldap.rfc2251.RfcResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class RfcExtendedResponse
extends ASN1Sequence
implements RfcResponse {
    public static final int RESPONSE_NAME = 10;
    public static final int RESPONSE = 11;
    private int referralIndex;
    private int responseNameIndex;
    private int responseIndex;

    public RfcExtendedResponse(ASN1Enumerated aSN1Enumerated, RfcLDAPDN rfcLDAPDN, RfcLDAPString rfcLDAPString, RfcReferral rfcReferral, RfcLDAPOID rfcLDAPOID, ASN1OctetString aSN1OctetString) {
        super(6);
        this.add(aSN1Enumerated);
        this.add(rfcLDAPDN);
        this.add(rfcLDAPString);
        int n = 3;
        if (rfcReferral != null) {
            this.add(rfcReferral);
            this.referralIndex = n++;
        }
        if (rfcLDAPOID != null) {
            this.responseNameIndex = n++;
            this.add(rfcLDAPOID);
        }
        if (aSN1OctetString != null) {
            this.add(aSN1OctetString);
            this.responseIndex = n++;
        }
    }

    public RfcExtendedResponse(ASN1Decoder aSN1Decoder, InputStream inputStream, int n) throws IOException {
        super(aSN1Decoder, inputStream, n);
        if (this.size() > 3) {
            int n2 = 3;
            while (n2 < this.size()) {
                ASN1Tagged aSN1Tagged = (ASN1Tagged)this.get(n2);
                ASN1Identifier aSN1Identifier = aSN1Tagged.getIdentifier();
                switch (aSN1Identifier.getTag()) {
                    case 3: {
                        byte[] byArray = ((ASN1OctetString)aSN1Tagged.taggedValue()).byteValue();
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                        this.set(n2, new RfcReferral(aSN1Decoder, byteArrayInputStream, byArray.length));
                        this.referralIndex = n2;
                        break;
                    }
                    case 10: {
                        this.set(n2, new RfcLDAPOID(((ASN1OctetString)aSN1Tagged.taggedValue()).byteValue()));
                        this.responseNameIndex = n2;
                        break;
                    }
                    case 11: {
                        this.set(n2, aSN1Tagged.taggedValue());
                        this.responseIndex = n2;
                    }
                }
                ++n2;
            }
        }
    }

    public final ASN1Enumerated getResultCode() {
        return (ASN1Enumerated)this.get(0);
    }

    public final RfcLDAPDN getMatchedDN() {
        return new RfcLDAPDN(((ASN1OctetString)this.get(1)).byteValue());
    }

    public final RfcLDAPString getErrorMessage() {
        return new RfcLDAPString(((ASN1OctetString)this.get(2)).byteValue());
    }

    public final RfcReferral getReferral() {
        return this.referralIndex != 0 ? (RfcReferral)this.get(this.referralIndex) : null;
    }

    public final RfcLDAPOID getResponseName() {
        return this.responseNameIndex != 0 ? (RfcLDAPOID)this.get(this.responseNameIndex) : null;
    }

    public final ASN1OctetString getResponse() {
        return this.responseIndex != 0 ? (ASN1OctetString)this.get(this.responseIndex) : null;
    }

    public final ASN1Identifier getIdentifier() {
        return new ASN1Identifier(1, true, 24);
    }
}

