/*
 * Decompiled with CFR 0.152.
 */
package org.ietf.ldap;

import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Map;
import org.ietf.ldap.LDAPAttribute;
import org.ietf.ldap.LDAPConnection;
import org.ietf.ldap.LDAPConstraints;
import org.ietf.ldap.LDAPControl;
import org.ietf.ldap.LDAPEntry;
import org.ietf.ldap.LDAPException;
import org.ietf.ldap.LDAPExtendedOperation;
import org.ietf.ldap.LDAPExtendedResponse;
import org.ietf.ldap.LDAPMessageQueue;
import org.ietf.ldap.LDAPModification;
import org.ietf.ldap.LDAPReferralException;
import org.ietf.ldap.LDAPResponseQueue;
import org.ietf.ldap.LDAPSchema;
import org.ietf.ldap.LDAPSearchConstraints;
import org.ietf.ldap.LDAPSearchQueue;
import org.ietf.ldap.LDAPSearchResults;
import org.ietf.ldap.LDAPSocketFactory;
import org.ietf.ldap.LDAPUnsolicitedNotificationListener;
import org.ietf.ldap.LDAPUrl;

public class LDAPConnection
implements Cloneable {
    private com.novell.ldap.LDAPConnection conn;
    private Hashtable listenerQueues = new Hashtable();
    public static final int SCOPE_BASE = 0;
    public static final int SCOPE_ONE = 1;
    public static final int SCOPE_SUB = 2;
    public static final String NO_ATTRS = "1.1";
    public static final String ALL_USER_ATTRS = "*";
    public static final int DEFAULT_PORT = 389;
    public static final String LDAP_PROPERTY_SDK = "version.sdk";
    public static final String LDAP_PROPERTY_PROTOCOL = "version.protocol";
    public static final String LDAP_PROPERTY_SECURITY = "version.security";

    public LDAPConnection() {
        this.conn = new com.novell.ldap.LDAPConnection();
    }

    LDAPConnection(com.novell.ldap.LDAPConnection lDAPConnection) {
        this.conn = lDAPConnection;
    }

    com.novell.ldap.LDAPConnection getWrappedObject() {
        return this.conn;
    }

    private static com.novell.ldap.LDAPSocketFactory getSocketImpl(LDAPSocketFactory lDAPSocketFactory) {
        if (lDAPSocketFactory == null) {
            return null;
        }
        class SocketFactoryImpl
        implements SocketFactoryWrapper {
            private LDAPSocketFactory factory;

            SocketFactoryImpl(LDAPSocketFactory lDAPSocketFactory) {
                this.factory = lDAPSocketFactory;
            }

            public LDAPSocketFactory getWrappedObject() {
                return this.factory;
            }

            public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
                return this.factory.createSocket(string, n);
            }
        }
        return new SocketFactoryImpl(lDAPSocketFactory);
    }

    public LDAPConnection(LDAPSocketFactory lDAPSocketFactory) {
        this.conn = lDAPSocketFactory != null && lDAPSocketFactory instanceof com.novell.ldap.LDAPSocketFactory ? new com.novell.ldap.LDAPConnection((com.novell.ldap.LDAPSocketFactory)((Object)lDAPSocketFactory)) : new com.novell.ldap.LDAPConnection(LDAPConnection.getSocketImpl(lDAPSocketFactory));
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            Object object = super.clone();
            ((LDAPConnection)object).conn = (com.novell.ldap.LDAPConnection)this.conn.clone();
            return object;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Internal error, cannot create clone");
        }
    }

    protected void finalize() throws LDAPException {
        try {
            this.conn.disconnect();
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            throw new LDAPException(lDAPException);
        }
    }

    public int getProtocolVersion() {
        return this.conn.getProtocolVersion();
    }

    public String getAuthenticationDN() {
        return this.conn.getAuthenticationDN();
    }

    public String getAuthenticationMethod() {
        return this.conn.getAuthenticationMethod();
    }

    public Map getSaslBindProperties() {
        return this.conn.getSaslBindProperties();
    }

    public Object getSaslBindCallbackHandler() {
        return this.conn.getSaslBindCallbackHandler();
    }

    public LDAPConstraints getConstraints() {
        return new LDAPSearchConstraints(this.conn.getSearchConstraints());
    }

    public String getHost() {
        return this.conn.getHost();
    }

    public int getPort() {
        return this.conn.getPort();
    }

    public Object getProperty(String string) {
        return this.conn.getProperty(string);
    }

    public LDAPSearchConstraints getSearchConstraints() {
        return new LDAPSearchConstraints(this.conn.getSearchConstraints());
    }

    public LDAPSocketFactory getSocketFactory() {
        com.novell.ldap.LDAPSocketFactory lDAPSocketFactory = this.conn.getSocketFactory();
        if (lDAPSocketFactory == null) {
            return null;
        }
        if (lDAPSocketFactory instanceof LDAPSocketFactory) {
            return (LDAPSocketFactory)((Object)lDAPSocketFactory);
        }
        return ((SocketFactoryWrapper)lDAPSocketFactory).getWrappedObject();
    }

    public boolean isBound() {
        return this.conn.isBound();
    }

    public boolean isConnected() {
        return this.conn.isConnected();
    }

    public boolean isTLS() {
        return this.conn.isTLS();
    }

    public void setConstraints(LDAPConstraints lDAPConstraints) {
        this.conn.setConstraints(lDAPConstraints.getWrappedObject());
    }

    public static void setSocketFactory(LDAPSocketFactory lDAPSocketFactory) {
        if (lDAPSocketFactory != null && lDAPSocketFactory instanceof com.novell.ldap.LDAPSocketFactory) {
            com.novell.ldap.LDAPConnection.setSocketFactory((com.novell.ldap.LDAPSocketFactory)((Object)lDAPSocketFactory));
        } else {
            com.novell.ldap.LDAPConnection.setSocketFactory(LDAPConnection.getSocketImpl(lDAPSocketFactory));
        }
    }

    public void addUnsolicitedNotificationListener(LDAPUnsolicitedNotificationListener lDAPUnsolicitedNotificationListener) {
        if (lDAPUnsolicitedNotificationListener != null) {
            this.conn.addUnsolicitedNotificationListener(new UnsolImpl(lDAPUnsolicitedNotificationListener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUnsolicitedNotificationListener(LDAPUnsolicitedNotificationListener lDAPUnsolicitedNotificationListener) {
        com.novell.ldap.LDAPUnsolicitedNotificationListener lDAPUnsolicitedNotificationListener2 = null;
        if (lDAPUnsolicitedNotificationListener != null) {
            Hashtable hashtable = this.listenerQueues;
            synchronized (hashtable) {
                lDAPUnsolicitedNotificationListener2 = (com.novell.ldap.LDAPUnsolicitedNotificationListener)this.listenerQueues.remove(lDAPUnsolicitedNotificationListener);
            }
            if (lDAPUnsolicitedNotificationListener2 != null) {
                this.conn.removeUnsolicitedNotificationListener(lDAPUnsolicitedNotificationListener2);
            }
        }
        if (lDAPUnsolicitedNotificationListener2 == null) {
            throw new IllegalArgumentException("removeUnsolicitedNotificationListener: Invalid Parameter");
        }
    }

    public void startTLS() throws LDAPException {
        try {
            this.conn.startTLS();
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            throw new LDAPException(lDAPException);
        }
    }

    public void stopTLS() throws LDAPException {
        try {
            this.conn.stopTLS();
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            throw new LDAPException(lDAPException);
        }
    }

    public void abandon(LDAPSearchResults lDAPSearchResults) throws LDAPException {
        try {
            if (lDAPSearchResults == null) {
                this.conn.abandon((com.novell.ldap.LDAPSearchResults)null);
            } else {
                this.conn.abandon(lDAPSearchResults.getWrappedObject());
            }
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            throw new LDAPException(lDAPException);
        }
    }

    public void abandon(LDAPSearchResults lDAPSearchResults, LDAPConstraints lDAPConstraints) throws LDAPException {
        try {
            if (lDAPSearchResults == null) {
                this.conn.abandon((com.novell.ldap.LDAPSearchResults)null, lDAPConstraints.getWrappedObject());
            } else {
                this.conn.abandon(lDAPSearchResults.getWrappedObject(), lDAPConstraints.getWrappedObject());
            }
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            throw new LDAPException(lDAPException);
        }
    }

    public void abandon(int n) throws LDAPException {
        try {
            this.conn.abandon(n);
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            throw new LDAPException(lDAPException);
        }
    }

    public void abandon(int n, LDAPConstraints lDAPConstraints) throws LDAPException {
        try {
            this.conn.abandon(n, lDAPConstraints.getWrappedObject());
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            throw new LDAPException(lDAPException);
        }
    }

    public void abandon(LDAPMessageQueue lDAPMessageQueue) throws LDAPException {
        try {
            if (lDAPMessageQueue instanceof LDAPResponseQueue) {
                this.conn.abandon(((LDAPResponseQueue)lDAPMessageQueue).getWrappedObject());
            } else if (lDAPMessageQueue instanceof LDAPSearchQueue) {
                this.conn.abandon(((LDAPSearchQueue)lDAPMessageQueue).getWrappedObject());
            }
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            throw new LDAPException(lDAPException);
        }
    }

    public void abandon(LDAPMessageQueue lDAPMessageQueue, LDAPConstraints lDAPConstraints) throws LDAPException {
        try {
            if (lDAPMessageQueue instanceof LDAPResponseQueue) {
                this.conn.abandon(((LDAPResponseQueue)lDAPMessageQueue).getWrappedObject(), lDAPConstraints.getWrappedObject());
            } else if (lDAPMessageQueue instanceof LDAPSearchQueue) {
                this.conn.abandon(((LDAPSearchQueue)lDAPMessageQueue).getWrappedObject(), lDAPConstraints.getWrappedObject());
            }
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            throw new LDAPException(lDAPException);
        }
    }

    public void add(LDAPEntry lDAPEntry) throws LDAPException {
        try {
            this.conn.add(lDAPEntry.getWrappedObject());
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            if (lDAPException instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)lDAPException);
            }
            throw new LDAPException(lDAPException);
        }
    }

    public void add(LDAPEntry lDAPEntry, LDAPConstraints lDAPConstraints) throws LDAPException {
        try {
            this.conn.add(lDAPEntry.getWrappedObject(), lDAPConstraints.getWrappedObject());
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            if (lDAPException instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)lDAPException);
            }
            throw new LDAPException(lDAPException);
        }
    }

    public LDAPResponseQueue add(LDAPEntry lDAPEntry, LDAPResponseQueue lDAPResponseQueue) throws LDAPException {
        try {
            return new LDAPResponseQueue(this.conn.add(lDAPEntry.getWrappedObject(), lDAPResponseQueue.getWrappedObject()));
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            if (lDAPException instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)lDAPException);
            }
            throw new LDAPException(lDAPException);
        }
    }

    public LDAPResponseQueue add(LDAPEntry lDAPEntry, LDAPResponseQueue lDAPResponseQueue, LDAPConstraints lDAPConstraints) throws LDAPException {
        try {
            return new LDAPResponseQueue(this.conn.add(lDAPEntry.getWrappedObject(), lDAPResponseQueue.getWrappedObject(), lDAPConstraints.getWrappedObject()));
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            if (lDAPException instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)lDAPException);
            }
            throw new LDAPException(lDAPException);
        }
    }

    public void bind(int n, String string, byte[] byArray) throws LDAPException {
        try {
            this.conn.bind(n, string, byArray);
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            if (lDAPException instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)lDAPException);
            }
            throw new LDAPException(lDAPException);
        }
    }

    public void bind(int n, String string, byte[] byArray, LDAPConstraints lDAPConstraints) throws LDAPException {
        try {
            this.conn.bind(n, string, byArray, lDAPConstraints.getWrappedObject());
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            if (lDAPException instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)lDAPException);
            }
            throw new LDAPException(lDAPException);
        }
    }

    public LDAPResponseQueue bind(int n, String string, byte[] byArray, LDAPResponseQueue lDAPResponseQueue) throws LDAPException {
        try {
            return new LDAPResponseQueue(this.conn.bind(n, string, byArray, lDAPResponseQueue.getWrappedObject()));
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            if (lDAPException instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)lDAPException);
            }
            throw new LDAPException(lDAPException);
        }
    }

    public LDAPResponseQueue bind(int n, String string, byte[] byArray, LDAPResponseQueue lDAPResponseQueue, LDAPConstraints lDAPConstraints) throws LDAPException {
        try {
            return new LDAPResponseQueue(this.conn.bind(n, string, byArray, lDAPResponseQueue.getWrappedObject(), lDAPConstraints.getWrappedObject()));
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            if (lDAPException instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)lDAPException);
            }
            throw new LDAPException(lDAPException);
        }
    }

    public void bind(String string, String string2, Map map, Object object) throws LDAPException {
        try {
            this.conn.bind(string, string2, map, object);
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            if (lDAPException instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)lDAPException);
            }
            throw new LDAPException(lDAPException);
        }
    }

    public void bind(String string, String string2, Map map, Object object, LDAPConstraints lDAPConstraints) throws LDAPException {
        try {
            this.conn.bind(string, string2, map, object, lDAPConstraints.getWrappedObject());
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            if (lDAPException instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)lDAPException);
            }
            throw new LDAPException(lDAPException);
        }
    }

    public void bind(String string, String string2, String[] stringArray, Map map, Object object) throws LDAPException {
        try {
            this.conn.bind(string, string2, stringArray, map, object);
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            if (lDAPException instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)lDAPException);
            }
            throw new LDAPException(lDAPException);
        }
    }

    public void bind(String string, String string2, String[] stringArray, Map map, Object object, LDAPConstraints lDAPConstraints) throws LDAPException {
        try {
            this.conn.bind(string, string2, stringArray, map, object, lDAPConstraints.getWrappedObject());
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            if (lDAPException instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)lDAPException);
            }
            throw new LDAPException(lDAPException);
        }
    }

    public boolean compare(String string, LDAPAttribute lDAPAttribute) throws LDAPException {
        try {
            return this.conn.compare(string, lDAPAttribute.getWrappedObject());
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            if (lDAPException instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)lDAPException);
            }
            throw new LDAPException(lDAPException);
        }
    }

    public boolean compare(String string, LDAPAttribute lDAPAttribute, LDAPConstraints lDAPConstraints) throws LDAPException {
        try {
            return this.conn.compare(string, lDAPAttribute.getWrappedObject(), lDAPConstraints.getWrappedObject());
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            if (lDAPException instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)lDAPException);
            }
            throw new LDAPException(lDAPException);
        }
    }

    public LDAPResponseQueue compare(String string, LDAPAttribute lDAPAttribute, LDAPResponseQueue lDAPResponseQueue) throws LDAPException {
        try {
            return new LDAPResponseQueue(this.conn.compare(string, lDAPAttribute.getWrappedObject(), lDAPResponseQueue.getWrappedObject()));
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            if (lDAPException instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)lDAPException);
            }
            throw new LDAPException(lDAPException);
        }
    }

    public LDAPResponseQueue compare(String string, LDAPAttribute lDAPAttribute, LDAPResponseQueue lDAPResponseQueue, LDAPConstraints lDAPConstraints) throws LDAPException {
        try {
            return new LDAPResponseQueue(this.conn.compare(string, lDAPAttribute.getWrappedObject(), lDAPResponseQueue.getWrappedObject(), lDAPConstraints.getWrappedObject()));
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            if (lDAPException instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)lDAPException);
            }
            throw new LDAPException(lDAPException);
        }
    }

    public void connect(String string, int n) throws LDAPException {
        try {
            this.conn.connect(string, n);
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            throw new LDAPException(lDAPException);
        }
    }

    public void delete(String string) throws LDAPException {
        try {
            this.conn.delete(string);
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            if (lDAPException instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)lDAPException);
            }
            throw new LDAPException(lDAPException);
        }
    }

    public void delete(String string, LDAPConstraints lDAPConstraints) throws LDAPException {
        try {
            this.conn.delete(string, lDAPConstraints.getWrappedObject());
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            if (lDAPException instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)lDAPException);
            }
            throw new LDAPException(lDAPException);
        }
    }

    public LDAPResponseQueue delete(String string, LDAPResponseQueue lDAPResponseQueue) throws LDAPException {
        try {
            return new LDAPResponseQueue(this.conn.delete(string, lDAPResponseQueue.getWrappedObject()));
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            if (lDAPException instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)lDAPException);
            }
            throw new LDAPException(lDAPException);
        }
    }

    public LDAPResponseQueue delete(String string, LDAPResponseQueue lDAPResponseQueue, LDAPConstraints lDAPConstraints) throws LDAPException {
        try {
            return new LDAPResponseQueue(this.conn.delete(string, lDAPResponseQueue.getWrappedObject(), lDAPConstraints.getWrappedObject()));
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            if (lDAPException instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)lDAPException);
            }
            throw new LDAPException(lDAPException);
        }
    }

    public void disconnect() throws LDAPException {
        try {
            this.conn.disconnect();
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            throw new LDAPException(lDAPException);
        }
    }

    public void disconnect(LDAPConstraints lDAPConstraints) throws LDAPException {
        try {
            this.conn.disconnect(lDAPConstraints.getWrappedObject());
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            throw new LDAPException(lDAPException);
        }
    }

    public LDAPExtendedResponse extendedOperation(LDAPExtendedOperation lDAPExtendedOperation) throws LDAPException {
        try {
            return new LDAPExtendedResponse(this.conn.extendedOperation(lDAPExtendedOperation.getWrappedObject()));
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            if (lDAPException instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)lDAPException);
            }
            throw new LDAPException(lDAPException);
        }
    }

    public LDAPExtendedResponse extendedOperation(LDAPExtendedOperation lDAPExtendedOperation, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        try {
            return new LDAPExtendedResponse(this.conn.extendedOperation(lDAPExtendedOperation.getWrappedObject(), lDAPSearchConstraints.getWrappedSearchObject()));
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            if (lDAPException instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)lDAPException);
            }
            throw new LDAPException(lDAPException);
        }
    }

    public LDAPResponseQueue extendedOperation(LDAPExtendedOperation lDAPExtendedOperation, LDAPResponseQueue lDAPResponseQueue) throws LDAPException {
        try {
            return new LDAPResponseQueue(this.conn.extendedOperation(lDAPExtendedOperation.getWrappedObject(), lDAPResponseQueue.getWrappedObject()));
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            if (lDAPException instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)lDAPException);
            }
            throw new LDAPException(lDAPException);
        }
    }

    public LDAPResponseQueue extendedOperation(LDAPExtendedOperation lDAPExtendedOperation, LDAPSearchConstraints lDAPSearchConstraints, LDAPResponseQueue lDAPResponseQueue) throws LDAPException {
        try {
            return new LDAPResponseQueue(this.conn.extendedOperation(lDAPExtendedOperation.getWrappedObject(), lDAPSearchConstraints.getWrappedSearchObject(), lDAPResponseQueue.getWrappedObject()));
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            if (lDAPException instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)lDAPException);
            }
            throw new LDAPException(lDAPException);
        }
    }

    public LDAPControl[] getResponseControls() {
        com.novell.ldap.LDAPControl[] lDAPControlArray = this.conn.getResponseControls();
        if (lDAPControlArray == null) {
            return null;
        }
        LDAPControl[] lDAPControlArray2 = new LDAPControl[lDAPControlArray.length];
        int n = 0;
        while (n < lDAPControlArray.length) {
            lDAPControlArray2[n] = new LDAPControl(lDAPControlArray[n]);
            ++n;
        }
        return lDAPControlArray2;
    }

    public void modify(String string, LDAPModification lDAPModification) throws LDAPException {
        try {
            this.conn.modify(string, lDAPModification.getWrappedObject());
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            if (lDAPException instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)lDAPException);
            }
            throw new LDAPException(lDAPException);
        }
    }

    public void modify(String string, LDAPModification lDAPModification, LDAPConstraints lDAPConstraints) throws LDAPException {
        try {
            this.conn.modify(string, lDAPModification.getWrappedObject(), lDAPConstraints.getWrappedObject());
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            if (lDAPException instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)lDAPException);
            }
            throw new LDAPException(lDAPException);
        }
    }

    public void modify(String string, LDAPModification[] lDAPModificationArray) throws LDAPException {
        try {
            com.novell.ldap.LDAPModification[] lDAPModificationArray2 = new com.novell.ldap.LDAPModification[lDAPModificationArray.length];
            int n = 0;
            while (n < lDAPModificationArray.length) {
                lDAPModificationArray2[n] = lDAPModificationArray[n].getWrappedObject();
                ++n;
            }
            this.conn.modify(string, lDAPModificationArray2);
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            if (lDAPException instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)lDAPException);
            }
            throw new LDAPException(lDAPException);
        }
    }

    public void modify(String string, LDAPModification[] lDAPModificationArray, LDAPConstraints lDAPConstraints) throws LDAPException {
        try {
            com.novell.ldap.LDAPModification[] lDAPModificationArray2 = new com.novell.ldap.LDAPModification[lDAPModificationArray.length];
            int n = 0;
            while (n < lDAPModificationArray.length) {
                lDAPModificationArray2[n] = lDAPModificationArray[n].getWrappedObject();
                ++n;
            }
            this.conn.modify(string, lDAPModificationArray2, lDAPConstraints.getWrappedObject());
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            if (lDAPException instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)lDAPException);
            }
            throw new LDAPException(lDAPException);
        }
    }

    public LDAPResponseQueue modify(String string, LDAPModification lDAPModification, LDAPResponseQueue lDAPResponseQueue) throws LDAPException {
        try {
            return new LDAPResponseQueue(this.conn.modify(string, lDAPModification.getWrappedObject(), lDAPResponseQueue.getWrappedObject()));
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            if (lDAPException instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)lDAPException);
            }
            throw new LDAPException(lDAPException);
        }
    }

    public LDAPResponseQueue modify(String string, LDAPModification lDAPModification, LDAPResponseQueue lDAPResponseQueue, LDAPConstraints lDAPConstraints) throws LDAPException {
        try {
            return new LDAPResponseQueue(this.conn.modify(string, lDAPModification.getWrappedObject(), lDAPResponseQueue.getWrappedObject(), lDAPConstraints.getWrappedObject()));
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            if (lDAPException instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)lDAPException);
            }
            throw new LDAPException(lDAPException);
        }
    }

    public LDAPResponseQueue modify(String string, LDAPModification[] lDAPModificationArray, LDAPResponseQueue lDAPResponseQueue) throws LDAPException {
        try {
            com.novell.ldap.LDAPModification[] lDAPModificationArray2 = new com.novell.ldap.LDAPModification[lDAPModificationArray.length];
            int n = 0;
            while (n < lDAPModificationArray.length) {
                lDAPModificationArray2[n] = lDAPModificationArray[n].getWrappedObject();
                ++n;
            }
            return new LDAPResponseQueue(this.conn.modify(string, lDAPModificationArray2, lDAPResponseQueue.getWrappedObject()));
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            if (lDAPException instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)lDAPException);
            }
            throw new LDAPException(lDAPException);
        }
    }

    public LDAPResponseQueue modify(String string, LDAPModification[] lDAPModificationArray, LDAPResponseQueue lDAPResponseQueue, LDAPConstraints lDAPConstraints) throws LDAPException {
        try {
            com.novell.ldap.LDAPModification[] lDAPModificationArray2 = new com.novell.ldap.LDAPModification[lDAPModificationArray.length];
            int n = 0;
            while (n < lDAPModificationArray.length) {
                lDAPModificationArray2[n] = lDAPModificationArray[n].getWrappedObject();
                ++n;
            }
            return new LDAPResponseQueue(this.conn.modify(string, lDAPModificationArray2, lDAPResponseQueue.getWrappedObject(), lDAPConstraints.getWrappedObject()));
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            if (lDAPException instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)lDAPException);
            }
            throw new LDAPException(lDAPException);
        }
    }

    public LDAPEntry read(String string) throws LDAPException {
        try {
            return new LDAPEntry(this.conn.read(string));
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            if (lDAPException instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)lDAPException);
            }
            throw new LDAPException(lDAPException);
        }
    }

    public LDAPEntry read(String string, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        try {
            return new LDAPEntry(this.conn.read(string, lDAPSearchConstraints.getWrappedSearchObject()));
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            if (lDAPException instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)lDAPException);
            }
            throw new LDAPException(lDAPException);
        }
    }

    public LDAPEntry read(String string, String[] stringArray) throws LDAPException {
        try {
            return new LDAPEntry(this.conn.read(string, stringArray));
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            if (lDAPException instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)lDAPException);
            }
            throw new LDAPException(lDAPException);
        }
    }

    public LDAPEntry read(String string, String[] stringArray, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        try {
            return new LDAPEntry(this.conn.read(string, stringArray, lDAPSearchConstraints.getWrappedSearchObject()));
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            if (lDAPException instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)lDAPException);
            }
            throw new LDAPException(lDAPException);
        }
    }

    public static LDAPEntry read(LDAPUrl lDAPUrl) throws LDAPException {
        try {
            return new LDAPEntry(com.novell.ldap.LDAPConnection.read(lDAPUrl.getWrappedObject()));
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            if (lDAPException instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)lDAPException);
            }
            throw new LDAPException(lDAPException);
        }
    }

    public static LDAPEntry read(LDAPUrl lDAPUrl, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        try {
            return new LDAPEntry(com.novell.ldap.LDAPConnection.read(lDAPUrl.getWrappedObject(), lDAPSearchConstraints.getWrappedSearchObject()));
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            if (lDAPException instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)lDAPException);
            }
            throw new LDAPException(lDAPException);
        }
    }

    public void rename(String string, String string2, boolean bl) throws LDAPException {
        try {
            this.conn.rename(string, string2, bl);
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            if (lDAPException instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)lDAPException);
            }
            throw new LDAPException(lDAPException);
        }
    }

    public void rename(String string, String string2, boolean bl, LDAPConstraints lDAPConstraints) throws LDAPException {
        try {
            this.conn.rename(string, string2, bl, lDAPConstraints.getWrappedObject());
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            if (lDAPException instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)lDAPException);
            }
            throw new LDAPException(lDAPException);
        }
    }

    public void rename(String string, String string2, String string3, boolean bl) throws LDAPException {
        try {
            this.conn.rename(string, string2, string3, bl);
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            if (lDAPException instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)lDAPException);
            }
            throw new LDAPException(lDAPException);
        }
    }

    public void rename(String string, String string2, String string3, boolean bl, LDAPConstraints lDAPConstraints) throws LDAPException {
        try {
            this.conn.rename(string, string2, string3, bl, lDAPConstraints.getWrappedObject());
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            if (lDAPException instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)lDAPException);
            }
            throw new LDAPException(lDAPException);
        }
    }

    public LDAPResponseQueue rename(String string, String string2, boolean bl, LDAPResponseQueue lDAPResponseQueue) throws LDAPException {
        try {
            return new LDAPResponseQueue(this.conn.rename(string, string2, bl, lDAPResponseQueue.getWrappedObject()));
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            if (lDAPException instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)lDAPException);
            }
            throw new LDAPException(lDAPException);
        }
    }

    public LDAPResponseQueue rename(String string, String string2, boolean bl, LDAPResponseQueue lDAPResponseQueue, LDAPConstraints lDAPConstraints) throws LDAPException {
        try {
            return new LDAPResponseQueue(this.conn.rename(string, string2, bl, lDAPResponseQueue.getWrappedObject(), lDAPConstraints.getWrappedObject()));
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            if (lDAPException instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)lDAPException);
            }
            throw new LDAPException(lDAPException);
        }
    }

    public LDAPResponseQueue rename(String string, String string2, String string3, boolean bl, LDAPResponseQueue lDAPResponseQueue) throws LDAPException {
        try {
            return new LDAPResponseQueue(this.conn.rename(string, string2, string3, bl, lDAPResponseQueue.getWrappedObject()));
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            if (lDAPException instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)lDAPException);
            }
            throw new LDAPException(lDAPException);
        }
    }

    public LDAPResponseQueue rename(String string, String string2, String string3, boolean bl, LDAPResponseQueue lDAPResponseQueue, LDAPConstraints lDAPConstraints) throws LDAPException {
        try {
            return new LDAPResponseQueue(this.conn.rename(string, string2, string3, bl, lDAPResponseQueue.getWrappedObject(), lDAPConstraints.getWrappedObject()));
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            if (lDAPException instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)lDAPException);
            }
            throw new LDAPException(lDAPException);
        }
    }

    public LDAPSearchResults search(String string, int n, String string2, String[] stringArray, boolean bl) throws LDAPException {
        try {
            return new LDAPSearchResults(this.conn.search(string, n, string2, stringArray, bl));
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            if (lDAPException instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)lDAPException);
            }
            throw new LDAPException(lDAPException);
        }
    }

    public LDAPSearchResults search(String string, int n, String string2, String[] stringArray, boolean bl, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        try {
            return new LDAPSearchResults(this.conn.search(string, n, string2, stringArray, bl, lDAPSearchConstraints.getWrappedSearchObject()));
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            if (lDAPException instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)lDAPException);
            }
            throw new LDAPException(lDAPException);
        }
    }

    public LDAPSearchQueue search(String string, int n, String string2, String[] stringArray, boolean bl, LDAPSearchQueue lDAPSearchQueue) throws LDAPException {
        try {
            return new LDAPSearchQueue(this.conn.search(string, n, string2, stringArray, bl, lDAPSearchQueue.getWrappedObject()));
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            if (lDAPException instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)lDAPException);
            }
            throw new LDAPException(lDAPException);
        }
    }

    public LDAPSearchQueue search(String string, int n, String string2, String[] stringArray, boolean bl, LDAPSearchQueue lDAPSearchQueue, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        try {
            return new LDAPSearchQueue(this.conn.search(string, n, string2, stringArray, bl, lDAPSearchQueue.getWrappedObject(), lDAPSearchConstraints.getWrappedSearchObject()));
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            if (lDAPException instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)lDAPException);
            }
            throw new LDAPException(lDAPException);
        }
    }

    public static LDAPSearchResults search(LDAPUrl lDAPUrl) throws LDAPException {
        try {
            return new LDAPSearchResults(com.novell.ldap.LDAPConnection.search(lDAPUrl.getWrappedObject()));
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            if (lDAPException instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)lDAPException);
            }
            throw new LDAPException(lDAPException);
        }
    }

    public static LDAPSearchResults search(LDAPUrl lDAPUrl, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        try {
            return new LDAPSearchResults(com.novell.ldap.LDAPConnection.search(lDAPUrl.getWrappedObject(), lDAPSearchConstraints.getWrappedSearchObject()));
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            if (lDAPException instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)lDAPException);
            }
            throw new LDAPException(lDAPException);
        }
    }

    public LDAPSchema fetchSchema(String string) throws LDAPException {
        try {
            return new LDAPSchema(this.conn.fetchSchema(string));
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            throw new LDAPException(lDAPException);
        }
    }

    public String getSchemaDN() throws LDAPException {
        try {
            return this.conn.getSchemaDN();
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            throw new LDAPException(lDAPException);
        }
    }

    public String getSchemaDN(String string) throws LDAPException {
        try {
            return this.conn.getSchemaDN(string);
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            throw new LDAPException(lDAPException);
        }
    }

    private class UnsolImpl
    implements com.novell.ldap.LDAPUnsolicitedNotificationListener {
        LDAPUnsolicitedNotificationListener listen;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private UnsolImpl(LDAPUnsolicitedNotificationListener lDAPUnsolicitedNotificationListener) {
            this.listen = lDAPUnsolicitedNotificationListener;
            Hashtable hashtable = LDAPConnection.this.listenerQueues;
            synchronized (hashtable) {
                LDAPConnection.this.listenerQueues.put(lDAPUnsolicitedNotificationListener, this);
            }
        }

        public void messageReceived(com.novell.ldap.LDAPExtendedResponse lDAPExtendedResponse) {
            this.listen.messageReceived(new LDAPExtendedResponse(lDAPExtendedResponse));
        }

        private LDAPUnsolicitedNotificationListener getWrappedObject() {
            return this.listen;
        }
    }

    private static interface SocketFactoryWrapper
    extends com.novell.ldap.LDAPSocketFactory {
        public LDAPSocketFactory getWrappedObject();
    }
}

