/*
 * Decompiled with CFR 0.152.
 */
package org.ietf.ldap.controls;

import com.novell.ldap.asn1.ASN1Boolean;
import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.LBEREncoder;
import org.ietf.ldap.LDAPControl;

public class LDAPPersistSearchControl
extends LDAPControl {
    private static int SEQUENCE_SIZE = 3;
    private static int CHANGETYPES_INDEX = 0;
    private static int CHANGESONLY_INDEX = 1;
    private static int RETURNCONTROLS_INDEX = 2;
    private static LBEREncoder s_encoder = new LBEREncoder();
    private int m_changeTypes;
    private boolean m_changesOnly;
    private boolean m_returnControls;
    private ASN1Sequence m_sequence;
    private static String requestOID = "2.16.840.1.113730.3.4.3";
    private static String responseOID = "2.16.840.1.113730.3.4.7";
    public static final int ADD = 1;
    public static final int DELETE = 2;
    public static final int MODIFY = 4;
    public static final int MODDN = 8;
    public static final int ANY = 15;

    public LDAPPersistSearchControl() {
        this(15, true, true, true);
    }

    public LDAPPersistSearchControl(int n, boolean bl, boolean bl2, boolean bl3) {
        super(requestOID, bl3, null);
        this.m_changeTypes = n;
        this.m_changesOnly = bl;
        this.m_returnControls = bl2;
        this.m_sequence = new ASN1Sequence(SEQUENCE_SIZE);
        this.m_sequence.add(new ASN1Integer(this.m_changeTypes));
        this.m_sequence.add(new ASN1Boolean(this.m_changesOnly));
        this.m_sequence.add(new ASN1Boolean(this.m_returnControls));
        this.setValue();
    }

    public int getChangeTypes() {
        return this.m_changeTypes;
    }

    public void setChangeTypes(int n) {
        this.m_changeTypes = n;
        this.m_sequence.set(CHANGETYPES_INDEX, new ASN1Integer(this.m_changeTypes));
        this.setValue();
    }

    public boolean getReturnControls() {
        return this.m_returnControls;
    }

    public void setReturnControls(boolean bl) {
        this.m_returnControls = bl;
        this.m_sequence.set(RETURNCONTROLS_INDEX, new ASN1Boolean(this.m_returnControls));
        this.setValue();
    }

    public boolean getChangesOnly() {
        return this.m_changesOnly;
    }

    public void setChangesOnly(boolean bl) {
        this.m_changesOnly = bl;
        this.m_sequence.set(CHANGESONLY_INDEX, new ASN1Boolean(this.m_changesOnly));
        this.setValue();
    }

    public String toString() {
        byte[] byArray = this.m_sequence.getEncoding(s_encoder);
        StringBuffer stringBuffer = new StringBuffer(byArray.length);
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(Byte.toString(byArray[n]));
            if (n < byArray.length - 1) {
                stringBuffer.append(",");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private void setValue() {
        super.setValue(this.m_sequence.getEncoding(s_encoder));
    }

    static {
        try {
            LDAPControl.register(responseOID, Class.forName("org.ietf.ldap.controls.LDAPEntryChangeControl"));
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }
}

