/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.event;

import java.util.EventListener;
import java.util.EventObject;
import org.apache.slide.common.Namespace;
import org.apache.slide.common.SlideToken;
import org.apache.slide.common.Uri;
import org.apache.slide.event.AbstractEventMethod;
import org.apache.slide.event.SecurityListener;
import org.apache.slide.event.VetoException;
import org.apache.slide.event.VetoableEventMethod;
import org.apache.slide.security.NodePermission;

public class SecurityEvent
extends EventObject {
    public static final GrantPermission GRANT_PERMISSION = new GrantPermission();
    public static final RevokePermission REVOKE_PERMISSION = new RevokePermission();
    public static final DenyPermission DENY_PERMISSION = new DenyPermission();
    public static final String GROUP = "security";
    public static final AbstractEventMethod[] methods = new AbstractEventMethod[]{GRANT_PERMISSION, REVOKE_PERMISSION, DENY_PERMISSION};
    private Uri objectUri;
    private SlideToken token;
    private NodePermission permission;
    private Namespace namespace;

    public SecurityEvent(Object source, SlideToken token, Namespace namespace, Uri objectUri, NodePermission permission) {
        super(source);
        this.objectUri = objectUri;
        this.token = token;
        this.permission = permission;
        this.namespace = namespace;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append(this.getClass().getName()).append("[object-uri=").append(this.objectUri);
        buffer.append(", permission=").append(this.permission);
        buffer.append("]");
        return buffer.toString();
    }

    public Uri getObjectUri() {
        return this.objectUri;
    }

    public SlideToken getToken() {
        return this.token;
    }

    public NodePermission getPermission() {
        return this.permission;
    }

    public static final class RevokePermission
    extends VetoableEventMethod {
        public RevokePermission() {
            super(SecurityEvent.GROUP, "revoke-permission");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException {
            if (listener instanceof SecurityListener) {
                ((SecurityListener)listener).revokePermission((SecurityEvent)event);
            }
        }
    }

    public static final class DenyPermission
    extends VetoableEventMethod {
        public DenyPermission() {
            super(SecurityEvent.GROUP, "deny-permission");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException {
            if (listener instanceof SecurityListener) {
                ((SecurityListener)listener).denyPermission((SecurityEvent)event);
            }
        }
    }

    public static final class GrantPermission
    extends VetoableEventMethod {
        public GrantPermission() {
            super(SecurityEvent.GROUP, "grant-permission");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException {
            if (listener instanceof SecurityListener) {
                ((SecurityListener)listener).grantPermission((SecurityEvent)event);
            }
        }
    }
}

