/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.event;

import java.util.EventListener;
import java.util.EventObject;
import org.apache.slide.common.Namespace;
import org.apache.slide.common.SlideToken;
import org.apache.slide.event.AbstractEventMethod;
import org.apache.slide.event.StructureListener;
import org.apache.slide.event.VetoException;
import org.apache.slide.event.VetoableEventMethod;
import org.apache.slide.structure.ObjectNode;

public class StructureEvent
extends EventObject {
    public static final Retrieve RETRIEVE = new Retrieve();
    public static final Store STORE = new Store();
    public static final Create CREATE = new Create();
    public static final Remove REMOVE = new Remove();
    public static final CreateLink CREATE_LINK = new CreateLink();
    public static final AddBinding ADD_BINDING = new AddBinding();
    public static final RemoveBinding REMOVE_BINDING = new RemoveBinding();
    public static final String GROUP = "structure";
    public static final AbstractEventMethod[] methods = new AbstractEventMethod[]{RETRIEVE, STORE, CREATE, REMOVE, CREATE_LINK, ADD_BINDING, REMOVE_BINDING};
    private SlideToken token;
    private ObjectNode objectNode = null;
    private String uri = null;
    private Namespace namespace;

    public StructureEvent(Object source, SlideToken token, Namespace namespace, String uri) {
        super(source);
        this.uri = uri;
        this.token = token;
        this.namespace = namespace;
    }

    public StructureEvent(Object source, SlideToken token, Namespace namespace, ObjectNode objectNode) {
        super(source);
        this.token = token;
        this.objectNode = objectNode;
        this.namespace = namespace;
    }

    public StructureEvent(Object source, SlideToken token, ObjectNode objectNode, String uri) {
        super(source);
        this.token = token;
        this.objectNode = objectNode;
        this.uri = uri;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append(this.getClass().getName()).append("[uri=").append(this.uri);
        buffer.append(", objectNode=").append(this.objectNode);
        buffer.append("]");
        return buffer.toString();
    }

    public SlideToken getToken() {
        return this.token;
    }

    public ObjectNode getObjectNode() {
        return this.objectNode;
    }

    public String getUri() {
        return this.uri;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public static final class Retrieve
    extends VetoableEventMethod {
        public Retrieve() {
            super(StructureEvent.GROUP, "retrieve");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException {
            if (listener instanceof StructureListener) {
                ((StructureListener)listener).retrieve((StructureEvent)event);
            }
        }
    }

    public static final class Store
    extends VetoableEventMethod {
        public Store() {
            super(StructureEvent.GROUP, "store");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException {
            if (listener instanceof StructureListener) {
                ((StructureListener)listener).store((StructureEvent)event);
            }
        }
    }

    public static final class RemoveBinding
    extends VetoableEventMethod {
        public RemoveBinding() {
            super(StructureEvent.GROUP, "remove-binding");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException {
            if (listener instanceof StructureListener) {
                ((StructureListener)listener).removeBinding((StructureEvent)event);
            }
        }
    }

    public static final class AddBinding
    extends VetoableEventMethod {
        public AddBinding() {
            super(StructureEvent.GROUP, "add-binding");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException {
            if (listener instanceof StructureListener) {
                ((StructureListener)listener).addBinding((StructureEvent)event);
            }
        }
    }

    public static final class Remove
    extends VetoableEventMethod {
        public Remove() {
            super(StructureEvent.GROUP, "remove");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException {
            if (listener instanceof StructureListener) {
                ((StructureListener)listener).remove((StructureEvent)event);
            }
        }
    }

    public static final class CreateLink
    extends VetoableEventMethod {
        public CreateLink() {
            super(StructureEvent.GROUP, "create-link");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException {
            if (listener instanceof StructureListener) {
                ((StructureListener)listener).createLink((StructureEvent)event);
            }
        }
    }

    public static final class Create
    extends VetoableEventMethod {
        public Create() {
            super(StructureEvent.GROUP, "create");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException {
            if (listener instanceof StructureListener) {
                ((StructureListener)listener).create((StructureEvent)event);
            }
        }
    }
}

