/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.extractor;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.slide.common.PropertyName;
import org.apache.slide.extractor.AbstractPropertyExtractor;
import org.apache.slide.extractor.ExtractorException;
import org.apache.slide.util.conf.Configurable;
import org.apache.slide.util.conf.Configuration;
import org.apache.slide.util.conf.ConfigurationException;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.Text;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;

public class SimpleXmlExtractor
extends AbstractPropertyExtractor
implements Configurable {
    protected List instructions = new ArrayList();

    public SimpleXmlExtractor(String uri, String contentType, String namespace) {
        super(uri, contentType, namespace);
    }

    public Map extract(InputStream content) throws ExtractorException {
        HashMap<PropertyName, Object> properties = new HashMap<PropertyName, Object>();
        try {
            SAXBuilder saxBuilder = new SAXBuilder();
            Document document = saxBuilder.build(content);
            Iterator i = this.instructions.iterator();
            while (i.hasNext()) {
                Instruction instruction = (Instruction)i.next();
                XPath xPath = instruction.getxPath();
                List nodeList = xPath.selectNodes((Object)document);
                Object propertyValue = this.filter(nodeList, instruction);
                if (propertyValue == null) continue;
                properties.put(instruction.getPropertyName(), propertyValue);
            }
        }
        catch (IOException e) {
            throw new ExtractorException("Exception while retrieving content");
        }
        catch (JDOMException e) {
            throw new ExtractorException("Exception while parsing content. XML document must be wellformed.");
        }
        return properties;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Enumeration instructions = configuration.getConfigurations("instruction");
        while (instructions.hasMoreElements()) {
            Configuration instruction = (Configuration)instructions.nextElement();
            this.addInstruction(this.createInstruction(instruction));
        }
    }

    protected Object filter(List nodeList, Instruction instruction) throws ExtractorException {
        if (nodeList.size() > 0) {
            if (nodeList.get(0) instanceof Text) {
                return ((Text)nodeList.get(0)).getText();
            }
            if (nodeList.get(0) instanceof Attribute) {
                return ((Attribute)nodeList.get(0)).getValue();
            }
            if (nodeList.get(0) instanceof String) {
                return nodeList.get(0);
            }
        }
        return null;
    }

    protected void addInstruction(Instruction instruction) {
        this.instructions.add(instruction);
    }

    protected Instruction createInstruction(Configuration instruction) throws ConfigurationException {
        try {
            String property = instruction.getAttribute("property");
            String namespace = instruction.getAttribute("namespace", "DAV:");
            XPath xPath = XPath.newInstance((String)instruction.getAttribute("xpath"));
            return new Instruction(xPath, new PropertyName(property, namespace));
        }
        catch (JDOMException e) {
            throw new ConfigurationException("Could not create xPath from given attribute", instruction);
        }
    }

    protected static class Instruction {
        private XPath xPath;
        private PropertyName propertyName;

        public Instruction(XPath xPath, PropertyName property) {
            this.xPath = xPath;
            this.propertyName = property;
        }

        public XPath getxPath() {
            return this.xPath;
        }

        public PropertyName getPropertyName() {
            return this.propertyName;
        }
    }
}

