/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.util.logger;

import org.apache.commons.transaction.util.LoggerFacade;
import org.apache.slide.util.logger.Logger;

public class TxLogger
implements LoggerFacade {
    protected Logger logger;
    protected String logChannel;

    public TxLogger(Logger logger, String logChannel) {
        this.logger = logger;
        this.logChannel = logChannel;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public LoggerFacade createLogger(String name) {
        return new TxLogger(this.logger, name);
    }

    public void logInfo(String message) {
        this.logger.log(message, this.logChannel, 6);
    }

    public void logFine(String message) {
        this.logger.log(message, this.logChannel, 7);
    }

    public boolean isFineEnabled() {
        return this.logger.isEnabled(this.logChannel, 7);
    }

    public void logFiner(String message) {
        this.logger.log(message, this.logChannel, 7);
    }

    public boolean isFinerEnabled() {
        return this.logger.isEnabled(this.logChannel, 7);
    }

    public void logFinest(String message) {
        this.logger.log(message, this.logChannel, 7);
    }

    public boolean isFinestEnabled() {
        return this.logger.isEnabled(this.logChannel, 7);
    }

    public void logWarning(String message) {
        this.logger.log(message, this.logChannel, 4);
    }

    public void logWarning(String message, Throwable t) {
        this.logger.log(message, this.logChannel, 4);
        this.logger.log(t, this.logChannel, 4);
    }

    public void logSevere(String message) {
        this.logger.log(message, this.logChannel, 0);
    }

    public void logSevere(String message, Throwable t) {
        this.logger.log(message, this.logChannel, 0);
        this.logger.log(t, this.logChannel, 0);
    }
}

