/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.groups;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.EntityTypes;
import org.jasig.portal.concurrency.CachingException;
import org.jasig.portal.concurrency.IEntityLock;
import org.jasig.portal.concurrency.LockingException;
import org.jasig.portal.groups.ComponentGroupServiceDescriptor;
import org.jasig.portal.groups.CompositeEntityIdentifier;
import org.jasig.portal.groups.EntityGroupImpl;
import org.jasig.portal.groups.GroupMemberImpl;
import org.jasig.portal.groups.GroupsException;
import org.jasig.portal.groups.IEntity;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IEntityGroupStore;
import org.jasig.portal.groups.IEntityGroupStoreFactory;
import org.jasig.portal.groups.IEntitySearcher;
import org.jasig.portal.groups.IEntitySearcherFactory;
import org.jasig.portal.groups.IEntityStore;
import org.jasig.portal.groups.IEntityStoreFactory;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.groups.IIndividualGroupService;
import org.jasig.portal.groups.ILockableEntityGroup;
import org.jasig.portal.groups.ILockableGroupService;
import org.jasig.portal.groups.ReferenceCompositeGroupService;
import org.jasig.portal.services.EntityCachingService;
import org.jasig.portal.services.EntityLockService;
import org.jasig.portal.services.GroupService;
import org.jasig.portal.services.LogService;

public class ReferenceIndividualGroupService
extends ReferenceCompositeGroupService
implements IIndividualGroupService,
ILockableGroupService {
    protected ComponentGroupServiceDescriptor serviceDescriptor;
    protected IEntityGroupStore groupFactory;
    protected IEntitySearcher entitySearcher;

    public ReferenceIndividualGroupService() throws GroupsException {
        this(new ComponentGroupServiceDescriptor());
    }

    public ReferenceIndividualGroupService(ComponentGroupServiceDescriptor svcDescriptor) throws GroupsException {
        this.serviceDescriptor = svcDescriptor;
        this.initialize();
    }

    protected boolean cacheInUse() {
        return this.getServiceDescriptor().isCachingEnabled();
    }

    public void deleteGroup(IEntityGroup group) throws GroupsException {
        this.throwExceptionIfNotInternallyManaged();
        this.synchronizeGroupMembersOnDelete(group);
        this.getGroupStore().delete(group);
        if (this.cacheInUse()) {
            this.cacheRemove(group);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void removeDeletedGroupFromContainingGroups(ILockableEntityGroup group) throws GroupsException {
        Iterator itr2222;
        IEntityGroup containingGroup = null;
        ILockableEntityGroup lockableGroup = null;
        IEntityLock lock = null;
        ArrayList<ILockableEntityGroup> lockableGroups = new ArrayList<ILockableEntityGroup>();
        try {
            try {
                String lockOwner = group.getLock().getLockOwner();
                Iterator itr = group.getContainingGroups();
                while (itr.hasNext()) {
                    containingGroup = (IEntityGroup)itr.next();
                    lockableGroup = GroupService.findLockableGroup(containingGroup.getKey(), lockOwner);
                    if (lockableGroup == null) continue;
                    lockableGroups.add(lockableGroup);
                }
                itr = lockableGroups.iterator();
                while (itr.hasNext()) {
                    lockableGroup = (ILockableEntityGroup)itr.next();
                    lockableGroup.removeMember(group);
                    lockableGroup.updateMembers();
                }
                Object var9_10 = null;
                itr2222 = lockableGroups.iterator();
            }
            catch (GroupsException ge) {
                throw new GroupsException("Could not remove deleted group " + group.getKey() + " from parent : " + ge.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            Iterator itr2222 = lockableGroups.iterator();
            while (true) {
                if (!itr2222.hasNext()) {
                    throw throwable;
                }
                lock = ((ILockableEntityGroup)itr2222.next()).getLock();
                try {
                    if (!lock.isValid()) continue;
                    lock.release();
                }
                catch (LockingException le) {
                    LogService.log(LogService.ERROR, "ReferenceIndividualGroupService.removeDeletedGroupFromContainingGroups(): Problem unlocking parent group: " + le.getMessage());
                }
            }
        }
        while (itr2222.hasNext()) {
            lock = ((ILockableEntityGroup)itr2222.next()).getLock();
            try {}
            catch (LockingException le) {
                LogService.log(LogService.ERROR, "ReferenceIndividualGroupService.removeDeletedGroupFromContainingGroups(): Problem unlocking parent group: " + le.getMessage());
                continue;
            }
            if (!lock.isValid()) continue;
            lock.release();
            break;
        }
        return;
    }

    public void deleteGroup(ILockableEntityGroup group) throws GroupsException {
        block10: {
            this.throwExceptionIfNotInternallyManaged();
            try {
                if (group.getLock().isValid()) {
                    this.removeDeletedGroupFromContainingGroups(group);
                    this.deleteGroup((IEntityGroup)group);
                    break block10;
                }
                throw new GroupsException("Could not delete group " + group.getKey() + " has invalid lock.");
            }
            catch (LockingException le) {
                throw new GroupsException("Could not delete group " + group.getKey() + " : " + le.getMessage());
            }
            finally {
                try {
                    group.getLock().release();
                }
                catch (LockingException le) {}
            }
        }
    }

    private EntityIdentifier[] filterEntities(EntityIdentifier[] entities, IEntityGroup ancestor) throws GroupsException {
        ArrayList<EntityIdentifier> ar = new ArrayList<EntityIdentifier>(entities.length);
        for (int i = 0; i < entities.length; ++i) {
            IGroupMember gm = this.getGroupMember(entities[i]);
            if (!ancestor.deepContains(gm)) continue;
            ar.add(entities[i]);
        }
        return ar.toArray(new EntityIdentifier[0]);
    }

    public Iterator findContainingGroups(IGroupMember gm) throws GroupsException {
        ArrayList<IEntityGroup> groups = new ArrayList<IEntityGroup>(10);
        IEntityGroup group = null;
        Iterator it = this.getGroupStore().findContainingGroups(gm);
        while (it.hasNext()) {
            group = (IEntityGroup)it.next();
            group.setLocalGroupService(this);
            groups.add(group);
            if (!this.cacheInUse()) continue;
            try {
                if (this.getGroupFromCache(group.getEntityIdentifier().getKey()) != null) continue;
                this.cacheAdd(group);
            }
            catch (CachingException ce) {
                throw new GroupsException("Problem finding containing groups: " + ce.getMessage());
            }
        }
        return groups.iterator();
    }

    public IEntityGroup findGroup(String key) throws GroupsException {
        return this.findGroup(this.newCompositeEntityIdentifier(key));
    }

    public IEntityGroup findGroup(CompositeEntityIdentifier ent) throws GroupsException {
        return this.cacheInUse() ? this.findGroupWithCache(ent.getKey()) : this.primFindGroup(ent.getLocalKey());
    }

    protected IEntityGroup findGroupWithCache(String key) throws GroupsException {
        return this.findGroupWithCache(this.newCompositeEntityIdentifier(key));
    }

    protected IEntityGroup findGroupWithCache(CompositeEntityIdentifier ent) throws GroupsException {
        try {
            IEntityGroup group = this.getGroupFromCache(ent.getKey());
            if (group == null && (group = this.primFindGroup(ent.getLocalKey())) != null) {
                this.cacheAdd(group);
            }
            return group;
        }
        catch (CachingException ce) {
            throw new GroupsException("Problem retrieving group " + ent.getKey() + " : " + ce.getMessage());
        }
    }

    public ILockableEntityGroup findGroupWithLock(String key, String owner) throws GroupsException {
        return this.findGroupWithLock(key, owner, 0);
    }

    public ILockableEntityGroup findGroupWithLock(String key, String owner, int secs) throws GroupsException {
        this.throwExceptionIfNotInternallyManaged();
        Class groupType = EntityTypes.GROUP_ENTITY_TYPE;
        try {
            IEntityLock lock = secs == 0 ? EntityLockService.instance().newWriteLock(groupType, key, owner) : EntityLockService.instance().newWriteLock(groupType, key, owner, secs);
            ILockableEntityGroup group = this.groupFactory.findLockable(key);
            if (group == null) {
                lock.release();
            } else {
                group.setLock(lock);
                group.setLocalGroupService(this);
            }
            return group;
        }
        catch (LockingException le) {
            throw new GroupsException("Problem getting lock for group " + key + " : " + le.getMessage());
        }
    }

    protected Iterator findLocalMemberGroups(IEntityGroup eg) throws GroupsException {
        ArrayList<IEntityGroup> groups = new ArrayList<IEntityGroup>(10);
        IEntityGroup group = null;
        Iterator it = this.getGroupStore().findMemberGroups(eg);
        while (it.hasNext()) {
            group = (IEntityGroup)it.next();
            group.setLocalGroupService(this);
            groups.add(group);
            if (!this.cacheInUse()) continue;
            try {
                if (this.getGroupFromCache(group.getEntityIdentifier().getKey()) != null) continue;
                this.cacheAdd(group);
            }
            catch (CachingException ce) {
                throw new GroupsException("Problem finding member groups: " + ce.getMessage());
            }
        }
        return groups.iterator();
    }

    public Iterator findMemberEntities(IEntityGroup group) throws GroupsException {
        return this.getGroupStore().findEntitiesForGroup(group);
    }

    public Iterator findMemberGroups(IEntityGroup eg) throws GroupsException {
        HashMap<String, IEntityGroup> groups = new HashMap<String, IEntityGroup>();
        IEntityGroup group = null;
        Iterator itr = this.findLocalMemberGroups(eg);
        while (itr.hasNext()) {
            group = (IEntityGroup)itr.next();
            groups.put(group.getKey(), group);
        }
        String[] memberGroupKeys = this.getGroupStore().findMemberGroupKeys(eg);
        for (int i = 0; i < memberGroupKeys.length; ++i) {
            if (groups.containsKey(memberGroupKeys[i]) || (group = GroupService.findGroup(memberGroupKeys[i])) == null) continue;
            groups.put(group.getKey(), group);
        }
        return groups.values().iterator();
    }

    public Iterator findMembers(IEntityGroup eg) throws GroupsException {
        ArrayList members = new ArrayList(10);
        Iterator it = null;
        it = this.findMemberGroups(eg);
        while (it.hasNext()) {
            members.add(it.next());
        }
        it = this.findMemberEntities(eg);
        while (it.hasNext()) {
            members.add(it.next());
        }
        return members.iterator();
    }

    public IEntity getEntity(String key, Class type) throws GroupsException {
        IEntity ent = this.primGetEntity(key, type);
        if (this.cacheInUse()) {
            try {
                IEntity cachedEnt = this.getEntityFromCache(ent.getEntityIdentifier().getKey());
                if (cachedEnt == null) {
                    this.cacheAdd(ent);
                } else {
                    ent = cachedEnt;
                }
            }
            catch (CachingException ce) {
                throw new GroupsException("Problem retrieving group member " + type + "(" + key + ") : " + ce.getMessage());
            }
        }
        return ent;
    }

    public IEntityStore getEntityFactory() {
        return this.entityFactory;
    }

    protected IEntityGroup getGroupFromCache(String key) throws CachingException {
        return (IEntityGroup)EntityCachingService.instance().get(EntityTypes.GROUP_ENTITY_TYPE, key);
    }

    public IGroupMember getGroupMember(String key, Class type) throws GroupsException {
        IGroupMember gm = null;
        gm = type == EntityTypes.GROUP_ENTITY_TYPE ? this.findGroup(key) : this.getEntity(key, type);
        return gm;
    }

    public IGroupMember getGroupMember(EntityIdentifier underlyingEntityIdentifier) throws GroupsException {
        return this.getGroupMember(underlyingEntityIdentifier.getKey(), underlyingEntityIdentifier.getType());
    }

    public IEntityGroupStore getGroupStore() throws GroupsException {
        return this.groupFactory;
    }

    protected ComponentGroupServiceDescriptor getServiceDescriptor() {
        return this.serviceDescriptor;
    }

    private void initialize() throws GroupsException {
        String eMsg = null;
        String svcName = this.getServiceDescriptor().getName();
        LogService.log(LogService.DEBUG, "Service descriptor attributes: " + svcName);
        Iterator i = this.getServiceDescriptor().keySet().iterator();
        while (i.hasNext()) {
            String descriptorKey = (String)i.next();
            Object descriptorValue = this.getServiceDescriptor().get(descriptorKey);
            if (descriptorValue == null) continue;
            LogService.log(LogService.DEBUG, "  " + descriptorKey + " : " + descriptorValue);
        }
        String groupStoreFactoryName = this.getServiceDescriptor().getGroupStoreFactoryName();
        String entityStoreFactoryName = this.getServiceDescriptor().getEntityStoreFactoryName();
        String entitySearcherFactoryName = this.getServiceDescriptor().getEntitySearcherFactoryName();
        if (groupStoreFactoryName == null) {
            eMsg = "ReferenceGroupService.initialize(): (" + svcName + ") No Group Store factory specified in service descriptor.";
            LogService.log(LogService.INFO, eMsg);
        } else {
            try {
                IEntityGroupStoreFactory groupStoreFactory = (IEntityGroupStoreFactory)Class.forName(groupStoreFactoryName).newInstance();
                this.groupFactory = groupStoreFactory.newGroupStore(this.getServiceDescriptor());
            }
            catch (Exception e) {
                eMsg = "ReferenceIndividualGroupService.initialize(): Failed to instantiate group store (" + svcName + "): " + e;
                LogService.log(LogService.ERROR, eMsg);
                throw new GroupsException(eMsg);
            }
        }
        if (entityStoreFactoryName == null) {
            eMsg = "ReferenceIndividualGroupService.initialize(): No Entity Store Factory specified in service descriptor (" + svcName + ")";
            LogService.log(LogService.INFO, eMsg);
        } else {
            try {
                IEntityStoreFactory entityStoreFactory = (IEntityStoreFactory)Class.forName(entityStoreFactoryName).newInstance();
                this.entityFactory = entityStoreFactory.newEntityStore();
            }
            catch (Exception e) {
                eMsg = "ReferenceIndividualGroupService.initialize(): Failed to instantiate entity store " + e;
                LogService.log(LogService.ERROR, eMsg);
                throw new GroupsException(eMsg);
            }
        }
        if (entitySearcherFactoryName == null) {
            eMsg = "ReferenceIndividualGroupService.initialize(): No Entity Searcher Factory specified in service descriptor.";
            LogService.log(LogService.INFO, eMsg);
        } else {
            try {
                IEntitySearcherFactory entitySearcherFactory = (IEntitySearcherFactory)Class.forName(entitySearcherFactoryName).newInstance();
                this.entitySearcher = entitySearcherFactory.newEntitySearcher();
            }
            catch (Exception e) {
                eMsg = "ReferenceIndividualGroupService.initialize(): Failed to instantiate entity searcher " + e;
                LogService.log(LogService.ERROR, eMsg);
                throw new GroupsException(eMsg);
            }
        }
    }

    public boolean isEditable(IEntityGroup group) throws GroupsException {
        return this.isInternallyManaged();
    }

    protected boolean isInternallyManaged() {
        return this.getServiceDescriptor().isInternallyManaged();
    }

    public boolean isLeafService() {
        return true;
    }

    public boolean isEditable() {
        return this.isInternallyManaged();
    }

    public IEntityGroup newGroup(Class type) throws GroupsException {
        this.throwExceptionIfNotInternallyManaged();
        IEntityGroup group = this.groupFactory.newInstance(type);
        group.setLocalGroupService(this);
        if (this.cacheInUse()) {
            this.cacheAdd(group);
        }
        return group;
    }

    protected IEntityGroup primFindGroup(String localKey) throws GroupsException {
        IEntityGroup group = this.groupFactory.find(localKey);
        if (group != null) {
            group.setLocalGroupService(this);
        }
        return group;
    }

    private EntityIdentifier[] removeDuplicates(EntityIdentifier[] entities) {
        ArrayList<EntityIdentifier> ar = new ArrayList<EntityIdentifier>(entities.length);
        for (int i = 0; i < entities.length; ++i) {
            if (ar.contains(entities[i])) continue;
            ar.add(entities[i]);
        }
        return ar.toArray(new EntityIdentifier[0]);
    }

    public EntityIdentifier[] searchForEntities(String query, int method, Class type) throws GroupsException {
        return this.removeDuplicates(this.entitySearcher.searchForEntities(query, method, type));
    }

    public EntityIdentifier[] searchForEntities(String query, int method, Class type, IEntityGroup ancestor) throws GroupsException {
        return this.filterEntities(this.searchForEntities(query, method, type), ancestor);
    }

    public EntityIdentifier[] searchForGroups(String query, int method, Class leaftype) throws GroupsException {
        return this.removeDuplicates(this.groupFactory.searchForGroups(query, method, leaftype));
    }

    public EntityIdentifier[] searchForGroups(String query, int method, Class leaftype, IEntityGroup ancestor) throws GroupsException {
        return this.filterEntities(this.searchForGroups(query, method, leaftype), ancestor);
    }

    protected void throwExceptionIfNotInternallyManaged() throws GroupsException {
        if (!this.isInternallyManaged()) {
            throw new GroupsException("Group Service " + this.getServiceName() + " is not updatable.");
        }
    }

    public void updateGroup(IEntityGroup group) throws GroupsException {
        this.throwExceptionIfNotInternallyManaged();
        this.getGroupStore().update(group);
        if (this.cacheInUse()) {
            this.cacheUpdate(group);
        }
        this.synchronizeGroupMembersOnUpdate(group);
    }

    public void updateGroup(ILockableEntityGroup group) throws GroupsException {
        this.updateGroup(group, false);
    }

    public void updateGroup(ILockableEntityGroup group, boolean renewLock) throws GroupsException {
        this.throwExceptionIfNotInternallyManaged();
        try {
            if (!group.getLock().isValid()) {
                throw new GroupsException("Could not update group " + group.getKey() + " has invalid lock.");
            }
            this.getGroupStore().update(group);
            if (this.cacheInUse()) {
                this.cacheRemove(group);
            }
            this.synchronizeGroupMembersOnUpdate(group);
            if (renewLock) {
                group.getLock().renew();
            } else {
                group.getLock().release();
            }
        }
        catch (LockingException le) {
            throw new GroupsException("Problem updating group " + group.getKey() + " : " + le.getMessage());
        }
    }

    public void updateGroupMembers(IEntityGroup group) throws GroupsException {
        this.throwExceptionIfNotInternallyManaged();
        this.getGroupStore().updateMembers(group);
        if (this.cacheInUse()) {
            this.cacheUpdate(group);
        }
        this.synchronizeGroupMembersOnUpdate(group);
    }

    public void updateGroupMembers(ILockableEntityGroup group) throws GroupsException {
        this.updateGroupMembers(group, false);
    }

    public void updateGroupMembers(ILockableEntityGroup group, boolean renewLock) throws GroupsException {
        this.throwExceptionIfNotInternallyManaged();
        try {
            if (!group.getLock().isValid()) {
                throw new GroupsException("Could not update group " + group.getKey() + " has invalid lock.");
            }
            this.getGroupStore().updateMembers(group);
            if (this.cacheInUse()) {
                this.cacheRemove(group);
            }
            this.synchronizeGroupMembersOnUpdate(group);
            if (renewLock) {
                group.getLock().renew();
            } else {
                group.getLock().release();
            }
        }
        catch (LockingException le) {
            throw new GroupsException("Problem updating group " + group.getKey() + " : " + le.getMessage());
        }
    }

    protected IEntity primGetEntity(String key, Class type) throws GroupsException {
        return this.entityFactory.newInstance(key, type);
    }

    protected void synchronizeGroupMembersOnDelete(IEntityGroup group) throws GroupsException {
        GroupMemberImpl gmi = null;
        Iterator it = group.getMembers();
        while (it.hasNext()) {
            gmi = (GroupMemberImpl)it.next();
            gmi.removeGroup(group);
            if (!this.cacheInUse()) continue;
            this.cacheUpdate(gmi);
        }
    }

    protected void synchronizeGroupMembersOnUpdate(IEntityGroup group) throws GroupsException {
        EntityGroupImpl egi = (EntityGroupImpl)group;
        GroupMemberImpl gmi = null;
        Iterator it = egi.getAddedMembers().values().iterator();
        while (it.hasNext()) {
            gmi = (GroupMemberImpl)it.next();
            gmi.addGroup(egi);
            if (!this.cacheInUse()) continue;
            this.cacheUpdate(gmi);
        }
        it = egi.getRemovedMembers().values().iterator();
        while (it.hasNext()) {
            gmi = (GroupMemberImpl)it.next();
            gmi.removeGroup(egi);
            if (!this.cacheInUse()) continue;
            this.cacheUpdate(gmi);
        }
    }
}

