/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.services;

import javax.naming.InvalidNameException;
import javax.naming.Name;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.PropertiesManager;
import org.jasig.portal.concurrency.CachingException;
import org.jasig.portal.groups.CompositeEntityIdentifier;
import org.jasig.portal.groups.CompositeServiceIdentifier;
import org.jasig.portal.groups.GroupServiceConfiguration;
import org.jasig.portal.groups.GroupsException;
import org.jasig.portal.groups.ICompositeGroupService;
import org.jasig.portal.groups.ICompositeGroupServiceFactory;
import org.jasig.portal.groups.IEntity;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IGroupConstants;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.groups.IGroupService;
import org.jasig.portal.groups.IGroupServiceFactory;
import org.jasig.portal.groups.ILockableEntityGroup;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.services.EntityCachingService;
import org.jasig.portal.services.LogService;

public class GroupService
implements IGroupConstants {
    private static GroupService instance = null;
    private static boolean composite;
    private IGroupService groupService = null;
    private ICompositeGroupService compositeGroupService = null;
    protected static final String GROUP_SERVICE_KEY = "org.jasig.portal.services.GroupService.key_";

    private GroupService() throws GroupsException {
        this.initializeCompositeService();
    }

    public static IEntityGroup findGroup(String key) throws GroupsException {
        return GroupService.instance().ifindGroup(key);
    }

    public static ILockableEntityGroup findLockableGroup(String key, String lockOwner) throws GroupsException {
        return GroupService.instance().ifindLockableGroup(key, lockOwner);
    }

    public static void finishedSession(IPerson person) {
        try {
            GroupService.instance().ifinishedSession(person);
        }
        catch (GroupsException ge) {
            LogService.log(LogService.ERROR, ge);
        }
    }

    public static ICompositeGroupService getCompositeGroupService() throws GroupsException {
        return GroupService.instance().compositeGroupService;
    }

    protected String getDefaultServiceName() throws GroupsException {
        return (String)this.getServiceConfiguration().getAttributes().get("defaultService");
    }

    public static IEntityGroup getDistinguishedGroup(String name) throws GroupsException {
        return GroupService.instance().igetDistinguishedGroup(name);
    }

    public String getDistinguishedGroupKey(String name) {
        return PropertiesManager.getProperty(GROUP_SERVICE_KEY + name);
    }

    public static IEntity getEntity(String key, Class type) throws GroupsException {
        return GroupService.getEntity(key, type, null);
    }

    public static IEntity getEntity(String key, Class type, String service) throws GroupsException {
        return GroupService.instance().igetEntity(key, type, service);
    }

    public static IGroupMember getGroupMember(String key, Class type) throws GroupsException {
        return GroupService.instance().igetGroupMember(key, type);
    }

    public static IGroupMember getGroupMember(EntityIdentifier underlyingEntityIdentifier) throws GroupsException {
        return GroupService.getGroupMember(underlyingEntityIdentifier.getKey(), underlyingEntityIdentifier.getType());
    }

    public static IGroupService getGroupService() throws GroupsException {
        return GroupService.instance().groupService;
    }

    public static IEntityGroup getRootGroup(Class type) throws GroupsException {
        return GroupService.instance().igetRootGroup(type);
    }

    protected GroupServiceConfiguration getServiceConfiguration() throws GroupsException {
        try {
            return GroupServiceConfiguration.getConfiguration();
        }
        catch (Exception ex) {
            throw new GroupsException("Problem retrieving service configuration: " + ex.getMessage());
        }
    }

    protected IEntityGroup ifindGroup(String key) throws GroupsException {
        return this.compositeGroupService.findGroup(key);
    }

    protected ILockableEntityGroup ifindLockableGroup(String key, String lockOwner) throws GroupsException {
        return this.compositeGroupService.findGroupWithLock(key, lockOwner);
    }

    protected void ifinishedSession(IPerson person) throws GroupsException {
        IGroupMember gm = GroupService.getGroupMember(person.getEntityIdentifier());
        try {
            EntityCachingService.instance().remove(gm.getEntityIdentifier());
        }
        catch (CachingException ce) {
            throw new GroupsException("Problem removing group member " + gm.getKey() + " from cache: " + ce.getMessage());
        }
    }

    protected IEntityGroup igetDistinguishedGroup(String name) throws GroupsException {
        try {
            String key = this.getDistinguishedGroupKey(name);
            return this.compositeGroupService.findGroup(key);
        }
        catch (Exception ex) {
            throw new GroupsException("GroupService.getDistinguishedGroup(): could not find key for: " + name);
        }
    }

    protected IEntity igetEntity(String key, Class type, String service) throws GroupsException {
        return this.compositeGroupService.getEntity(key, type, service);
    }

    protected IGroupMember igetGroupMember(String key, Class type) throws GroupsException {
        return this.compositeGroupService.getGroupMember(key, type);
    }

    protected IEntityGroup igetRootGroup(Class type) throws GroupsException {
        return this.igetDistinguishedGroup(type.getName());
    }

    protected IEntityGroup inewGroup(Class type) throws GroupsException {
        return this.inewGroup(type, this.getDefaultServiceName());
    }

    protected IEntityGroup inewGroup(Class type, String serviceName) throws GroupsException {
        try {
            return this.compositeGroupService.newGroup(type, GroupService.parseServiceName(serviceName));
        }
        catch (InvalidNameException ine) {
            throw new GroupsException("GroupService.inewGroup(): invalid service name: " + ine.getMessage());
        }
    }

    private void initialize() throws GroupsException {
        String eMsg = null;
        String factoryName = PropertiesManager.getProperty("org.jasig.portal.groups.GroupServiceFactory");
        if (factoryName == null) {
            eMsg = "GroupService.initialize(): No entry for org.jasig.portal.groups.GroupServiceFactory in portal.properties.";
            LogService.log(LogService.ERROR, eMsg);
            throw new GroupsException(eMsg);
        }
        try {
            IGroupServiceFactory groupServiceFactory = (IGroupServiceFactory)Class.forName(factoryName).newInstance();
            this.groupService = groupServiceFactory.newGroupService();
        }
        catch (Exception e) {
            eMsg = "GroupService.initialize(): Problem creating groups service... " + e.getMessage();
            LogService.log(LogService.ERROR, eMsg);
            throw new GroupsException(eMsg);
        }
    }

    private void initializeCompositeService() throws GroupsException {
        String eMsg = null;
        try {
            GroupServiceConfiguration cfg = this.getServiceConfiguration();
            String factoryName = (String)cfg.getAttributes().get("compositeFactory");
            if (factoryName == null) {
                eMsg = "GroupService.initialize(): No entry for CompositeServiceFactory in configuration";
                LogService.log(LogService.ERROR, eMsg);
                throw new GroupsException(eMsg);
            }
            ICompositeGroupServiceFactory serviceFactory = (ICompositeGroupServiceFactory)Class.forName(factoryName).newInstance();
            this.compositeGroupService = serviceFactory.newGroupService();
        }
        catch (Exception e) {
            eMsg = "GroupService.initialize(): Problem creating groups service... " + e.getMessage();
            LogService.log(LogService.ERROR, eMsg);
            throw new GroupsException(eMsg);
        }
    }

    public static synchronized GroupService instance() throws GroupsException {
        if (instance == null) {
            instance = new GroupService();
        }
        return instance;
    }

    public static boolean isComposite() {
        return composite;
    }

    public static IEntityGroup newGroup(Class type) throws GroupsException {
        return GroupService.instance().inewGroup(type);
    }

    public static IEntityGroup newGroup(Class type, String serviceName) throws GroupsException {
        return GroupService.instance().inewGroup(type, serviceName);
    }

    public static String parseLocalKey(String compositeKey) throws InvalidNameException, GroupsException {
        return new CompositeEntityIdentifier(compositeKey, new Object().getClass()).getLocalKey();
    }

    public static Name parseServiceName(String serviceName) throws InvalidNameException, GroupsException {
        return new CompositeServiceIdentifier(serviceName).getServiceName();
    }

    public static EntityIdentifier[] searchForEntities(String query, int method, Class type) throws GroupsException {
        return GroupService.instance().compositeGroupService.searchForEntities(query, method, type);
    }

    public static EntityIdentifier[] searchForEntities(String query, int method, Class type, IEntityGroup ancestor) throws GroupsException {
        return GroupService.instance().compositeGroupService.searchForEntities(query, method, type, ancestor);
    }

    public static EntityIdentifier[] searchForGroups(String query, int method, Class leaftype) throws GroupsException {
        return GroupService.instance().compositeGroupService.searchForGroups(query, method, leaftype);
    }

    public static EntityIdentifier[] searchForGroups(String query, int method, Class leaftype, IEntityGroup ancestor) throws GroupsException {
        return GroupService.instance().compositeGroupService.searchForGroups(query, method, leaftype, ancestor);
    }

    public static void startUp() throws GroupsException {
        GroupService.instance();
    }
}

