/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.store.impl.rdbms;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.slide.common.Service;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.Uri;
import org.apache.slide.content.NodeRevisionContent;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.store.impl.rdbms.CommonRDBMSAdapter;
import org.apache.slide.store.impl.rdbms.SequenceAdapter;
import org.apache.slide.store.impl.rdbms.StoreContentZip;
import org.apache.slide.util.logger.Logger;

public class OracleRDBMSAdapter
extends CommonRDBMSAdapter
implements SequenceAdapter {
    protected Method blobGetOutStreamMethod;

    public OracleRDBMSAdapter(Service service, Logger logger) throws ClassNotFoundException, NoSuchMethodException {
        super(service, logger);
        Class<?> bCls = Class.forName("oracle.sql.BLOB");
        this.blobGetOutStreamMethod = bCls.getMethod("getBinaryOutputStream", new Class[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void storeContent(Connection connection, Uri uri, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws IOException, SQLException {
        CallableStatement statement;
        InputStream is;
        block36: {
            this.assureVersionInfo(connection, uri, revisionDescriptor);
            is = revisionContent.streamContent();
            if (is == null) return;
            long blobLength = 0L;
            File tempFile = null;
            if (this.bcompress) {
                this.getLogger().log((Object)"Compressing the data", LOG_CHANNEL, 7);
                StoreContentZip ziputil = new StoreContentZip();
                ziputil.Zip(is);
                is = ziputil.getInputStream();
                if (revisionDescriptor.getContentLength() == -1L) {
                    revisionDescriptor.setContentLength(ziputil.getInitialContentLength());
                }
                blobLength = ziputil.getContentLength();
            } else {
                if (revisionDescriptor.getContentLength() == -1L) {
                    try {
                        tempFile = File.createTempFile("content", null);
                        FileOutputStream fos = new FileOutputStream(tempFile);
                        try {
                            int nChar;
                            byte[] buffer = new byte[4096];
                            while ((nChar = is.read(buffer)) != -1) {
                                fos.write(buffer, 0, nChar);
                            }
                        }
                        finally {
                            fos.close();
                        }
                        is.close();
                        is = new FileInputStream(tempFile);
                        revisionDescriptor.setContentLength(tempFile.length());
                    }
                    catch (IOException ex) {
                        this.getLogger().log((Object)(ex.toString() + " during the calculation of the content length."), LOG_CHANNEL, 2);
                        throw ex;
                    }
                }
                blobLength = revisionDescriptor.getContentLength();
            }
            statement = null;
            try {
                long versionID = this.getVersionID(connection, uri.toString(), revisionDescriptor);
                statement = connection.prepareCall("BEGIN insert into VERSION_CONTENT (VERSION_ID, CONTENT) values (?, empty_blob()) RETURN CONTENT into ?;END; ");
                statement.setLong(1, versionID);
                statement.registerOutParameter(2, 2004);
                statement.executeUpdate();
                Blob bObj = statement.getBlob(2);
                OutputStream os = null;
                try {
                    os = (OutputStream)this.blobGetOutStreamMethod.invoke((Object)bObj, new Object[0]);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw new IOException("Reflection error");
                }
                try {
                    int nChar;
                    byte[] buffer = new byte[4096];
                    while ((nChar = is.read(buffer)) != -1) {
                        os.write(buffer, 0, nChar);
                    }
                }
                finally {
                    os.flush();
                    os.close();
                }
                Object var18_20 = null;
                if (tempFile == null) break block36;
            }
            catch (Throwable throwable) {
                Object var18_21 = null;
                if (tempFile != null) {
                    try {
                        is.close();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    is = null;
                    if (!tempFile.delete()) {
                        this.logger.log((Object)("Could not delete file \"" + tempFile.getAbsolutePath() + "\""));
                    }
                }
                try {
                    this.close(statement);
                    Object var21_26 = null;
                    if (is == null) throw throwable;
                }
                catch (Throwable throwable2) {
                    Object var21_27 = null;
                    if (is == null) throw throwable2;
                    try {
                        is.close();
                        throw throwable2;
                    }
                    catch (IOException ioe) {
                        this.logger.log((Object)"Could not close stream", (Throwable)ioe, LOG_CHANNEL, 7);
                    }
                    throw throwable2;
                }
                try {
                    is.close();
                    throw throwable;
                }
                catch (IOException ioe) {
                    this.logger.log((Object)"Could not close stream", (Throwable)ioe, LOG_CHANNEL, 7);
                }
                throw throwable;
            }
            try {
                is.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            is = null;
            if (!tempFile.delete()) {
                this.logger.log((Object)("Could not delete file \"" + tempFile.getAbsolutePath() + "\""));
            }
        }
        try {
            this.close(statement);
            Object var21_24 = null;
            if (is == null) return;
        }
        catch (Throwable throwable) {
            Object var21_25 = null;
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (IOException ioe) {
                this.logger.log((Object)"Could not close stream", (Throwable)ioe, LOG_CHANNEL, 7);
            }
            throw throwable;
        }
        try {
            is.close();
            return;
        }
        catch (IOException ioe) {
            this.logger.log((Object)"Could not close stream", (Throwable)ioe, LOG_CHANNEL, 7);
        }
    }

    protected static String normalizeSequenceName(String sequenceName) {
        return sequenceName.replace('-', '_').toUpperCase() + "_SEQ";
    }

    public boolean isSequenceSupported(Connection conn) {
        return true;
    }

    public boolean createSequence(Connection conn, String sequenceName) throws ServiceAccessException {
        String query = "CREATE SEQUENCE \"" + OracleRDBMSAdapter.normalizeSequenceName(sequenceName) + "\"";
        PreparedStatement statement = null;
        try {
            statement = conn.prepareStatement(query);
            statement.executeUpdate();
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            throw new ServiceAccessException(this.service, (Throwable)e);
        }
        finally {
            this.close(statement);
        }
    }

    public long nextSequenceValue(Connection conn, String sequenceName) throws ServiceAccessException {
        long l;
        String selectQuery = "SELECT \"" + OracleRDBMSAdapter.normalizeSequenceName(sequenceName) + "\".nextval FROM DUAL";
        PreparedStatement selectStatement = null;
        ResultSet res = null;
        try {
            long value;
            selectStatement = conn.prepareStatement(selectQuery);
            res = selectStatement.executeQuery();
            if (!res.next()) {
                throw new ServiceAccessException(this.service, "Could not increment sequence " + sequenceName);
            }
            l = value = res.getLong(1);
        }
        catch (SQLException e) {
            try {
                throw new ServiceAccessException(this.service, (Throwable)e);
            }
            catch (Throwable throwable) {
                this.close(selectStatement, res);
                throw throwable;
            }
        }
        this.close(selectStatement, res);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sequenceExists(Connection conn, String sequenceName) throws ServiceAccessException {
        PreparedStatement selectStatement = null;
        ResultSet res = null;
        try {
            selectStatement = conn.prepareStatement("ALTER SEQUENCE  \"" + OracleRDBMSAdapter.normalizeSequenceName(sequenceName) + "\" INCREMENT BY 1");
            res = selectStatement.executeQuery();
            boolean bl = true;
            this.close(selectStatement, res);
            return bl;
        }
        catch (SQLException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.close(selectStatement, res);
        }
    }
}

