/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.store.uPortal;

import fr.univrennes1.cri.util.cacheManagement.CacheManager;
import fr.univrennes1.cri.util.cacheManagement.Cacheable;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import javax.xml.rpc.ServiceException;
import localhost.uPortal.services.PortalGroups.PortalGroups;
import localhost.uPortal.services.PortalGroups.PortalGroupsServiceLocator;
import org.apache.slide.authenticate.CredentialsToken;
import org.apache.slide.common.AbstractXAService;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.ServiceConnectionFailedException;
import org.apache.slide.common.ServiceDisconnectionFailedException;
import org.apache.slide.common.ServiceInitializationFailedException;
import org.apache.slide.common.ServiceParameterErrorException;
import org.apache.slide.common.ServiceParameterMissingException;
import org.apache.slide.common.ServiceResetFailedException;
import org.apache.slide.common.SlideToken;
import org.apache.slide.common.Uri;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.NodeRevisionContent;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.content.RevisionAlreadyExistException;
import org.apache.slide.content.RevisionDescriptorNotFoundException;
import org.apache.slide.content.RevisionNotFoundException;
import org.apache.slide.lock.LockTokenNotFoundException;
import org.apache.slide.lock.NodeLock;
import org.apache.slide.security.NodePermission;
import org.apache.slide.store.ContentStore;
import org.apache.slide.store.LockStore;
import org.apache.slide.store.NodeStore;
import org.apache.slide.store.RevisionDescriptorStore;
import org.apache.slide.store.RevisionDescriptorsStore;
import org.apache.slide.store.SecurityStore;
import org.apache.slide.store.uPortal.CachedGroupName;
import org.apache.slide.store.uPortal.CachedObjectNode;
import org.apache.slide.store.uPortal.CachedUserInformation;
import org.apache.slide.structure.ObjectAlreadyExistsException;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.structure.SubjectNode;

public class UPortalRolesStore
extends AbstractXAService
implements ContentStore,
LockStore,
NodeStore,
RevisionDescriptorStore,
RevisionDescriptorsStore,
SecurityStore {
    public static final String CACHE_NAME = (class$org$apache$slide$store$uPortal$UPortalRolesStore == null ? (class$org$apache$slide$store$uPortal$UPortalRolesStore = UPortalRolesStore.class$("org.apache.slide.store.uPortal.UPortalRolesStore")) : class$org$apache$slide$store$uPortal$UPortalRolesStore).getName();
    public static final String CACHE_OBJECT_PREFIX = "object: ";
    public static final String CACHE_DESCRIPTOR_PREFIX = "descriptor: ";
    public static final String JNDI_PROPERTY_PREFIX = "java.naming";
    public static final String PARAM_UPORTAL_WEBSERVICE_URL = "uportal.webservice.url";
    public static final String PARAM_UPORTAL_STORE_CACHE_DISABLECACHE = "uportal.store.cache.disableCache";
    public static final String PARAM_UPORTAL_STORE_CACHE_SLEEPINGTIME = "uportal.store.cache.cleaningThreadSleepingTimeInMinutes";
    public static final String PARAM_UPORTAL_STORE_CACHE_USERINFO_MTL = "uportal.store.cache.cachedUserInformationMinutesTolive";
    public static final String PARAM_UPORTAL_STORE_CACHE_OBJECTNODE_MTL = "uportal.store.cache.cachedUserInformationMinutesTolive";
    public static final String PARAM_LOG_VALIDATION_ERRORS = "log.validationerrors";
    public static final String LOG_CHANNEL = (class$org$apache$slide$store$uPortal$UPortalRolesStore == null ? (class$org$apache$slide$store$uPortal$UPortalRolesStore = UPortalRolesStore.class$("org.apache.slide.store.uPortal.UPortalRolesStore")) : class$org$apache$slide$store$uPortal$UPortalRolesStore).getName();
    protected boolean logValidationErrors = false;
    public boolean disableCache;
    public int sleepingTime;
    public int userInfoMinutesToLive;
    public int objectNodeMinutesToLive;
    public CacheManager cacheManager;
    private String usersPath;
    private String rolesPath;
    private String roleScope;
    private PortalGroups uPortalWSStore;
    private String uPortalWebserviceUrl;
    private String connectedUser;
    private Vector groupsOfConnectedUserVector;
    private Enumeration groupsOfConnectedUserEnumeration;
    private Vector nestedGroupsOfCurrentGroupVector;
    private Enumeration nestedGroupsOfCurrentGroupEnumeration;
    private Vector rootGroupsVector;
    private Enumeration rootGroupsEnumeration;
    static /* synthetic */ Class class$org$apache$slide$store$uPortal$UPortalRolesStore;

    private String getPrincipal(Uri uri) {
        Principal principal;
        CredentialsToken credentialsToken;
        String resultPrincipal = "";
        SlideToken slideToken = uri.getToken();
        if (slideToken != null && (credentialsToken = slideToken.getCredentialsToken()) != null && (principal = credentialsToken.getPrincipal()) != null) {
            resultPrincipal = principal.getName();
        }
        return resultPrincipal;
    }

    private String buildGroupHierarchy(Vector group) {
        if (group == null) {
            return new String();
        }
        Enumeration enumeration = group.elements();
        StringBuffer result = new StringBuffer();
        String nextElement = (String)enumeration.nextElement();
        while (nextElement != null) {
            result.append(nextElement);
            if (enumeration.hasMoreElements()) {
                nextElement = (String)enumeration.nextElement();
                result.append("/");
                continue;
            }
            nextElement = null;
        }
        return result.toString();
    }

    private String convertVectorIntoString(Vector v) {
        String nextElement;
        if (v == null) {
            return new String("");
        }
        StringBuffer result = new StringBuffer();
        Enumeration enumeration = v.elements();
        if (enumeration.hasMoreElements()) {
            nextElement = (String)enumeration.nextElement();
        } else {
            return new String("");
        }
        while (nextElement != null) {
            result.append(nextElement);
            if (enumeration.hasMoreElements()) {
                nextElement = (String)enumeration.nextElement();
                result.append("|");
                continue;
            }
            nextElement = null;
        }
        return result.toString();
    }

    private String convertVectorOfVectorIntoString(Vector v) {
        Vector nextElement;
        if (v == null) {
            return new String("");
        }
        StringBuffer result = new StringBuffer();
        Enumeration enumeration = v.elements();
        if (enumeration.hasMoreElements()) {
            nextElement = (Vector)enumeration.nextElement();
        } else {
            return new String("");
        }
        while (nextElement != null) {
            Enumeration enum2 = nextElement.elements();
            String nextElement2 = (String)enum2.nextElement();
            while (nextElement2 != null) {
                result.append(nextElement2);
                if (enum2.hasMoreElements()) {
                    nextElement2 = (String)enum2.nextElement();
                    result.append("|");
                    continue;
                }
                nextElement2 = null;
            }
            if (enumeration.hasMoreElements()) {
                nextElement = (Vector)enumeration.nextElement();
                result.append(" - ");
                continue;
            }
            nextElement = null;
        }
        return result.toString();
    }

    public void initialize(NamespaceAccessToken token) throws ServiceInitializationFailedException {
        this.getLogger().log((Object)(((Object)((Object)this)).getClass().getName() + ":initialize"), LOG_CHANNEL, 6);
        super.initialize(token);
        this.usersPath = token.getNamespaceConfig().getUsersPath();
        this.rolesPath = token.getNamespaceConfig().getRolesPath();
        this.getLogger().log((Object)(((Object)((Object)this)).getClass().getName() + ":initialize:usersPath=" + this.usersPath), LOG_CHANNEL, 6);
        this.getLogger().log((Object)(((Object)((Object)this)).getClass().getName() + ":initialize:rolesPath=" + this.rolesPath), LOG_CHANNEL, 6);
    }

    public void setParameters(Hashtable parameters) throws ServiceParameterErrorException, ServiceParameterMissingException {
        this.getLogger().log((Object)(((Object)((Object)this)).getClass().getName() + ":setParameters"), LOG_CHANNEL, 6);
        String tmp = (String)parameters.get(PARAM_UPORTAL_STORE_CACHE_DISABLECACHE);
        if (!tmp.equalsIgnoreCase("true") && !tmp.equalsIgnoreCase("false")) {
            tmp = "false";
        }
        Boolean bool = Boolean.valueOf(tmp);
        this.disableCache = bool;
        tmp = (String)parameters.get(PARAM_UPORTAL_STORE_CACHE_SLEEPINGTIME);
        this.sleepingTime = Integer.parseInt(tmp);
        if (this.sleepingTime < 1) {
            this.sleepingTime = 1;
        }
        this.sleepingTime = this.sleepingTime * 60 * 1000;
        tmp = (String)parameters.get("uportal.store.cache.cachedUserInformationMinutesTolive");
        this.userInfoMinutesToLive = Integer.parseInt(tmp);
        if (this.userInfoMinutesToLive < 1) {
            this.userInfoMinutesToLive = 1;
        }
        tmp = (String)parameters.get("uportal.store.cache.cachedUserInformationMinutesTolive");
        this.objectNodeMinutesToLive = Integer.parseInt(tmp);
        if (this.objectNodeMinutesToLive < 1) {
            this.objectNodeMinutesToLive = 1;
        }
        if (!this.disableCache) {
            this.getLogger().log((Object)(((Object)((Object)this)).getClass().getName() + ":setParameters:starting cache manager"), LOG_CHANNEL, 6);
            this.getLogger().log((Object)(((Object)((Object)this)).getClass().getName() + ":setParameters:" + "uportal.store.cache.cachedUserInformationMinutesTolive" + "=" + this.userInfoMinutesToLive), LOG_CHANNEL, 6);
            this.getLogger().log((Object)(((Object)((Object)this)).getClass().getName() + ":setParameters:" + "uportal.store.cache.cachedUserInformationMinutesTolive" + "=" + this.objectNodeMinutesToLive), LOG_CHANNEL, 6);
            this.getLogger().log((Object)(((Object)((Object)this)).getClass().getName() + ":setParameters:" + PARAM_UPORTAL_STORE_CACHE_SLEEPINGTIME + "=" + this.sleepingTime), LOG_CHANNEL, 6);
            this.cacheManager = new CacheManager(this.sleepingTime);
        } else {
            this.getLogger().log((Object)(((Object)((Object)this)).getClass().getName() + ":setParameters:cache manager not started"), LOG_CHANNEL, 6);
        }
        this.uPortalWebserviceUrl = (String)parameters.get(PARAM_UPORTAL_WEBSERVICE_URL);
        if (this.uPortalWebserviceUrl == null || this.uPortalWebserviceUrl.length() == 0) {
            this.getLogger().log((Object)(((Object)((Object)this)).getClass().getName() + ":no value set for " + PARAM_UPORTAL_WEBSERVICE_URL), LOG_CHANNEL, 1);
        } else {
            this.getLogger().log((Object)(((Object)((Object)this)).getClass().getName() + ":setParameters:" + PARAM_UPORTAL_WEBSERVICE_URL + "=" + this.uPortalWebserviceUrl), LOG_CHANNEL, 6);
        }
        this.getLogger().log((Object)(((Object)((Object)this)).getClass().getName() + "setParameters:connecting uPortalWSStore..."), LOG_CHANNEL, 6);
        try {
            this.uPortalWSStore = new PortalGroupsServiceLocator().getPortalGroups(new URL(this.uPortalWebserviceUrl));
        }
        catch (ServiceException e) {
            this.getLogger().log((Object)(((Object)((Object)this)).getClass().getName() + ":setParameters:" + e.getMessage()), LOG_CHANNEL, 1);
        }
        catch (MalformedURLException e) {
            this.getLogger().log((Object)(((Object)((Object)this)).getClass().getName() + ":setParameters:" + e.getMessage()), LOG_CHANNEL, 1);
        }
        String temp = null;
        temp = (String)parameters.get(PARAM_LOG_VALIDATION_ERRORS);
        if ("true".equalsIgnoreCase(temp)) {
            this.logValidationErrors = true;
        }
    }

    public boolean cacheResults() {
        return false;
    }

    public void storeObject(Uri uri, ObjectNode object) throws ServiceAccessException, ObjectNotFoundException {
    }

    public void createObject(Uri uri, ObjectNode object) throws ServiceAccessException, ObjectAlreadyExistsException {
    }

    public void removeObject(Uri uri, ObjectNode object) throws ServiceAccessException, ObjectNotFoundException {
    }

    public ObjectNode retrieveObject(Uri uri) throws ServiceAccessException, ObjectNotFoundException {
        this.getLogger().log((Object)(((Object)((Object)this)).getClass().getName() + ":retrieveObject:uri=" + uri), LOG_CHANNEL, 6);
        if (!this.disableCache) {
            this.getLogger().log((Object)(((Object)((Object)this)).getClass().getName() + ":retrieveObject:..getting node " + uri.toString() + " from the cache"), LOG_CHANNEL, 6);
            CachedObjectNode cachedObjectNode = (CachedObjectNode)CacheManager.getCache((Object)uri.toString());
            if (cachedObjectNode != null) {
                this.getLogger().log((Object)(((Object)((Object)this)).getClass().getName() + ":retrieveObject:....node " + uri.toString() + " found in the cache"), LOG_CHANNEL, 6);
                return cachedObjectNode.getObjectNode();
            }
            this.getLogger().log((Object)(((Object)((Object)this)).getClass().getName() + ":retrieveObject:....node " + uri.toString() + " NOT found in the cache"), LOG_CHANNEL, 6);
        }
        this.rootGroupsVector = new Vector();
        try {
            this.rootGroupsVector.add(this.uPortalWSStore.getRoot());
            this.getLogger().log((Object)(((Object)((Object)this)).getClass().getName() + ":retrieveObject:..portal root group=" + this.convertVectorIntoString(this.rootGroupsVector)), LOG_CHANNEL, 7);
        }
        catch (RemoteException e) {
            this.getLogger().log((Object)(((Object)((Object)this)).getClass().getName() + ":retrieveObject:" + e.getMessage()), LOG_CHANNEL, 1);
        }
        String key = this.getObjectNameFromUri(uri);
        this.nestedGroupsOfCurrentGroupVector = new Vector();
        try {
            this.nestedGroupsOfCurrentGroupVector = this.uPortalWSStore.getNestedGroupsOfGroup(key);
            this.getLogger().log((Object)(((Object)((Object)this)).getClass().getName() + ":retrieveObject:..nested group keys=" + this.convertVectorIntoString(this.nestedGroupsOfCurrentGroupVector)), LOG_CHANNEL, 7);
        }
        catch (RemoteException e) {
            this.getLogger().log((Object)(((Object)((Object)this)).getClass().getName() + ":retrieveObject:" + e.getMessage()), LOG_CHANNEL, 1);
        }
        if (uri.isStoreRoot()) {
            this.getLogger().log((Object)(((Object)((Object)this)).getClass().getName() + ":retrieveObject:..group " + key + " is store root"), LOG_CHANNEL, 7);
            this.nestedGroupsOfCurrentGroupVector = this.rootGroupsVector;
        }
        SubjectNode myObjectNode = this.getObject(uri);
        return myObjectNode;
    }

    public void createRevisionDescriptor(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException {
    }

    public void storeRevisionDescriptor(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException, RevisionDescriptorNotFoundException {
    }

    public void removeRevisionDescriptor(Uri uri, NodeRevisionNumber revisionNumber) throws ServiceAccessException {
    }

    public NodeRevisionDescriptor retrieveRevisionDescriptor(Uri uri, NodeRevisionNumber revisionNumber) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        NodeRevisionDescriptor temp;
        this.getLogger().log((Object)(((Object)((Object)this)).getClass().getName() + ":retrieveRevisionDescriptor:uri=" + uri.toString()), LOG_CHANNEL, 6);
        this.groupsOfConnectedUserVector = null;
        this.groupsOfConnectedUserEnumeration = null;
        this.nestedGroupsOfCurrentGroupVector = null;
        this.nestedGroupsOfCurrentGroupEnumeration = null;
        this.roleScope = uri.getScope().toString();
        this.getLogger().log((Object)(((Object)((Object)this)).getClass().getName() + ":retrieveRevisionDescriptor:role scope=" + this.roleScope.toString()), LOG_CHANNEL, 7);
        this.connectedUser = this.getPrincipal(uri);
        this.getLogger().log((Object)(((Object)((Object)this)).getClass().getName() + ":retrieveRevisionDescriptor:connected user=" + this.connectedUser), LOG_CHANNEL, 6);
        Cacheable cachedUserInformation = null;
        if (!this.disableCache && this.connectedUser != null && !this.connectedUser.equals("")) {
            this.getLogger().log((Object)(((Object)((Object)this)).getClass().getName() + ":retrieveRevisionDescriptor:trying to find info. in the cache for user " + this.connectedUser), LOG_CHANNEL, 6);
            cachedUserInformation = CacheManager.getCache((Object)this.connectedUser);
        }
        if (cachedUserInformation == null && this.connectedUser != null && !this.connectedUser.equals("") || this.disableCache) {
            this.getLogger().log((Object)(((Object)((Object)this)).getClass().getName() + ":retrieveRevisionDescriptor:no info. in the cache for user " + this.connectedUser), LOG_CHANNEL, 6);
            try {
                this.groupsOfConnectedUserVector = this.uPortalWSStore.getGroupsOfUser(this.connectedUser);
                this.getLogger().log((Object)(((Object)((Object)this)).getClass().getName() + ":retrieveRevisionDescriptor:groups of connected user=" + this.convertVectorOfVectorIntoString(this.groupsOfConnectedUserVector)), LOG_CHANNEL, 7);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            if (!this.disableCache) {
                this.getLogger().log((Object)(((Object)((Object)this)).getClass().getName() + ":retrieveRevisionDescriptor:caching gathered info. for user " + this.connectedUser), LOG_CHANNEL, 6);
                CacheManager.putCache((Cacheable)new CachedUserInformation(this.groupsOfConnectedUserVector, this.connectedUser, this.userInfoMinutesToLive));
            }
        } else if (cachedUserInformation != null) {
            this.getLogger().log((Object)(((Object)((Object)this)).getClass().getName() + ":retrieveRevisionDescriptor:info. for user " + this.connectedUser + " found in the cache"), LOG_CHANNEL, 6);
            this.groupsOfConnectedUserVector = ((CachedUserInformation)cachedUserInformation).getGroupsOfUser();
        }
        if (this.groupsOfConnectedUserVector != null) {
            temp = new Vector();
            this.groupsOfConnectedUserEnumeration = this.groupsOfConnectedUserVector.elements();
            while (this.groupsOfConnectedUserEnumeration.hasMoreElements()) {
                Vector currentGroupVector = (Vector)this.groupsOfConnectedUserEnumeration.nextElement();
                temp.add(this.buildGroupHierarchy(currentGroupVector));
            }
            this.groupsOfConnectedUserEnumeration = temp.elements();
        }
        temp = this.getRevisionDescriptor(uri);
        return temp;
    }

    public NodeRevisionDescriptors retrieveRevisionDescriptors(Uri uri) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        this.getLogger().log((Object)(((Object)((Object)this)).getClass().getName() + ":retrieveRevisionDescriptors:uri=" + uri.toString()), LOG_CHANNEL, 7);
        NodeRevisionNumber rev = new NodeRevisionNumber(1, 0);
        Hashtable<String, NodeRevisionNumber> workingRevisions = new Hashtable<String, NodeRevisionNumber>();
        workingRevisions.put("1.0", rev);
        Hashtable<String, NodeRevisionNumber> latestRevisionNumbers = new Hashtable<String, NodeRevisionNumber>();
        latestRevisionNumbers.put("1.0", rev);
        Vector<NodeRevisionNumber> branches = new Vector<NodeRevisionNumber>();
        branches.add(rev);
        Hashtable<String, Vector<NodeRevisionNumber>> branchNames = new Hashtable<String, Vector<NodeRevisionNumber>>();
        branchNames.put("main", branches);
        return new NodeRevisionDescriptors(uri.toString(), rev, workingRevisions, latestRevisionNumbers, branchNames, false);
    }

    public void createRevisionDescriptors(Uri uri, NodeRevisionDescriptors revisionDescriptors) throws ServiceAccessException {
    }

    public void storeRevisionDescriptors(Uri uri, NodeRevisionDescriptors revisionDescriptors) throws ServiceAccessException, RevisionDescriptorNotFoundException {
    }

    public void removeRevisionDescriptors(Uri uri) throws ServiceAccessException {
    }

    public NodeRevisionContent retrieveRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException, RevisionNotFoundException {
        NodeRevisionContent nrc = new NodeRevisionContent();
        nrc.setContent(new char[0]);
        return nrc;
    }

    public void createRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws ServiceAccessException, RevisionAlreadyExistException {
    }

    public void storeRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws ServiceAccessException, RevisionNotFoundException {
    }

    public void removeRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException {
    }

    public void grantPermission(Uri uri, NodePermission permission) throws ServiceAccessException {
    }

    public void revokePermission(Uri uri, NodePermission permission) throws ServiceAccessException {
    }

    public void revokePermissions(Uri uri) throws ServiceAccessException {
    }

    public Enumeration enumeratePermissions(Uri uri) throws ServiceAccessException {
        Vector<NodePermission> permissions = new Vector<NodePermission>();
        permissions.add(new NodePermission(uri.toString(), "all", "/actions/read"));
        return permissions.elements();
    }

    public void putLock(Uri uri, NodeLock lock) throws ServiceAccessException {
    }

    public void renewLock(Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
    }

    public void removeLock(Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
    }

    public void killLock(Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
    }

    public Enumeration enumerateLocks(Uri uri) throws ServiceAccessException {
        return new Vector().elements();
    }

    protected SubjectNode getObject(Uri uri) throws ObjectNotFoundException, ServiceAccessException {
        this.getLogger().log((Object)(((Object)((Object)this)).getClass().getName() + ":getObject:uri=" + uri.toString()), LOG_CHANNEL, 7);
        Uri parentUri = uri.getParentUri();
        String objectName = this.getObjectNameFromUri(uri);
        this.getLogger().log((Object)(((Object)((Object)this)).getClass().getName() + ":getObject:parentUri=" + parentUri.toString()), LOG_CHANNEL, 7);
        this.getLogger().log((Object)(((Object)((Object)this)).getClass().getName() + ":getObject:objectName=" + objectName), LOG_CHANNEL, 7);
        Vector<Object> parentBindings = new Vector<Object>();
        Vector<ObjectNode.Binding> childBindings = new Vector<ObjectNode.Binding>();
        if (!uri.toString().equals("/")) {
            parentBindings.add(new ObjectNode.Binding(objectName, parentUri.toString()));
        }
        this.getLogger().log((Object)(((Object)((Object)this)).getClass().getName() + ":getObject:..creating ChildBindings for " + uri.toString()), LOG_CHANNEL, 7);
        childBindings = new Vector();
        if (this.nestedGroupsOfCurrentGroupVector != null) {
            this.nestedGroupsOfCurrentGroupEnumeration = this.nestedGroupsOfCurrentGroupVector.elements();
            while (this.nestedGroupsOfCurrentGroupEnumeration.hasMoreElements()) {
                String element;
                String bindingName = element = (String)this.nestedGroupsOfCurrentGroupEnumeration.nextElement();
                String bindingUuri = uri.toString() + "/" + element;
                this.getLogger().log((Object)(((Object)((Object)this)).getClass().getName() + ":getObject:....adding ChildBinding - bindingName=" + bindingName + " bindingUuri=" + bindingUuri), LOG_CHANNEL, 7);
                ObjectNode.Binding currentChildBinding = new ObjectNode.Binding(bindingName, bindingUuri);
                childBindings.add(currentChildBinding);
            }
        } else {
            this.getLogger().log((Object)(((Object)((Object)this)).getClass().getName() + ":getObject:..no ChildBindings for " + uri.toString()), LOG_CHANNEL, 7);
        }
        String bindingName = this.getObjectNameFromUri(uri);
        String bindingUuri = this.getObjectPathFromUri(uri);
        ObjectNode.ParentBinding currentParentBinding = new ObjectNode.ParentBinding(bindingName, bindingUuri);
        parentBindings.add(currentParentBinding);
        this.getLogger().log((Object)(((Object)((Object)this)).getClass().getName() + ":getObject:..creating node " + uri.toString()), LOG_CHANNEL, 6);
        SubjectNode node = new SubjectNode(uri.toString(), childBindings, parentBindings, new Vector());
        node.setUri(uri.toString());
        if (!this.disableCache) {
            this.getLogger().log((Object)(((Object)((Object)this)).getClass().getName() + ":getObject:..caching the node " + uri.toString()), LOG_CHANNEL, 6);
            CacheManager.putCache((Cacheable)new CachedObjectNode((ObjectNode)node, uri.toString(), this.objectNodeMinutesToLive));
        }
        return node;
    }

    protected NodeRevisionDescriptor getRevisionDescriptor(Uri uri) throws RevisionDescriptorNotFoundException, ServiceAccessException {
        this.getLogger().log((Object)(((Object)((Object)this)).getClass().getName() + ":getRevisionDescriptor:uri=" + uri.toString()), LOG_CHANNEL, 7);
        String groupKey = this.getObjectNameFromUri(uri);
        String groupName = null;
        if (!this.disableCache) {
            this.getLogger().log((Object)(((Object)((Object)this)).getClass().getName() + ":getRevisionDescriptor:..trying to find the group name of the group " + groupKey + " in the cache"), LOG_CHANNEL, 6);
            CachedGroupName cachedGroupName = (CachedGroupName)CacheManager.getCache((Object)groupKey);
            if (cachedGroupName == null) {
                this.getLogger().log((Object)(((Object)((Object)this)).getClass().getName() + ":getRevisionDescriptor:....group name of the group " + groupKey + " NOT found in the cache"), LOG_CHANNEL, 6);
            } else {
                this.getLogger().log((Object)(((Object)((Object)this)).getClass().getName() + ":getRevisionDescriptor:....group name of the group " + groupKey + " found in the cache"), LOG_CHANNEL, 6);
                groupName = cachedGroupName.getGroupName();
            }
        }
        if (groupName == null) {
            try {
                this.getLogger().log((Object)(((Object)((Object)this)).getClass().getName() + ":getRevisionDescriptor:..getting the group name of the group " + groupKey), LOG_CHANNEL, 7);
                groupName = this.uPortalWSStore.getGroupName(groupKey);
                if (groupName == null || groupName.equals("null")) {
                    groupName = groupKey;
                }
                if (groupKey != null) {
                    this.getLogger().log((Object)(((Object)((Object)this)).getClass().getName() + ":getRevisionDescriptor:....key=" + groupKey + " name=" + groupName), LOG_CHANNEL, 7);
                }
                if (!this.disableCache) {
                    this.getLogger().log((Object)(((Object)((Object)this)).getClass().getName() + ":getRevisionDescriptor:..caching the group name of the group " + groupKey + " name=" + groupName), LOG_CHANNEL, 6);
                    CacheManager.putCache((Cacheable)new CachedGroupName(groupKey, groupName, this.objectNodeMinutesToLive));
                }
            }
            catch (RemoteException e) {
                this.getLogger().log((Object)(((Object)((Object)this)).getClass().getName() + ":getRevisionDescriptor:" + e.getMessage()), LOG_CHANNEL, 1);
            }
        }
        Hashtable<String, NodeProperty> props = new Hashtable<String, NodeProperty>();
        StringBuffer instantGroupMemberSet = new StringBuffer();
        String resourceType = "<collection/>";
        if (!uri.isStoreRoot()) {
            resourceType = resourceType + "<principal/>";
        }
        props.put("DAV:resourcetype", new NodeProperty("resourcetype", (Object)resourceType, "DAV:", "", false));
        props.put("DAV:displayname", new NodeProperty("displayname", (Object)groupName, "DAV:", "", false));
        if (!uri.isStoreRoot() && this.connectedUser != null && !this.connectedUser.equals("")) {
            boolean isGms;
            this.getLogger().log((Object)(((Object)((Object)this)).getClass().getName() + ":getRevisionDescriptor:..finding if " + this.connectedUser + " is member of " + uri), LOG_CHANNEL, 7);
            boolean uriIsInGroupsOfConnectedUser = false;
            while (this.groupsOfConnectedUserEnumeration != null && this.groupsOfConnectedUserEnumeration.hasMoreElements() && !uriIsInGroupsOfConnectedUser) {
                String currentRole = this.roleScope + "/" + this.groupsOfConnectedUserEnumeration.nextElement();
                if (currentRole.indexOf(uri.toString()) != -1) {
                    uriIsInGroupsOfConnectedUser = true;
                }
                this.getLogger().log((Object)(((Object)((Object)this)).getClass().getName() + ":getRevisionDescriptor:....uri=" + uri), LOG_CHANNEL, 7);
                this.getLogger().log((Object)(((Object)((Object)this)).getClass().getName() + ":getRevisionDescriptor:....current user role=" + currentRole), LOG_CHANNEL, 7);
                this.getLogger().log((Object)(((Object)((Object)this)).getClass().getName() + ":getRevisionDescriptor:....user is member of " + uri + "=" + uriIsInGroupsOfConnectedUser), LOG_CHANNEL, 7);
            }
            if (uriIsInGroupsOfConnectedUser) {
                this.getLogger().log((Object)(((Object)((Object)this)).getClass().getName() + ":getRevisionDescriptor:..user " + this.connectedUser + " is member of " + uri), LOG_CHANNEL, 7);
                instantGroupMemberSet.append("<D:href xmlns:D='DAV:'>");
                instantGroupMemberSet.append(this.usersPath + "/" + this.connectedUser);
                instantGroupMemberSet.append("</D:href>");
                this.getLogger().log((Object)(((Object)((Object)this)).getClass().getName() + ":getRevisionDescriptor:..building instant group-member-set for " + uri), LOG_CHANNEL, 7);
                this.getLogger().log((Object)(((Object)((Object)this)).getClass().getName() + ":getRevisionDescriptor:....instantGroupMemberSet=" + instantGroupMemberSet), LOG_CHANNEL, 7);
            }
            if (isGms = uriIsInGroupsOfConnectedUser) {
                this.getLogger().log((Object)(((Object)((Object)this)).getClass().getName() + "getRevisionDescriptor:adding property \"group-member-set\" in namespace"), LOG_CHANNEL, 7);
                props.put("DAV:group-member-set", new NodeProperty("group-member-set", (Object)instantGroupMemberSet.toString(), "DAV:"));
            }
        }
        NodeRevisionDescriptor descriptor = new NodeRevisionDescriptor(new NodeRevisionNumber(1, 0), "main", new Vector(), props);
        return descriptor;
    }

    protected String getObjectNameFromUri(Uri uri) {
        String objectName = uri.toString().substring(uri.toString().lastIndexOf("/") + 1);
        return objectName;
    }

    protected String getObjectPathFromUri(Uri uri) {
        String objectPath = uri.toString().substring(0, uri.toString().lastIndexOf("/"));
        return objectPath;
    }

    protected boolean validatePathName(String name) {
        boolean valid = true;
        if (name.indexOf("/") > -1) {
            valid = false;
            if (this.logValidationErrors) {
                this.getLogger().log((Object)(((Object)((Object)this)).getClass().getName() + ": Skipping child with name \"" + name + "\" because " + "it contains a /."), LOG_CHANNEL, 2);
            }
        }
        return valid;
    }

    public void connect() throws ServiceConnectionFailedException {
    }

    public void disconnect() throws ServiceDisconnectionFailedException {
    }

    public void reset() throws ServiceResetFailedException {
    }

    public boolean isConnected() throws ServiceAccessException {
        return false;
    }

    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    public boolean setTransactionTimeout(int arg0) throws XAException {
        return false;
    }

    public boolean isSameRM(XAResource arg0) throws XAException {
        return false;
    }

    public Xid[] recover(int arg0) throws XAException {
        return null;
    }

    public int prepare(Xid arg0) throws XAException {
        return 0;
    }

    public void forget(Xid arg0) throws XAException {
    }

    public void rollback(Xid arg0) throws XAException {
    }

    public void end(Xid arg0, int arg1) throws XAException {
    }

    public void start(Xid arg0, int arg1) throws XAException {
    }

    public void commit(Xid arg0, boolean arg1) throws XAException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

