/*
 * HomedirCreation.java,v 1.0 29/06/2004
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)
 * Classes: Config
 * Original Author: Thomas BELLEMBOIS
 */

package org.esupportail.portal.utils.injac.homeDirCreation.config;

/**
 * @author : Thomas BELLEMBOIS
 * date : 29 juin 2004
 */
import java.io.IOException;
import java.net.URL;
import org.apache.commons.digester.*;
import org.esupportail.portal.utils.injac.homeDirCreation.exception.ConfigException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.apache.log4j.*;

public class Config {
	
	private String ldapUrl; 			// LDAP URL
	private String ldapPort;            // LDAP port
	private String ldapBaseDn;          // LDAP baseDn
	private String ldapScope;           // LDAP scope
	private String ldapPrincipal;		// LDAP pricipal
	private String ldapCredential;		// LDAP credential
	//	 DEPRECATED
	//private String ldapRequestFilter;   // LDAP request filter
	private String ldapUserUidAttribut; // The attribut of users UIDs in the LDAP directory
	private String ldapMaxResults;		// Max number of results returned by the LDAP directory
	
	private String webdavServerUrl;		 // WebDav server URL
	private String webdavServerLogin;	 // WebDav server login
	private String webdavServerPassword; // WebDav server password
	// DEPRECATED
	//private String webdavServerUsersRole;//Role assigned to users
	
	private String userDirectoryRootDirectory; // directory where users are stored on the WebDav server

	private String roleDirectoryRootDirectory; 			// directory where roles are stored on the WebDav server
	private String roleDirectoryLocalRolesDirectory;	// directory where local roles are stored on the WebDav server
	private String roleDirectoryUPortalRolesDirectory;  // directory where uPortal roles are stored on the WebDav server
	
	private String directoriesStructureRootDirectory; // Root directory to create the directories on the WebDav server
	private String directoriesStructureHashType;	  // Hash type to create the directories on the WebDav server
	
	private static Config singleton = null;
	
	private Logger logger = Logger.getLogger("HomedirCreationConfig");
	
	private Config() throws ConfigException{
		
		//  Getting the configuration file
		Class requestingClass = this.getClass();
		URL resourceURL = requestingClass.getResource("/properties/config.xml");
		if (resourceURL == null){
			throw new ConfigException("Config","init","Configuration file not found");
		}
		
		//  Creating a Digester
		Digester dig = new Digester();
		dig.push(this);
		
		// Registering the entries of the configuration file
		dig.addCallMethod("root/ldapDirectory","configLdap",8);
		dig.addCallParam("root/ldapDirectory",0,"ldapUrl");
		dig.addCallParam("root/ldapDirectory",1,"port");
		dig.addCallParam("root/ldapDirectory",2,"baseDn");
		dig.addCallParam("root/ldapDirectory",3,"scope");
		// DEPRECATED
		//dig.addCallParam("root/ldapDirectory",4,"filter");
		dig.addCallParam("root/ldapDirectory",4,"userUidAttribut");
		dig.addCallParam("root/ldapDirectory",5,"maxResults");
		dig.addCallParam("root/ldapDirectory",6,"principal");
		dig.addCallParam("root/ldapDirectory",7,"credential");
		
		dig.addCallMethod("root/webdavServer","configWebdavServer",3);
		dig.addCallParam("root/webdavServer",0,"url");
		dig.addCallParam("root/webdavServer",1,"login");
		dig.addCallParam("root/webdavServer",2,"password");
		// DEPRECATED
		//dig.addCallParam("root/webdavServer",3,"usersRole");
		
		dig.addCallMethod("root/directoriesStructure","configDirectoriesStructure",2);
		dig.addCallParam("root/directoriesStructure",0,"rootDirectory");
		dig.addCallParam("root/directoriesStructure",1,"hashType");
		
		dig.addCallMethod("root/usersDirectory","configUserDirectory",1);
		dig.addCallParam("root/usersDirectory",0,"rootDirectory");
		
		dig.addCallMethod("root/rolesDirectory","configRoleDirectory",3);
		dig.addCallParam("root/rolesDirectory",0,"rootDirectory");
		dig.addCallParam("root/rolesDirectory",1,"localRolesDirectory");
		dig.addCallParam("root/rolesDirectory",2,"uPortalRolesDirectory");
		
		try{
			//  Reading the configuration file
			dig.parse(new InputSource(resourceURL.toExternalForm()));
		}
		catch(SAXException saxException){
			logger.info("HomedirCreationConfig::HomedirCreationConfig::"+saxException);
			throw new ConfigException("HomedirCreationConfig", "HomedirCreationConfig", saxException.getMessage());}
		catch(IOException ioException){
			logger.info("HomedirCreationConfig::HomedirCreationConfig::"+ioException);
			throw new ConfigException("HomedirCreationConfig", "HomedirCreationConfig", ioException.getMessage());
		}
		
	}// Config
	
	/**
	 *
	 * @param serverName Parameter of file Config.xml
	 * @param port Parameter of file Config.xml
	 *
	 */
	public void configLdap(String ldapUrl, String ldapPort, String ldapBaseDn, String ldapScope, String ldapUserUidAttribut, String ldapMaxResults, String ldapPrincipal, String ldapCredential){
		this.ldapUrl = ldapUrl;
		this.ldapPort = ldapPort;
		this.ldapBaseDn = ldapBaseDn;
		this.ldapScope = ldapScope;
		// DEPRECATED
		//this.ldapRequestFilter = ldapRequestFilter;
		this.ldapPrincipal = ldapPrincipal;
		this.ldapCredential = ldapCredential;
		this.ldapUserUidAttribut = ldapUserUidAttribut;
		this.ldapMaxResults = ldapMaxResults;
	}// configLdap
	
	public void configWebdavServer(String webdavServerUrl, String webdavServerLogin, String webdavServerPassword){
		this.webdavServerUrl = webdavServerUrl;
		this.webdavServerLogin = webdavServerLogin;
		this.webdavServerPassword = webdavServerPassword;
		// DEPRECATED
		//this.webdavServerUsersRole = webdavServerUsersRole;
	}// configWebdavServer
	
	public void configDirectoriesStructure(String directoriesStructureRootDirectory, String directoriesStructureHashType){
		this.directoriesStructureRootDirectory = directoriesStructureRootDirectory;
		this.directoriesStructureHashType = directoriesStructureHashType;
	}// configDirectoriesStructure
	
	public void configUserDirectory(String userDirectoryRootDirectory){
		this.userDirectoryRootDirectory = userDirectoryRootDirectory;
	}// configUserDirectory
	
	public void configRoleDirectory(String roleDirectoryRootDirectory, String roleDirectoryLocalRolesDirectory, String roleDirectoryUPortalRolesDirectory){
		this.roleDirectoryRootDirectory = roleDirectoryRootDirectory;
		this.roleDirectoryLocalRolesDirectory = roleDirectoryLocalRolesDirectory;
		this.roleDirectoryUPortalRolesDirectory = roleDirectoryUPortalRolesDirectory;
	}// configUserDirectory
	
	public static Config getInstance() throws ConfigException{
		if(singleton == null) {
			singleton = new Config();
		}
		return singleton;
	}// getInstance
	
	
	/**
	 * @return Returns the singleton.
	 */
	public static Config getSingleton() {
		return singleton;
	}
	/**
	 * @return Returns the directoriesStructureHashType.
	 */
	public String getDirectoriesStructureHashType() {
		return directoriesStructureHashType;
	}
	/**
	 * @return Returns the directoriesStructureRootDirectory.
	 */
	public String getDirectoriesStructureRootDirectory() {
		return directoriesStructureRootDirectory;
	}
	/**
	 * @return Returns the ldapBaseDn.
	 */
	public String getLdapBaseDn() {
		return ldapBaseDn;
	}
	/**
	 * @return Returns the ldapMaxResults.
	 */
	public String getLdapMaxResults() {
		return ldapMaxResults;
	}
	/**
	 * @return Returns the ldapPort.
	 */
	public String getLdapPort() {
		return ldapPort;
	}
	/**
	 * @return Returns the ldapUrl.
	 */
	public String getLdapUrl() {
		return ldapUrl;
	}
	/**
	 * @return Returns the ldapUserUidAttribut.
	 */
	public String getLdapUserUidAttribut() {
		return ldapUserUidAttribut;
	}
	/**
	 * @return Returns the logger.
	 */
	public Logger getLogger() {
		return logger;
	}
	/**
	 * @return Returns the roleDirectoryRootDirectory.
	 */
	public String getRoleDirectoryRootDirectory() {
		return roleDirectoryRootDirectory;
	}
	/**
	 * @return Returns the roleDirectoryLocalRolesDirectory.
	 */
	public String getRoleDirectoryLocalRolesDirectory() {
		return roleDirectoryLocalRolesDirectory;
	}
	/**
	 * @return Returns the roleDirectoryUPortalRolesDirectory.
	 */
	public String getRoleDirectoryUPortalRolesDirectory() {
		return roleDirectoryUPortalRolesDirectory;
	}
	/**
	 * @return Returns the userDirectoryRootDirectory.
	 */
	public String getUserDirectoryRootDirectory() {
		return userDirectoryRootDirectory;
	}
	/**
	 * @return Returns the webdavServerLogin.
	 */
	public String getWebdavServerLogin() {
		return webdavServerLogin;
	}
	/**
	 * @return Returns the webdavServerPassword.
	 */
	public String getWebdavServerPassword() {
		return webdavServerPassword;
	}
	/**
	 * @return Returns the webdavServerUrl.
	 */
	public String getWebdavServerUrl() {
		return webdavServerUrl;
	}
	/**
	 * @return Returns the ldapScope.
	 */
	public String getLdapScope() {
		return ldapScope;
	}
	/**
	 * @return Returns the ldapCredential.
	 */
	public String getLdapCredential() {
		return ldapCredential;
	}
	/**
	 * @return Returns the ldapPrincipal.
	 */
	public String getLdapPrincipal() {
		return ldapPrincipal;
	}
}// HomedirCreation
