/*
 * Decompiled with CFR 0.152.
 */
package org.esupportail.portal.utils.webdav.acl;

import java.util.StringTokenizer;

public class EsupPermission
implements Comparable {
    public static final boolean GRANT = false;
    public static final boolean DENY = true;
    public static final String READ = "read";
    public static final String WRITE = "write";
    public static final String READ_ACL = "read-acl";
    public static final String WRITE_ACL = "write-acl";
    public static final String READ_CURRENT_USER_PRIVILEGE_SET = "read-current-user-privilege-set";
    public static final String WRITE_PROPERTIES = "write-properties";
    public static final String WRITE_CONTENT = "write-content";
    public static final String BIND = "bind";
    public static final String UNBIND = "unbind";
    public static final String UNLOCK = "unlock";
    public static final String ALL = "all";
    public static final String PRINCIPAL_SELF = "self";
    public static final String PRINCIPAL_OWNER = "owner";
    public static final String PRINCIPAL_AUTHENTICATED = "authenticated";
    public static final String PRINCIPAL_UNAUTHENTICATED = "unauthenticated";
    public static final String PRINCIPAL_ALL = "all";
    public static final String PRINCIPAL_PROPERTY = "property";
    private boolean negative;
    private String principal;
    private String permissionType;
    private boolean inherited;
    private String inheritedFrom;
    private boolean protectedPermission;
    private String namespace;
    private String userPrefix;
    private String groupPrefix;
    private String key;

    public EsupPermission(boolean negative, String principal, String permissionType, boolean inherited, String inheritedFrom, boolean protectedPermission, String namespace, String userPrefix, String groupPrefix) {
        this.negative = negative;
        this.principal = principal;
        this.permissionType = permissionType;
        this.inherited = inherited;
        this.inheritedFrom = inheritedFrom;
        this.protectedPermission = protectedPermission;
        this.namespace = namespace;
        this.userPrefix = userPrefix;
        this.groupPrefix = groupPrefix;
        this.generateKey();
    }

    private void generateKey() {
        int principalTypeWeight = -1;
        int groupDepthWeight = 0;
        int authTypeWeight = -1;
        int actionWeight = -1;
        String separator = ":$";
        principalTypeWeight = this.isPrincipalUser() ? 1 : (this.isPrincipalGroup() ? 2 : (this.isPrincipalSelf() ? 3 : (this.isPrincipalOwner() ? 4 : (this.isPrincipalAuthenticated() ? 5 : (this.isPrincipalUnauthenticated() ? 6 : 7)))));
        if (principalTypeWeight == 2) {
            StringTokenizer strToken = new StringTokenizer(this.principal, "/");
            groupDepthWeight = strToken.countTokens();
        }
        authTypeWeight = this.isDenyPermission() ? 0 : 1;
        if (this.permissionType.equals(READ_ACL)) {
            actionWeight = 1;
        } else if (this.permissionType.equals(READ_CURRENT_USER_PRIVILEGE_SET)) {
            actionWeight = 2;
        } else if (this.permissionType.equals(WRITE_ACL)) {
            actionWeight = 3;
        } else if (this.permissionType.equals(WRITE_PROPERTIES)) {
            actionWeight = 4;
        } else if (this.permissionType.equals(WRITE_CONTENT)) {
            actionWeight = 5;
        } else if (this.permissionType.equals(READ)) {
            actionWeight = 6;
        } else if (this.permissionType.equals(WRITE)) {
            actionWeight = 7;
        } else if (this.permissionType.equals(UNLOCK)) {
            actionWeight = 8;
        } else if (this.permissionType.equals(BIND)) {
            actionWeight = 9;
        } else if (this.permissionType.equals(UNBIND)) {
            actionWeight = 10;
        } else if (this.permissionType.equals("all")) {
            actionWeight = 11;
        }
        this.key = principalTypeWeight + separator + groupDepthWeight + separator + authTypeWeight + separator + this.principal + separator + actionWeight;
    }

    public String getKey() {
        return this.key;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public String getInheritedFrom() {
        return this.inheritedFrom;
    }

    public boolean isGrantPermission() {
        return !this.negative;
    }

    public boolean isDenyPermission() {
        return this.negative;
    }

    public String getPermissionType() {
        return this.permissionType;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public boolean isProtectedPermission() {
        return this.protectedPermission;
    }

    public boolean isPrincipalUser() {
        return this.principal.startsWith(this.userPrefix);
    }

    public boolean isPrincipalGroup() {
        return this.principal.startsWith(this.groupPrefix);
    }

    public boolean isPrincipalOwner() {
        return this.principal.equals(PRINCIPAL_OWNER);
    }

    public boolean isPrincipalSelf() {
        return this.principal.equals(PRINCIPAL_SELF);
    }

    public boolean isPrincipalAll() {
        return this.principal.equals("all");
    }

    public boolean isPrincipalUnauthenticated() {
        return this.principal.equals(PRINCIPAL_UNAUTHENTICATED);
    }

    public boolean isPrincipalAuthenticated() {
        return this.principal.equals(PRINCIPAL_AUTHENTICATED);
    }

    public int compareTo(Object arg0) {
        boolean permInherited;
        String separator = ":$";
        StringTokenizer strToken = new StringTokenizer(this.getKey(), separator);
        String thisPrincipalTypeWeight = strToken.nextToken();
        String thisGroupDepthWeight = strToken.nextToken();
        String thisAuthTypeWeight = strToken.nextToken();
        String thisPrincipal = strToken.nextToken();
        String thisActionWeight = strToken.nextToken();
        EsupPermission perm = (EsupPermission)arg0;
        strToken = new StringTokenizer(perm.getKey(), separator);
        String permPrincipalTypeWeight = strToken.nextToken();
        String permGroupDepthWeight = strToken.nextToken();
        String permAuthTypeWeight = strToken.nextToken();
        String permPrincipal = strToken.nextToken();
        String permActionWeight = strToken.nextToken();
        int comp = thisPrincipalTypeWeight.compareTo(permPrincipalTypeWeight);
        if (comp != 0) {
            return comp;
        }
        comp = thisGroupDepthWeight.compareTo(permGroupDepthWeight);
        if (comp != 0) {
            return -comp;
        }
        comp = thisAuthTypeWeight.compareTo(permAuthTypeWeight);
        if (comp != 0) {
            return comp;
        }
        comp = thisPrincipal.compareTo(permPrincipal);
        if (comp != 0) {
            return comp;
        }
        comp = thisActionWeight.compareTo(permActionWeight);
        if (comp != 0) {
            return comp;
        }
        boolean thisInherited = this.isInherited();
        if (thisInherited == (permInherited = perm.isInherited())) {
            String permInheritedFrom;
            if (!thisInherited) {
                return 0;
            }
            String thisInheritedFrom = this.getInheritedFrom();
            if (thisInheritedFrom.equals(permInheritedFrom = perm.getInheritedFrom())) {
                return 0;
            }
            return 1;
        }
        return 1;
    }

    public boolean equals(Object arg0) {
        EsupPermission perm = (EsupPermission)arg0;
        if (this.getPrincipal().equals(perm.getPrincipal()) && this.negative == perm.negative && this.isInherited() == perm.isInherited()) {
            if (this.isInherited() && this.getInheritedFrom() != null && perm.getInheritedFrom() != null && !this.getInheritedFrom().equals(perm.getInheritedFrom())) {
                return false;
            }
            if (this.getPermissionType().equals(perm.getPermissionType()) && this.isProtectedPermission() == perm.isProtectedPermission()) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        String s = "";
        s = s + this.getPrincipal() + " --> ";
        if (this.isDenyPermission()) {
            s = s + "deny ";
        }
        if (this.isGrantPermission()) {
            s = s + "grant ";
        }
        s = s + this.getPermissionType() + " ";
        s = this.isProtectedPermission() ? s + "(protected) " : s + "(not protected) ";
        s = this.isInherited() ? s + "(inherited from " + this.getInheritedFrom() + ") " : s + "(not inherited) ";
        return s;
    }
}

