/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.common;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.slide.common.PropertyParseException;
import org.apache.slide.common.RequestedProperties;
import org.apache.slide.common.RequestedProperty;
import org.apache.slide.common.RequestedPropertyImpl;
import org.apache.slide.content.NodeProperty;
import org.jdom.Element;

public class RequestedPropertiesImpl
implements RequestedProperties {
    protected boolean isAllProp = false;
    protected List propertyList = new ArrayList();

    public RequestedPropertiesImpl() {
    }

    public RequestedPropertiesImpl(Element propElement) throws PropertyParseException {
        this.add(propElement);
    }

    public void add(Element propElement) throws PropertyParseException {
        String uri = propElement.getNamespace().getURI();
        String prefix = propElement.getNamespace().getPrefix();
        String name = propElement.getName();
        if (name.equals("allprop") && uri.equals("DAV:")) {
            this.isAllProp = true;
        } else {
            Iterator it = propElement.getChildren().iterator();
            while (it.hasNext()) {
                Element prop = (Element)it.next();
                uri = prop.getNamespace().getURI();
                prefix = prop.getNamespace().getPrefix();
                name = prop.getName();
                if (uri.equals("DAV:") && name.equals("property")) {
                    name = prop.getAttributeValue("name");
                    if (prop.getAttributeValue("namespace") != null) {
                        uri = prop.getAttributeValue("namespace");
                        prefix = "";
                    }
                }
                this.addProperty(this.createRequestedProperty(name, prefix, uri, prop.getContent()));
            }
        }
    }

    protected RequestedProperty createRequestedProperty(String name, String namespacePrefix, String namespaceUri, List content) throws PropertyParseException {
        return new RequestedPropertyImpl(name, namespaceUri);
    }

    public Iterator iterator() {
        if (this.isAllProp) {
            throw new IllegalStateException();
        }
        return this.propertyList.iterator();
    }

    public Iterator getRequestedProperties() {
        if (this.isAllProp) {
            throw new IllegalStateException();
        }
        return this.propertyList.iterator();
    }

    public boolean isAllProp() {
        return this.isAllProp;
    }

    public void setIsAllProp(boolean isAllProp) {
        this.isAllProp = isAllProp;
    }

    public boolean contains(String name, String namespace) {
        if (this.isAllProp) {
            return true;
        }
        RequestedPropertyImpl prop = new RequestedPropertyImpl(name, namespace);
        return this.propertyList.contains(prop);
    }

    public boolean contains(NodeProperty property) {
        if (this.isAllProp) {
            return true;
        }
        RequestedPropertyImpl prop = new RequestedPropertyImpl(property.getName(), property.getNamespace());
        return this.propertyList.contains(prop);
    }

    public String toString() {
        Iterator it = this.iterator();
        StringBuffer sb = new StringBuffer();
        while (it.hasNext()) {
            sb.append(((RequestedProperty)it.next()).toString());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public void addProperty(RequestedProperty prop) {
        if (this.isAllProp) {
            throw new IllegalStateException();
        }
        this.propertyList.add(prop);
    }
}

