/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.event;

import java.util.EventListener;
import java.util.EventObject;
import org.apache.slide.common.Namespace;
import org.apache.slide.common.SlideToken;
import org.apache.slide.common.Uri;
import org.apache.slide.event.AbstractEventMethod;
import org.apache.slide.event.LockListener;
import org.apache.slide.event.VetoException;
import org.apache.slide.event.VetoableEventMethod;

public class LockEvent
extends EventObject {
    public static final Lock LOCK = new Lock();
    public static final Unlock UNLOCK = new Unlock();
    public static final Renew RENEW = new Renew();
    public static final Kill KILL = new Kill();
    public static final String GROUP = "lock";
    public static final AbstractEventMethod[] methods = new AbstractEventMethod[]{LOCK, UNLOCK, RENEW, KILL};
    private Uri objectUri;
    private Namespace namespace;
    private SlideToken token;

    public LockEvent(Object source, SlideToken token, Namespace namespace, Uri objectUri) {
        super(source);
        this.objectUri = objectUri;
        this.token = token;
        this.namespace = namespace;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append(this.getClass().getName()).append("[lock uri=").append(this.objectUri);
        buffer.append("]");
        return buffer.toString();
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public SlideToken getToken() {
        return this.token;
    }

    public static final class Kill
    extends VetoableEventMethod {
        public Kill() {
            super(LockEvent.GROUP, "kill");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException {
            if (listener instanceof LockListener) {
                ((LockListener)listener).kill((LockEvent)event);
            }
        }
    }

    public static final class Renew
    extends VetoableEventMethod {
        public Renew() {
            super(LockEvent.GROUP, "renew");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException {
            if (listener instanceof LockListener) {
                ((LockListener)listener).renew((LockEvent)event);
            }
        }
    }

    public static final class Unlock
    extends VetoableEventMethod {
        public Unlock() {
            super(LockEvent.GROUP, "unlock");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException {
            if (listener instanceof LockListener) {
                ((LockListener)listener).unlock((LockEvent)event);
            }
        }
    }

    public static final class Lock
    extends VetoableEventMethod {
        public Lock() {
            super(LockEvent.GROUP, LockEvent.GROUP);
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException {
            if (listener instanceof LockListener) {
                ((LockListener)listener).lock((LockEvent)event);
            }
        }
    }
}

