/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.encryption;

import java.io.IOException;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSInteger;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSNumber;
import org.pdfbox.cos.COSString;
import org.pdfbox.pdmodel.encryption.PDEncryptionDictionary;

public class PDStandardEncryption
extends PDEncryptionDictionary {
    public static final String FILTER_NAME = "Standard";
    public static final int DEFAULT_REVISION = 3;
    private static final int PRINT_BIT = 3;
    private static final int MODIFICATION_BIT = 4;
    private static final int EXTRACT_BIT = 5;
    private static final int MODIFY_ANNOTATIONS_BIT = 6;
    private static final int FILL_IN_FORM_BIT = 9;
    private static final int EXTRACT_FOR_ACCESSIBILITY_BIT = 10;
    private static final int ASSEMBLE_DOCUMENT_BIT = 11;
    private static final int DEGRADED_PRINT_BIT = 12;

    public PDStandardEncryption() {
        this.encryptionDictionary.setItem(COSName.FILTER, new COSString(FILTER_NAME));
        this.setRevision(3);
        this.setVersion(2);
    }

    public PDStandardEncryption(COSDictionary dict) {
        super(dict);
    }

    public int getRevision() {
        int revision = 0;
        COSNumber cosRevision = (COSNumber)this.encryptionDictionary.getDictionaryObject(COSName.getPDFName("R"));
        if (cosRevision != null) {
            revision = cosRevision.intValue();
        }
        return revision;
    }

    public void setRevision(int revision) {
        this.encryptionDictionary.setItem(COSName.getPDFName("R"), new COSInteger(revision));
    }

    public byte[] getOwnerKey() {
        byte[] o = null;
        COSString owner = (COSString)this.encryptionDictionary.getDictionaryObject(COSName.getPDFName("O"));
        if (owner != null) {
            o = owner.getBytes();
        }
        return o;
    }

    public void setOwnerKey(byte[] o) throws IOException {
        COSString owner = new COSString();
        owner.append(o);
        this.encryptionDictionary.setItem(COSName.getPDFName("O"), owner);
    }

    public byte[] getUserKey() {
        byte[] u = null;
        COSString user = (COSString)this.encryptionDictionary.getDictionaryObject(COSName.getPDFName("U"));
        if (user != null) {
            u = user.getBytes();
        }
        return u;
    }

    public void setUserKey(byte[] u) throws IOException {
        COSString user = new COSString();
        user.append(u);
        this.encryptionDictionary.setItem(COSName.getPDFName("U"), user);
    }

    public int getPermissions() {
        int permissions = 0;
        COSInteger p = (COSInteger)this.encryptionDictionary.getDictionaryObject(COSName.getPDFName("P"));
        if (p != null) {
            permissions = p.intValue();
        }
        return permissions;
    }

    public void setPermissions(int p) {
        this.encryptionDictionary.setItem(COSName.getPDFName("P"), new COSInteger(p));
    }

    private boolean isPermissionBitOn(int bit) {
        return (this.getPermissions() & 1 << bit - 1) != 0;
    }

    private boolean setPermissionBit(int bit, boolean value) {
        int permissions = this.getPermissions();
        permissions = value ? (permissions |= 1 << bit - 1) : (permissions &= 0xFFFFFFFF ^ 1 << bit - 1);
        return (this.getPermissions() & 1 << bit - 1) != 0;
    }

    public boolean canPrint() {
        return this.isPermissionBitOn(3);
    }

    public void setCanPrint(boolean allowPrinting) {
        this.setPermissionBit(3, allowPrinting);
    }

    public boolean canModify() {
        return this.isPermissionBitOn(4);
    }

    public void setCanModify(boolean allowModifications) {
        this.setPermissionBit(4, allowModifications);
    }

    public boolean canExtractContent() {
        return this.isPermissionBitOn(5);
    }

    public void setCanExtractContent(boolean allowExtraction) {
        this.setPermissionBit(5, allowExtraction);
    }

    public boolean canModifyAnnotations() {
        return this.isPermissionBitOn(6);
    }

    public void setCanModifyAnnotations(boolean allowAnnotationModification) {
        this.setPermissionBit(6, allowAnnotationModification);
    }

    public boolean canFillInForm() {
        return this.isPermissionBitOn(9);
    }

    public void setCanFillInForm(boolean allowFillingInForm) {
        this.setPermissionBit(9, allowFillingInForm);
    }

    public boolean canExtractForAccessibility() {
        return this.isPermissionBitOn(10);
    }

    public void setCanExtractForAccessibility(boolean allowExtraction) {
        this.setPermissionBit(10, allowExtraction);
    }

    public boolean canAssembleDocument() {
        return this.isPermissionBitOn(11);
    }

    public void setCanAssembleDocument(boolean allowAssembly) {
        this.setPermissionBit(11, allowAssembly);
    }

    public boolean canPrintDegraded() {
        return this.isPermissionBitOn(12);
    }

    public void setCanPrintDegraded(boolean allowAssembly) {
        this.setPermissionBit(12, allowAssembly);
    }
}

